/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.client.renderer;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockBEHelperMaster;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.registry.MultiblockBlockEntityMaster;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockOrientation;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import mctmods.immersivetechnology.client.models.SolarReflectorModels;
import mctmods.immersivetechnology.client.models.helper.ITDynamicModel;
import mctmods.immersivetechnology.client.renderer.helper.ITBaseBlockEntityRenderer;
import mctmods.immersivetechnology.client.renderer.helper.ITRenderUtils;
import mctmods.immersivetechnology.common.multiblocks.metal.logic.SolarReflectorLogic;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class SolarReflectorRenderer
extends ITBaseBlockEntityRenderer<MultiblockBlockEntityMaster<SolarReflectorLogic.State>> {
    public void render(@NotNull MultiblockBlockEntityMaster<SolarReflectorLogic.State> tile, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight, int packedOverlay) {
        IMultiblockBEHelperMaster helper = tile.getHelper();
        IMultiblockContext context = helper.getContext();
        SolarReflectorLogic.State state = (SolarReflectorLogic.State)context.getState();
        MultiblockOrientation orientation = context.getLevel().getOrientation();
        BlockPos pos = tile.m_58899_();
        Level level = tile.m_58904_();
        Direction dir = orientation.front();
        double supportAngle = state.animation_supportRotation;
        double mirrorAngle = state.animation_mirrorTilt;
        ITDynamicModel supportModel = SolarReflectorModels.SUPPORT;
        ITDynamicModel mirrorModel = SolarReflectorModels.MIRROR;
        Vec3 start = Vec3.m_82528_((Vec3i)context.getLevel().toAbsolute(new BlockPos(1, 0, 1)).m_121996_((Vec3i)pos));
        boolean isEW = dir.m_122429_() != 0;
        Quaternionf orientRot = isEW ? new Quaternionf().rotateY((float)Math.toRadians(90.0)) : new Quaternionf();
        Quaternionf rotY = new Quaternionf().rotateY((float)(supportAngle * 0.01745329238474369));
        Vector3f axis = new Vector3f((float)dir.m_122431_(), 0.0f, (float)dir.m_122429_());
        orientRot.transform(axis);
        poseStack.m_85836_();
        poseStack.m_85837_(start.f_82479_ + 0.5, start.f_82480_, start.f_82481_ + 0.5);
        poseStack.m_252781_(orientRot);
        poseStack.m_252781_(rotY);
        this.renderDynamicModel(supportModel, poseStack, buffer, level, pos, packedLight);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_85837_(start.f_82479_ + 0.5, start.f_82480_, start.f_82481_ + 0.5);
        poseStack.m_252781_(orientRot);
        poseStack.m_252781_(rotY);
        poseStack.m_252880_(0.0f, 2.0f, 0.0f);
        poseStack.m_252781_(new Quaternionf().rotateAxis((float)(-mirrorAngle * 0.01745329238474369), (Vector3fc)axis));
        poseStack.m_252880_(0.0f, -2.0f, 0.0f);
        this.renderDynamicModel(mirrorModel, poseStack, buffer, level, pos, packedLight);
        poseStack.m_85849_();
    }

    private void renderDynamicModel(ITDynamicModel model, PoseStack matrix, MultiBufferSource buffer, Level level, BlockPos pos, int light) {
        matrix.m_85836_();
        List quads = model.get().getQuads(null, null, ApiUtils.RANDOM_SOURCE, ModelData.EMPTY, null);
        ITRenderUtils.renderModelTESRFancy(quads, buffer.m_6299_(RenderType.m_110451_()), matrix, level, pos, false, 0xFFFFFF, light);
        matrix.m_85849_();
    }
}

