/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.client.renderer;

import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.multiblocks.blocks.registry.MultiblockBlockEntityMaster;
import com.mojang.blaze3d.vertex.PoseStack;
import mctmods.immersivetechnology.client.particles.ColoredBeam;
import mctmods.immersivetechnology.client.renderer.helper.ITBaseBlockEntityRenderer;
import mctmods.immersivetechnology.common.multiblocks.metal.logic.SolarMelterLogic;
import mctmods.immersivetechnology.common.multiblocks.metal.recipe.SolarMelterRecipe;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class SolarMelterRenderer
extends ITBaseBlockEntityRenderer<MultiblockBlockEntityMaster<SolarMelterLogic.State>> {
    private static final ResourceLocation BEAM_TEXTURE = ResourceLocation.withDefaultNamespace((String)"textures/entity/beacon_beam.png");

    public void render(MultiblockBlockEntityMaster<SolarMelterLogic.State> be, float partialTicks, @NotNull PoseStack matrixStack, @NotNull MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        SolarMelterRecipe recipe;
        SolarMelterLogic.State state = (SolarMelterLogic.State)be.getHelper().getState();
        IMultiblockContext ctx = be.getHelper().getContext();
        IMultiblockLevel mLevel = ctx.getLevel();
        Level level = be.m_58904_();
        FluidStack fs = state.tanks.input().getFluid();
        double maxHeat = 1000.0;
        if (fs.getAmount() > 0 && (recipe = SolarMelterRecipe.findRecipe(level, fs)) != null) {
            maxHeat = recipe.requiredTemp;
        }
        if (state.heatLevel < maxHeat || !state.sunVisible || state.reflectorStrength <= 0.0) {
            return;
        }
        BlockPos masterPos = be.m_58899_();
        BlockPos particlePos = mLevel.toAbsolute(SolarMelterLogic.PARTICLE_POI);
        BlockPos centerBottomPos = mLevel.toAbsolute(new BlockPos(SolarMelterLogic.PARTICLE_POI.m_123341_(), 0, SolarMelterLogic.PARTICLE_POI.m_123343_()));
        double relX = centerBottomPos.m_123341_() - masterPos.m_123341_();
        double relY = centerBottomPos.m_123342_() - masterPos.m_123342_();
        double relZ = centerBottomPos.m_123343_() - masterPos.m_123343_();
        matrixStack.m_85836_();
        matrixStack.m_85837_(relX, relY, relZ);
        assert (level != null);
        long time = level.m_46467_();
        float innerBottomG = 1.0f;
        float innerTopG = 0.0f;
        float innerA = 1.0f;
        float outerBottomG = 1.0f;
        float outerTopG = 0.0f;
        float outerA = 0.2f;
        double worldX = (double)centerBottomPos.m_123341_() + 0.5;
        double worldZ = (double)centerBottomPos.m_123343_() + 0.5;
        double worldYBottom = particlePos.m_123342_();
        double worldYTop = (double)particlePos.m_123342_() + 16.0;
        ColoredBeam.renderBeam(matrixStack, bufferIn, BEAM_TEXTURE, partialTicks, 1.0f, time, false, innerBottomG, innerTopG, innerA, outerBottomG, outerTopG, outerA, 2.0f, 18.0f, worldX, worldYBottom, worldYTop, worldZ);
        matrixStack.m_85849_();
    }

    public boolean shouldRenderOffScreen(@NotNull MultiblockBlockEntityMaster<SolarMelterLogic.State> be) {
        return true;
    }
}

