/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mctmods.immersivetechnology.client.renderer.helper.ITBaseBlockEntityRenderer;
import mctmods.immersivetechnology.common.blocks.metal.logic.BarrelOpenBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class OpenBarrelRenderer
extends ITBaseBlockEntityRenderer<BarrelOpenBlockEntity> {
    public void render(BarrelOpenBlockEntity be, float partialTicks, @NotNull PoseStack matrixStack, @NotNull MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        FluidState fluidState;
        BakedModel model = Minecraft.m_91087_().m_91289_().m_110910_(be.m_58900_());
        RandomSource random = RandomSource.m_216335_((long)be.m_58900_().m_60726_(be.m_58899_()));
        ModelData modelData = ModelData.EMPTY;
        for (RenderType rt : model.getRenderTypes(be.m_58900_(), random, modelData)) {
            VertexConsumer consumer = buffer.m_6299_(rt);
            assert (be.m_58904_() != null);
            Minecraft.m_91087_().m_91289_().m_110937_().tesselateBlock((BlockAndTintGetter)be.m_58904_(), model, be.m_58900_(), be.m_58899_(), matrixStack, consumer, true, random, be.m_58900_().m_60726_(be.m_58899_()), OverlayTexture.f_118083_, modelData, rt);
        }
        FluidStack fluidStack = be.tank.getFluid();
        if (fluidStack.isEmpty()) {
            return;
        }
        Fluid fluid = fluidStack.getFluid();
        if (fluid == null) {
            return;
        }
        IClientFluidTypeExtensions extensions = IClientFluidTypeExtensions.of((Fluid)fluid);
        int color = extensions.getTintColor(fluidState = fluid.m_76145_(), (BlockAndTintGetter)be.m_58904_(), be.m_58899_());
        if (color >>> 24 == 0) {
            color |= 0xFF000000;
        }
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        ResourceLocation still = extensions.getStillTexture(fluidStack);
        ResourceLocation blockAtlas = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/atlas/blocks.png");
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(blockAtlas).apply(still);
        if (sprite == null) {
            return;
        }
        float minU = sprite.m_118409_();
        float maxU = sprite.m_118410_();
        float minV = sprite.m_118411_();
        float maxV = sprite.m_118412_();
        float diffU = maxU - minU;
        float diffV = maxV - minV;
        float multiplier = 0.25f;
        minU += diffU * multiplier;
        maxU -= diffU * multiplier;
        minV += diffV * multiplier;
        maxV -= diffV * multiplier;
        Level level = be.m_58904_();
        BlockPos pos = be.m_58899_();
        if (level == null) {
            return;
        }
        int blockLight = level.m_45517_(LightLayer.BLOCK, pos);
        int skyLight = level.m_45517_(LightLayer.SKY, pos);
        int luminosity = fluid.getFluidType().getLightLevel(fluidStack);
        blockLight = Math.max(blockLight, luminosity);
        int packedLight = skyLight << 20 | blockLight << 4;
        float ratio = (float)fluidStack.getAmount() / (float)be.tank.getCapacity();
        float yFilled = 0.8125f * ratio;
        float yStartOffset = 0.125f;
        float fluidHeight = yStartOffset + yFilled;
        float startPos = 0.0625f;
        float endPos = 1.0f - startPos;
        VertexConsumer builder = buffer.m_6299_(RenderType.m_110466_());
        matrixStack.m_85836_();
        matrixStack.m_252880_(0.0f, 0.001f, 0.0f);
        Matrix4f pose = matrixStack.m_85850_().m_252922_();
        Matrix3f normalMatrix = matrixStack.m_85850_().m_252943_();
        float nx = 0.0f;
        float ny = 1.0f;
        float nz = 0.0f;
        builder.m_252986_(pose, startPos, fluidHeight, startPos).m_85950_(r, g, b, a).m_7421_(minU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normalMatrix, nx, ny, nz).m_5752_();
        builder.m_252986_(pose, startPos, fluidHeight, endPos).m_85950_(r, g, b, a).m_7421_(minU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normalMatrix, nx, ny, nz).m_5752_();
        builder.m_252986_(pose, endPos, fluidHeight, endPos).m_85950_(r, g, b, a).m_7421_(maxU, maxV).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normalMatrix, nx, ny, nz).m_5752_();
        builder.m_252986_(pose, endPos, fluidHeight, startPos).m_85950_(r, g, b, a).m_7421_(maxU, minV).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normalMatrix, nx, ny, nz).m_5752_();
        matrixStack.m_85849_();
    }
}

