/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.client.models.split;

import blusunrize.immersiveengineering.api.client.IModelOffsetProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import malte0811.modelsplitter.ClumpedModel;
import malte0811.modelsplitter.SplitModel;
import malte0811.modelsplitter.math.ModelSplitterVec3i;
import malte0811.modelsplitter.model.OBJModel;
import malte0811.modelsplitter.model.Polygon;
import mctmods.immersivetechnology.client.models.helper.ITCompositeBakedModel;
import mctmods.immersivetechnology.client.models.split.ITPolygonUtils;
import mctmods.immersivetechnology.common.blocks.helper.ITProperties;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;

public abstract class ITAbstractSplitModel<T extends BakedModel>
extends ITCompositeBakedModel<T> {
    @Nonnull
    private final Vec3i size;

    public ITAbstractSplitModel(T base, @NotNull Vec3i size) {
        super(base);
        this.size = size;
    }

    @Override
    @Nonnull
    public ModelData getModelData(@Nonnull BlockAndTintGetter world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull ModelData tileData) {
        ModelData baseData = super.getModelData(world, pos, state, tileData);
        BlockEntity te = world.m_7702_(pos);
        BlockPos offset = null;
        if (te instanceof IModelOffsetProvider) {
            IModelOffsetProvider offsetProvider = (IModelOffsetProvider)te;
            offset = offsetProvider.getModelOffset(state, this.size);
        } else {
            Block block = state.m_60734_();
            if (block instanceof IModelOffsetProvider) {
                IModelOffsetProvider offsetProvider = (IModelOffsetProvider)block;
                offset = offsetProvider.getModelOffset(state, this.size);
            }
        }
        if (offset != null) {
            return baseData.derive().with(ITProperties.Model.SUBMODEL_OFFSET, (Object)offset).build();
        }
        return baseData;
    }

    protected Map<Vec3i, List<BakedQuad>> split(List<BakedQuad> in, Set<Vec3i> parts, ModelState transform) {
        List polys = in.stream().map(ITPolygonUtils::toPolygon).collect(Collectors.toList());
        SplitModel splitData = new SplitModel(new OBJModel(polys));
        Set partsBMS = parts.stream().map(v -> new ModelSplitterVec3i(v.m_123341_(), v.m_123342_(), v.m_123343_())).collect(Collectors.toSet());
        ClumpedModel clumpedModel = new ClumpedModel(splitData, partsBMS);
        HashMap<Vec3i, List<BakedQuad>> map = new HashMap<Vec3i, List<BakedQuad>>();
        for (Map.Entry e : clumpedModel.getClumpedParts().entrySet()) {
            ArrayList<BakedQuad> subModelFaces = new ArrayList<BakedQuad>(((OBJModel)e.getValue()).getFaces().size());
            for (Polygon p : ((OBJModel)e.getValue()).getFaces()) {
                subModelFaces.add(ITPolygonUtils.toBakedQuad((Polygon<ITPolygonUtils.ExtraQuadData>)p, transform));
            }
            Vec3i mcKey = new Vec3i(((ModelSplitterVec3i)e.getKey()).x(), ((ModelSplitterVec3i)e.getKey()).y(), ((ModelSplitterVec3i)e.getKey()).z());
            map.put(mcKey, subModelFaces);
        }
        return map;
    }
}

