/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.client.models.mirror;

import blusunrize.immersiveengineering.api.ApiUtils;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mctmods.immersivetechnology.client.models.mirror.ITMirroredGeometry;
import mctmods.immersivetechnology.client.models.util.ITModelUtils;
import mctmods.immersivetechnology.core.lib.ITLib;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.ExtendedBlockModelDeserializer;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.geometry.IGeometryLoader;

public class ITMirroredModelLoader
implements IGeometryLoader<ITMirroredGeometry> {
    public static final String INNER_MODEL = "inner_model";
    public static final ResourceLocation ID = ITLib.rl("mirror");

    public ITMirroredGeometry read(JsonObject modelContents, JsonDeserializationContext deserializationContext) throws JsonParseException {
        JsonElement innerJson = modelContents.get(INNER_MODEL);
        BlockModel baseModel = (BlockModel)ExtendedBlockModelDeserializer.INSTANCE.fromJson(innerJson, BlockModel.class);
        return new ITMirroredGeometry((UnbakedModel)baseModel);
    }

    public static List<BakedQuad> reversedQuads(List<BakedQuad> quads) {
        return quads.stream().map(ITModelUtils::reverseOrder).toList();
    }

    public static List<BakedQuad> getReversedQuads(BakedModel model, @Nullable BlockState state, @Nullable Direction side, @Nonnull RandomSource rand, @Nonnull ModelData extraData, @Nullable RenderType layer) {
        return ITMirroredModelLoader.reversedQuads(model.getQuads(state, side, rand, extraData, layer));
    }

    public static List<BakedQuad> getReversedQuads(SimpleBakedModel model, @Nullable Direction face) {
        return ITMirroredModelLoader.getReversedQuads((BakedModel)model, null, face, ApiUtils.RANDOM_SOURCE, ModelData.EMPTY, null);
    }
}

