/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.client.gui;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import mctmods.immersivetechnology.client.gui.helper.ITContainerScreen;
import mctmods.immersivetechnology.client.gui.helper.ITFluidInfoArea;
import mctmods.immersivetechnology.client.gui.helper.ITInfoArea;
import mctmods.immersivetechnology.common.multiblocks.gui.SolarMenu;
import mctmods.immersivetechnology.common.multiblocks.metal.recipe.SolarMelterRecipe;
import mctmods.immersivetechnology.common.multiblocks.metal.recipe.SolarTowerRecipe;
import mctmods.immersivetechnology.common.util.TranslationKey;
import mctmods.immersivetechnology.core.lib.ITLib;
import mctmods.immersivetechnology.core.registration.ITMenuTypes;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;

public class SolarScreen
extends ITContainerScreen<SolarMenu> {
    private static final ResourceLocation TEXTURE = ITLib.makeTextureLocation("solar");
    public final boolean isMelter;

    public SolarScreen(SolarMenu container, Inventory inventoryPlayer, Component title) {
        super(container, inventoryPlayer, title, TEXTURE);
        this.isMelter = ((SolarMenu)this.f_97732_).m_6772_() == ITMenuTypes.SOLAR_MELTER_MENU.getType();
    }

    @Override
    @Nonnull
    protected List<ITInfoArea> makeInfoAreas() {
        return ImmutableList.of((Object)new ITFluidInfoArea((IFluidTank)((SolarMenu)this.f_97732_).inputTank, new Rect2i(this.f_97735_ + 102, this.f_97736_ + 21, 16, 47), 177, 31, 20, 51, TEXTURE), (Object)new ITFluidInfoArea((IFluidTank)((SolarMenu)this.f_97732_).outputTank, new Rect2i(this.f_97735_ + 126, this.f_97736_ + 21, 16, 47), 177, 31, 20, 51, TEXTURE));
    }

    @Override
    protected void drawContainerBackgroundPre(@Nonnull GuiGraphics graphics, float f, int mx, int my) {
        double heatLevel = ((SolarMenu)this.f_97732_).state.m_6413_(0);
        double max = this.getMaxHeat();
        int heatBarSize = (int)Math.round(42.0 * Math.min(1.0, heatLevel / max));
        graphics.m_280218_(TEXTURE, this.f_97735_ + 16, this.f_97736_ + 9, 176, 0, heatBarSize, 9);
        int[] counts = new int[]{((SolarMenu)this.f_97732_).state.m_6413_(2), ((SolarMenu)this.f_97732_).state.m_6413_(3), ((SolarMenu)this.f_97732_).state.m_6413_(4), ((SolarMenu)this.f_97732_).state.m_6413_(5)};
        assert (this.f_96541_ != null);
        assert (this.f_96541_.f_91074_ != null);
        Direction front = Direction.m_122364_((double)this.f_96541_.f_91074_.m_146908_());
        Direction right = front.m_122427_();
        Direction back = front.m_122424_();
        Direction left = front.m_122428_();
        int bit_front = SolarScreen.getBitForDir(front);
        int bit_right = SolarScreen.getBitForDir(right);
        int bit_back = SolarScreen.getBitForDir(back);
        int bit_left = SolarScreen.getBitForDir(left);
        int[][] blitCoordinates = new int[][]{{32, 24}, {48, 40}, {32, 56}, {16, 40}};
        String[] labels = new String[]{TranslationKey.GUI_DIRECTION_NORTH.text(), TranslationKey.GUI_DIRECTION_EAST.text(), TranslationKey.GUI_DIRECTION_SOUTH.text(), TranslationKey.GUI_DIRECTION_WEST.text()};
        boolean canHeat = ((SolarMenu)this.f_97732_).state.m_6413_(1) > 0 && this.f_96541_.f_91073_ != null && !this.f_96541_.f_91073_.m_46471_() && ((SolarMenu)this.f_97732_).state.m_6413_(7) == 1;
        for (int pos = 0; pos < 4; ++pos) {
            int bit;
            switch (pos) {
                case 0: {
                    int n = bit_front;
                    break;
                }
                case 1: {
                    int n = bit_right;
                    break;
                }
                case 2: {
                    int n = bit_back;
                    break;
                }
                case 3: {
                    int n = bit_left;
                    break;
                }
                default: {
                    int n = bit = -1;
                }
            }
            if (bit < 0 || counts[bit] <= 0) continue;
            int x = this.f_97735_ + blitCoordinates[pos][0];
            int y = this.f_97736_ + blitCoordinates[pos][1];
            if (canHeat) {
                float brightness = (float)Math.min(5, counts[bit]) / 5.0f;
                graphics.m_280246_(brightness, brightness, brightness, 1.0f);
                graphics.m_280218_(TEXTURE, x, y, 198, 31, 10, 10);
                graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
            }
            graphics.m_280056_(this.f_96547_, labels[bit], x + 3, y + 2, 0x606060, false);
        }
    }

    private static int getBitForDir(Direction d) {
        return switch (d) {
            case Direction.NORTH -> 0;
            case Direction.EAST -> 1;
            case Direction.SOUTH -> 2;
            case Direction.WEST -> 3;
            default -> -1;
        };
    }

    private double getMaxHeat() {
        double workingHeat = this.isMelter ? 1000.0 : 400.0;
        FluidStack fs = ((SolarMenu)this.f_97732_).inputTank.getFluid();
        if (fs.getAmount() <= 0) {
            return workingHeat;
        }
        assert (this.f_96541_ != null);
        if (this.isMelter) {
            SolarMelterRecipe recipe = SolarMelterRecipe.findRecipe((Level)this.f_96541_.f_91073_, fs);
            if (recipe == null) {
                return workingHeat;
            }
            return recipe.requiredTemp;
        }
        SolarTowerRecipe recipe = SolarTowerRecipe.findRecipe((Level)this.f_96541_.f_91073_, fs);
        if (recipe == null) {
            return workingHeat;
        }
        return recipe.requiredTemp;
    }

    @Override
    protected void gatherAdditionalTooltips(int mouseX, int mouseY, Consumer<Component> addLine, Consumer<Component> addGray) {
        if (mouseX >= this.f_97735_ + 16 && mouseX < this.f_97735_ + 58 && mouseY >= this.f_97736_ + 9 && mouseY < this.f_97736_ + 17) {
            double heat = ((SolarMenu)this.f_97732_).state.m_6413_(0);
            double maxHeat = this.getMaxHeat();
            addLine.accept((Component)Component.m_237115_((String)TranslationKey.GUI_TEMPERATURE.getLocation()));
            addLine.accept((Component)Component.m_237110_((String)TranslationKey.GUI_HEAT_LEVEL_DETAILED.getLocation(), (Object[])new Object[]{heat, maxHeat}).m_130940_(ChatFormatting.RED));
        }
    }
}

