/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.client.gui;

import mctmods.immersivetechnology.common.blocks.metal.gui.RotorCreativeMenu;
import mctmods.immersivetechnology.common.blocks.metal.logic.RotorCreativeBlockEntity;
import mctmods.immersivetechnology.common.network.ITMessageTileSync;
import mctmods.immersivetechnology.common.network.ITPacketHandler;
import mctmods.immersivetechnology.common.util.TranslationKey;
import mctmods.immersivetechnology.core.lib.ITLib;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.NotNull;

public class RotorCreativeScreen
extends AbstractContainerScreen<RotorCreativeMenu> {
    private static final ResourceLocation TEXTURE = ITLib.makeTextureLocation("rotor");
    private final RotorCreativeBlockEntity tile;
    private EditBox rpmField;
    private int prevRpm = Integer.MIN_VALUE;

    public RotorCreativeScreen(RotorCreativeMenu menu, Inventory inv) {
        super((AbstractContainerMenu)menu, inv, (Component)Component.m_237119_());
        this.tile = menu.tile;
        this.f_97726_ = 96;
        this.f_97727_ = 112;
        this.f_97731_ = -1000;
        this.f_97729_ = -1000;
    }

    private boolean isValidInput(String s) {
        if (s.isEmpty() || s.equals("-")) {
            return true;
        }
        try {
            Integer.parseInt(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public void m_7856_() {
        super.m_7856_();
        this.rpmField = new EditBox(this.f_96547_, this.f_97735_ + 36, this.f_97736_ + 30, 30, 9, (Component)Component.m_237119_());
        this.rpmField.m_94153_(this::isValidInput);
        this.rpmField.m_94182_(false);
        this.m_142416_((GuiEventListener)this.rpmField);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)TranslationKey.GUI_APPLY.location), btn -> this.apply()).m_252987_(this.f_97735_ + (this.f_97726_ / 2 - 20), this.f_97736_ + 90, 40, 20).m_253136_());
        this.updateFields();
    }

    private void updateFields() {
        int r = ((RotorCreativeMenu)this.f_97732_).getRpm();
        if (r != this.prevRpm) {
            this.rpmField.m_94144_(r == 0 ? "" : String.valueOf(r));
            this.prevRpm = r;
        }
    }

    private void apply() {
        String rStr = this.rpmField.m_94155_();
        int r = rStr.isEmpty() || rStr.equals("-") ? 0 : Integer.parseInt(rStr);
        CompoundTag message = new CompoundTag();
        message.m_128405_("rpm", r);
        ITPacketHandler.sendToServer(new ITMessageTileSync(this.tile.m_58899_(), message));
        Minecraft.m_91087_().m_91152_(null);
    }

    public void m_181908_() {
        super.m_181908_();
        this.updateFields();
    }

    public void m_7379_() {
        super.m_7379_();
    }

    protected void m_7286_(@NotNull GuiGraphics graphics, float pt, int mx, int my) {
        this.m_280273_(graphics);
        graphics.m_280163_(TEXTURE, this.f_97735_, this.f_97736_, 0.0f, 0.0f, this.f_97726_, 48, 96, 48);
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mx, int my, float pt) {
        super.m_88315_(graphics, mx, my, pt);
        graphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)TranslationKey.GUI_ROTOR_CREATIVE_RPM.getLocation()), this.rpmField.m_252754_() + this.rpmField.m_5711_() + 4, this.rpmField.m_252907_(), 0xFFFFFF, false);
    }

    protected void m_280003_(@NotNull GuiGraphics graphics, int mx, int my) {
    }
}

