/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.client.gui;

import blusunrize.immersiveengineering.api.client.TextUtils;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import mctmods.immersivetechnology.client.gui.helper.ITContainerScreen;
import mctmods.immersivetechnology.client.gui.helper.ITFluidInfoArea;
import mctmods.immersivetechnology.client.gui.helper.ITInfoArea;
import mctmods.immersivetechnology.common.multiblocks.gui.BoilerLiquidMenu;
import mctmods.immersivetechnology.common.util.TranslationKey;
import mctmods.immersivetechnology.core.lib.ITLib;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.fluids.IFluidTank;

public class BoilerLiquidScreen
extends ITContainerScreen<BoilerLiquidMenu> {
    private static final ResourceLocation TEXTURE = ITLib.makeTextureLocation("boiler_liquid");

    public BoilerLiquidScreen(BoilerLiquidMenu container, Inventory inventoryPlayer, Component title) {
        super(container, inventoryPlayer, title, TEXTURE);
    }

    @Override
    protected void drawContainerBackgroundPre(@Nonnull GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        float heatLevel = ((BoilerLiquidMenu)this.f_97732_).getHeatLevel();
        double workingHeatLevel = ((BoilerLiquidMenu)this.f_97732_).getWorkingHeatLevel();
        int barWidth = Mth.m_14045_((int)Math.round(41.0f * heatLevel / (float)workingHeatLevel), (int)0, (int)41);
        graphics.m_280218_(TEXTURE, this.f_97735_ + 119, this.f_97736_ + 38, 176, 0, barWidth, 9);
    }

    @Override
    @Nonnull
    protected List<ITInfoArea> makeInfoAreas() {
        return ImmutableList.of((Object)new ITFluidInfoArea((IFluidTank)((BoilerLiquidMenu)this.f_97732_).tanks.input1(), new Rect2i(this.f_97735_ + 80, this.f_97736_ + 20, 16, 47), 177, 31, 20, 51, TEXTURE), (Object)new ITInfoArea(new Rect2i(this.f_97735_ + 119, this.f_97736_ + 38, 41, 9)){

            @Override
            protected void fillTooltipOverArea(int mouseX, int mouseY, List<Component> tooltip) {
                tooltip.add((Component)Component.m_237115_((String)TranslationKey.GUI_TEMPERATURE.getLocation()));
                float heatLevel = ((BoilerLiquidMenu)BoilerLiquidScreen.this.f_97732_).getHeatLevel();
                tooltip.add((Component)TextUtils.applyFormat((Component)Component.m_237110_((String)TranslationKey.GUI_HEAT_LEVEL.getLocation(), (Object[])new Object[]{(int)heatLevel}), (ChatFormatting[])new ChatFormatting[]{ChatFormatting.RED}));
            }

            @Override
            public void draw(GuiGraphics graphics) {
            }
        });
    }
}

