/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import mctmods.immersivetechnology.common.blocks.helper.ITBlockInterfaces;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="immersivetechnology", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ITClientEventHandler {
    @SubscribeEvent
    public static void onRenderOverlayPost(RenderGuiOverlayEvent.Post event) {
        ITBlockInterfaces.IBlockOverlayText overlay;
        Component[] text;
        if (!event.getOverlay().id().equals((Object)VanillaGuiOverlay.ITEM_NAME.id())) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91080_ != null || mc.f_91074_ == null) {
            return;
        }
        HitResult mop = mc.f_91077_;
        if (!(mop instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult blockHit = (BlockHitResult)mop;
        ClientLevel level = mc.f_91073_;
        if (level == null) {
            return;
        }
        BlockEntity te = level.m_7702_(blockHit.m_82425_());
        LocalPlayer player = mc.f_91074_;
        boolean hammer = false;
        if (te instanceof ITBlockInterfaces.IBlockOverlayText && (text = (overlay = (ITBlockInterfaces.IBlockOverlayText)te).getOverlayText((Player)player, mop, hammer)) != null && text.length > 0) {
            ITClientEventHandler.drawOverlayText(event.getGuiGraphics(), text);
        }
    }

    private static void drawOverlayText(GuiGraphics guiGraphics, Component[] text) {
        Minecraft mc = Minecraft.m_91087_();
        Font font = mc.f_91062_;
        int width = mc.m_91268_().m_85445_();
        int height = mc.m_91268_().m_85446_();
        PoseStack pose = guiGraphics.m_280168_();
        pose.m_85836_();
        pose.m_252880_((float)width / 2.0f, (float)height / 2.0f + 30.0f, 0.0f);
        int maxWidth = 0;
        for (Component component : text) {
            String s = component.getString();
            maxWidth = Math.max(maxWidth, font.m_92895_(s));
        }
        for (int i = 0; i < text.length; ++i) {
            String s = text[i].getString();
            int lineWidth = font.m_92895_(s);
            float x = (float)(-lineWidth) / 2.0f;
            Objects.requireNonNull(font);
            int y = i * (9 + 5);
            int n = (int)x - 4;
            int n2 = (int)x + lineWidth + 4;
            Objects.requireNonNull(font);
            guiGraphics.m_280509_(n, y - 2, n2, y + 9 + 2, -1442840576);
            guiGraphics.m_280056_(font, s, (int)x, y, 0xFFFFFF, true);
        }
        pose.m_85849_();
    }
}

