/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.ConfigDefaultValues;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class EmberIreSwordItem
extends UniqueSwordItem {
    private static int stepMod = 0;
    private static SimpleParticleType particleWalk = ParticleTypes.f_123801_;
    private static SimpleParticleType particleSprint = ParticleTypes.f_123801_;
    private static SimpleParticleType particlePassive = ParticleTypes.f_123762_;

    public EmberIreSwordItem(Tier toolMaterial, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    @Override
    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.m_9236_().m_5776_()) {
            HelperMethods.playHitSounds(attacker, target);
        }
        return super.m_7579_(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.m_21120_(hand);
        if (itemStack.m_41773_() >= itemStack.m_41776_() - 1) {
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        user.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }

    public void m_5929_(Level world, LivingEntity user, ItemStack stack, int remainingUseTicks) {
        if (!world.f_46443_ && remainingUseTicks % 10 == 0 && remainingUseTicks < this.m_8105_(stack) - 5) {
            world.m_6269_(null, (Entity)user, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_RECHARGE.get(), user.m_5720_(), 0.2f, 1.1f - (float)remainingUseTicks * 0.001f);
            if (remainingUseTicks < 20) {
                this.m_5551_(stack, world, user, remainingUseTicks);
            }
        }
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        if (!world.f_46443_ && user.m_6844_(EquipmentSlot.MAINHAND) == stack) {
            Optional<LivingEntity> targetEntityReturn = HelperMethods.findClosestTarget(user, 18.0, 3.0);
            double damageAmount = HelperMethods.getAttackDamage(stack) * 0.3;
            if (targetEntityReturn.isPresent() && HelperMethods.checkFriendlyFire(targetEntityReturn.get(), user)) {
                LivingEntity targetEntity = targetEntityReturn.get();
                SoundEvent soundSelect = (SoundEvent)SoundRegistry.ELEMENTAL_BOW_FIRE_SHOOT_IMPACT_03.get();
                int particleCount = 20;
                HelperMethods.spawnWaistHeightParticles((ServerLevel)world, (ParticleOptions)ParticleTypes.f_123762_, (Entity)user, (Entity)targetEntity, particleCount);
                HelperMethods.spawnWaistHeightParticles((ServerLevel)world, (ParticleOptions)ParticleTypes.f_123759_, (Entity)user, (Entity)targetEntity, particleCount);
                HelperMethods.spawnWaistHeightParticles((ServerLevel)world, (ParticleOptions)ParticleTypes.f_123783_, (Entity)user, (Entity)targetEntity, particleCount);
                world.m_5594_(null, user.m_20183_(), soundSelect, user.m_5720_(), 0.4f, 1.5f);
                DamageSource damageSource = user.m_269291_().m_269264_();
                if (user instanceof Player) {
                    Player player = (Player)user;
                    damageSource = user.m_269291_().m_269075_(player);
                    player.m_36335_().m_41524_(stack.m_41720_(), 10);
                }
                float minAdditionalDamage = 0.0f;
                float maxAdditionalDamage = (float)(HelperMethods.getAttackDamage(stack) * 3.0);
                float chargeRatio = 1.0f - (float)remainingUseTicks / (float)this.m_8105_(stack);
                float additionalDamage = 0.0f + (maxAdditionalDamage - 0.0f) * chargeRatio;
                float finalDamage = (float)damageAmount + additionalDamage;
                targetEntity.f_19802_ = 0;
                targetEntity.m_6469_(damageSource, finalDamage);
                world.m_5594_(null, targetEntity.m_20183_(), SoundEvents.f_11913_, user.m_5720_(), 0.4f, 1.1f);
                HelperMethods.spawnOrbitParticles((ServerLevel)world, targetEntity.m_20182_(), (ParticleOptions)ParticleTypes.f_123813_, 1.0, 1);
                HelperMethods.spawnOrbitParticles((ServerLevel)world, targetEntity.m_20182_(), (ParticleOptions)ParticleTypes.f_123759_, 1.0, 20);
                user.m_20256_(user.m_20154_().m_82548_().m_82490_(1.1));
                user.m_20334_(user.m_20184_().f_82479_, 0.0, user.m_20184_().f_82481_);
                user.f_19864_ = true;
                int fhitchance = (int)Config.getFloat("emberIreChance", "UniqueEffects", ConfigDefaultValues.emberIreChance);
                int fduration = (int)Config.getFloat("emberIreDuration", "UniqueEffects", ConfigDefaultValues.emberIreDuration);
                if (user.m_217043_().m_188503_((int)(250.0f - chargeRatio * 100.0f)) <= fhitchance) {
                    user.m_147207_(new MobEffectInstance(MobEffects.f_19600_, fduration, 0), (Entity)user);
                    user.m_147207_(new MobEffectInstance(MobEffects.f_19596_, fduration, 1), (Entity)user);
                    user.m_147207_(new MobEffectInstance(MobEffects.f_19598_, fduration, 0), (Entity)user);
                    world.m_6269_(null, (Entity)user, (SoundEvent)SoundRegistry.MAGIC_SWORD_SPELL_01.get(), user.m_5720_(), 0.5f, 2.0f);
                    particlePassive = ParticleTypes.f_123756_;
                    particleWalk = ParticleTypes.f_123777_;
                    particleSprint = ParticleTypes.f_123777_;
                }
            }
        }
    }

    public int m_8105_(ItemStack stack) {
        return 80;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    @Override
    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        Player player;
        if (entity instanceof Player && !(player = (Player)entity).m_21023_(MobEffects.f_19600_) && !player.m_6060_()) {
            particlePassive = ParticleTypes.f_123762_;
            particleWalk = ParticleTypes.f_123801_;
            particleSprint = ParticleTypes.f_123801_;
        }
        if (stepMod > 0) {
            --stepMod;
        }
        if (stepMod <= 0) {
            stepMod = 7;
        }
        HelperMethods.createFootfalls(entity, stack, world, stepMod, particleWalk, particleSprint, particlePassive, true);
        super.m_6883_(stack, world, entity, slot, selected);
    }

    @Override
    public void m_7373_(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        Style RIGHTCLICK = HelperMethods.getStyle("rightclick");
        Style ABILITY = HelperMethods.getStyle("ability");
        Style TEXT = HelperMethods.getStyle("text");
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.emberiresworditem.tooltip1").m_6270_(ABILITY));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.onrightclickheld").m_6270_(RIGHTCLICK));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.emberiresworditem.tooltip2").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.emberiresworditem.tooltip3").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.emberiresworditem.tooltip4").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.emberiresworditem.tooltip5").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.emberiresworditem.tooltip6").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.emberiresworditem.tooltip7").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.emberiresworditem.tooltip8").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237113_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.emberiresworditem.tooltip9").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.emberiresworditem.tooltip10").m_6270_(TEXT));
        tooltip.add((Component)Component.m_237115_((String)"item.simplyswords.emberiresworditem.tooltip11").m_6270_(TEXT));
        super.m_7373_(itemStack, world, tooltip, tooltipContext);
    }
}

