/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.effect;

import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.ConfigDefaultValues;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;

public class AstralShiftEffect
extends MobEffect {
    public AstralShiftEffect(MobEffectCategory statusEffectCategory, int color) {
        super(statusEffectCategory, color);
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
        if (!entity.m_9236_().m_5776_()) {
            MobEffectInstance effectInstance;
            Player player;
            ServerLevel world = (ServerLevel)entity.m_9236_();
            if (entity instanceof Player && (player = (Player)entity).m_21023_((MobEffect)this) && (effectInstance = player.m_21124_((MobEffect)this)) != null && effectInstance.m_19557_() < 10) {
                double x = entity.m_20185_();
                double y = entity.m_20186_();
                double z = entity.m_20189_();
                float damageMulti = (int)Config.getFloat("astralShiftDamageModifier", "UniqueEffects", ConfigDefaultValues.astralShiftDamageModifier);
                float damageMax = (int)Config.getFloat("astralShiftDamageMax", "UniqueEffects", ConfigDefaultValues.astralShiftDamageMax);
                double radius = 8.0;
                float damage = Math.min((float)amplifier * damageMulti, damageMax);
                world.m_5594_(null, entity.m_20183_(), (SoundEvent)SoundRegistry.DARK_ACTIVATION_DISTORTED.get(), entity.m_5720_(), 0.5f, 1.1f);
                DamageSource damageSource = entity.m_269291_().m_269075_(player);
                AABB box = new AABB(x - radius, y - 1.0, z - radius, x + radius, y + 1.0, z + radius);
                List nearbyEntities = world.m_6249_((Entity)entity, box, EntitySelector.f_20403_);
                for (Entity nearbyEntity : nearbyEntities) {
                    LivingEntity target;
                    if (!(nearbyEntity instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(target = (LivingEntity)nearbyEntity, (LivingEntity)player)) continue;
                    if (target instanceof Player) {
                        damageSource = entity.m_269291_().m_269075_(player);
                    }
                    target.f_19802_ = 0;
                    HelperMethods.applyDamageWithoutKnockback(target, damageSource, damage);
                    target.f_19802_ = 0;
                    HelperMethods.spawnRainingParticles(world, (ParticleOptions)ParticleTypes.f_123809_, (Entity)target, 4, 2.0);
                    HelperMethods.spawnRainingParticles(world, (ParticleOptions)ParticleTypes.f_123785_, (Entity)target, 4, 2.0);
                    HelperMethods.spawnOrbitParticles(world, target.m_20182_(), (ParticleOptions)ParticleTypes.f_123785_, 0.5, 6);
                    HelperMethods.spawnWaistHeightParticles(world, (ParticleOptions)ParticleTypes.f_123762_, (Entity)player, (Entity)target, 15);
                    HelperMethods.spawnRainingParticles(world, (ParticleOptions)ParticleTypes.f_123813_, (Entity)target, 2, 1.0);
                }
                entity.m_21195_((MobEffect)this);
            }
        }
        super.m_6742_(entity, amplifier);
    }

    public boolean m_6584_(int pDuration, int pAmplifier) {
        return true;
    }

    public void m_6386_(LivingEntity entity, AttributeMap attributes, int amplifier) {
    }
}

