/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.gamestages.data;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.darkhax.gamestages.data.IStageData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class StageData
implements IStageData {
    public static final String TAG_STAGES = "Stages";
    private final Set<String> unlockedStages = new HashSet<String>();

    @Override
    public Collection<String> getStages() {
        return Collections.unmodifiableCollection(this.unlockedStages);
    }

    @Override
    public boolean hasStage(String stage) {
        return this.unlockedStages.contains(stage.toLowerCase());
    }

    @Override
    public void addStage(String stage) {
        this.unlockedStages.add(stage.toLowerCase());
    }

    @Override
    public void removeStage(String stage) {
        this.unlockedStages.remove(stage.toLowerCase());
    }

    @Override
    public void clear() {
        this.unlockedStages.clear();
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        ListTag list = tag.m_128437_(TAG_STAGES, 8);
        for (int tagIndex = 0; tagIndex < list.size(); ++tagIndex) {
            this.addStage(list.m_128778_(tagIndex));
        }
    }

    @Override
    public CompoundTag writeToNBT() {
        CompoundTag tag = new CompoundTag();
        ListTag list = new ListTag();
        for (String stage : this.unlockedStages) {
            list.add((Object)StringTag.m_129297_((String)stage));
        }
        tag.m_128365_(TAG_STAGES, (Tag)list);
        return tag;
    }

    public String toString() {
        return "StageData [unlockedStages=" + this.unlockedStages + "]";
    }
}

