/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.storage.disk;

import com.refinedmods.refinedstorage.api.storage.AccessType;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDisk;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDiskContainerContext;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDiskListener;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.blockentity.grid.portable.IPortableGrid;
import java.util.Collection;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class PortableFluidStorageDisk
implements IStorageDisk<FluidStack> {
    private final IStorageDisk<FluidStack> parent;
    private final IPortableGrid portableGrid;

    public PortableFluidStorageDisk(IStorageDisk<FluidStack> parent, IPortableGrid portableGrid) {
        this.parent = parent;
        this.portableGrid = portableGrid;
    }

    @Override
    public int getCapacity() {
        return this.parent.getCapacity();
    }

    @Override
    @Nullable
    public UUID getOwner() {
        return this.parent.getOwner();
    }

    @Override
    public void setSettings(@Nullable IStorageDiskListener listener, IStorageDiskContainerContext context) {
        this.parent.setSettings(listener, context);
    }

    @Override
    public CompoundTag writeToNbt() {
        return this.parent.writeToNbt();
    }

    @Override
    public Collection<FluidStack> getStacks() {
        return this.parent.getStacks();
    }

    @Override
    @Nonnull
    public FluidStack insert(@Nonnull FluidStack stack, int size, Action action) {
        int inserted;
        int storedPre = this.parent.getStored();
        FluidStack remainder = this.parent.insert(stack, size, action);
        if (action == Action.PERFORM && (inserted = this.parent.getCacheDelta(storedPre, size, remainder)) > 0) {
            this.portableGrid.getFluidCache().add(stack, inserted, false, false);
        }
        return remainder;
    }

    @Override
    @Nonnull
    public FluidStack extract(@Nonnull FluidStack stack, int size, int flags, Action action) {
        FluidStack extracted = this.parent.extract(stack, size, flags, action);
        if (action == Action.PERFORM && !extracted.isEmpty()) {
            this.portableGrid.getFluidCache().remove(extracted, extracted.getAmount(), false);
        }
        return extracted;
    }

    @Override
    public int getStored() {
        return this.parent.getStored();
    }

    @Override
    public int getPriority() {
        return this.parent.getPriority();
    }

    @Override
    public AccessType getAccessType() {
        return this.parent.getAccessType();
    }

    @Override
    public int getCacheDelta(int storedPreInsertion, int size, @Nullable FluidStack remainder) {
        return this.parent.getCacheDelta(storedPreInsertion, size, remainder);
    }

    @Override
    public ResourceLocation getFactoryId() {
        return this.parent.getFactoryId();
    }
}

