/*
 * Decompiled with CFR 0.152.
 */
package com.imoonday.soulbound.mixin;

import com.imoonday.soulbound.SoulBoundEnchantment;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Inventory.class})
public class InventoryMixin {
    @Shadow
    @Final
    public Player f_35978_;
    @Shadow
    @Final
    private List<NonNullList<ItemStack>> f_35979_;
    @Unique
    private final Map<int[], ItemStack> soulbound$reservedItems = new HashMap<int[], ItemStack>();

    @Inject(method={"dropAll"}, at={@At(value="HEAD")})
    public void soulbound$reserveItems(CallbackInfo ci) {
        for (int listIndex = 0; listIndex < this.f_35979_.size(); ++listIndex) {
            NonNullList<ItemStack> list = this.f_35979_.get(listIndex);
            for (int itemIndex = 0; itemIndex < list.size(); ++itemIndex) {
                ItemStack itemStack = (ItemStack)list.get(itemIndex);
                if (!this.soulbound$shouldReserve(itemStack)) continue;
                this.soulbound$reservedItems.put(new int[]{listIndex, itemIndex}, itemStack);
                list.set(itemIndex, (Object)ItemStack.f_41583_);
            }
        }
    }

    @Inject(method={"dropAll"}, at={@At(value="RETURN")})
    public void soulbound$restoreItems(CallbackInfo ci) {
        this.soulbound$reservedItems.forEach((position, itemStack) -> this.f_35979_.get(position[0]).set(position[1], itemStack));
        this.soulbound$reservedItems.clear();
    }

    @Unique
    public boolean soulbound$shouldReserve(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        return this.f_35978_.m_6084_() || SoulBoundEnchantment.hasSoulbound(stack);
    }
}

