/*
 * Decompiled with CFR 0.152.
 */
package com.imoonday.soulbound;

import com.imoonday.soulbound.Config;
import com.imoonday.soulbound.Soulbound;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.capability.ITravelersBackpack;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.VanishingCurseEnchantment;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class SoulBoundEnchantment
extends Enchantment {
    public static final String IGNORED_NBT = "*";
    public static boolean curios = ModList.get().isLoaded("curios");
    public static boolean travelersBackpack = ModList.get().isLoaded("travelersbackpack");

    protected SoulBoundEnchantment() {
        super(Enchantment.Rarity.RARE, EnchantmentCategory.BREAKABLE, EquipmentSlot.values());
    }

    public int m_6183_(int level) {
        return Config.minPower;
    }

    public int m_6175_(int level) {
        int powerRange = Config.powerRange;
        if (powerRange < 0) {
            powerRange = 50;
        }
        return this.m_6183_(level) + powerRange;
    }

    public boolean m_6591_() {
        return Config.isTreasure;
    }

    public boolean m_6081_(ItemStack stack) {
        switch (Config.compatibilityMode) {
            case WHITELIST_ONLY: {
                return SoulBoundEnchantment.hasMatchItemStack(Config.whitelist, stack);
            }
            case BLACKLIST_ONLY: {
                return !SoulBoundEnchantment.hasMatchItemStack(Config.blacklist, stack);
            }
            case WHITELIST_AND_DEFAULT: {
                if (SoulBoundEnchantment.hasMatchItemStack(Config.whitelist, stack)) break;
                return false;
            }
            case BLACKLIST_AND_DEFAULT: {
                if (!SoulBoundEnchantment.hasMatchItemStack(Config.blacklist, stack)) break;
                return false;
            }
        }
        return stack.m_41763_() || !stack.m_41753_() || stack.m_150930_(Items.f_42517_) || super.m_6081_(stack);
    }

    public static boolean hasMatchItemStack(List<? extends String> list, ItemStack stack) {
        return list.stream().anyMatch(s -> SoulBoundEnchantment.match(stack, s));
    }

    public static boolean match(ItemStack stack, String s) {
        if (s.endsWith(IGNORED_NBT)) {
            String id = s.split("\\*", 2)[0];
            ResourceLocation identifier = ResourceLocation.m_135820_((String)id);
            if (identifier == null) {
                identifier = ResourceLocation.m_135820_((String)("minecraft:" + id));
            }
            if (identifier == null) {
                return false;
            }
            Item item = (Item)ForgeRegistries.ITEMS.getValue(identifier);
            return stack.m_150930_(item);
        }
        String[] split = s.split("\\{", 2);
        if (split.length > 0) {
            Item item;
            ResourceLocation identifier = ResourceLocation.m_135820_((String)split[0]);
            if (identifier == null) {
                identifier = ResourceLocation.m_135820_((String)("minecraft:" + split[0]));
            }
            if (identifier == null) {
                return false;
            }
            CompoundTag nbt = null;
            if (split.length > 1) {
                try {
                    nbt = TagParser.m_129359_((String)("{" + split[1]));
                }
                catch (CommandSyntaxException commandSyntaxException) {
                    // empty catch block
                }
            }
            if ((item = (Item)ForgeRegistries.ITEMS.getValue(identifier)) != null) {
                ItemStack itemStack = new ItemStack((ItemLike)item);
                if (nbt != null) {
                    itemStack.m_41739_(nbt);
                }
                return ItemStack.m_150942_((ItemStack)itemStack, (ItemStack)stack);
            }
        }
        return false;
    }

    public boolean m_6594_() {
        return Config.allowEnchantedBookTrade && !Config.disableSurvivalObtaining;
    }

    public boolean m_6592_() {
        return !Config.disableSurvivalObtaining;
    }

    protected boolean m_5975_(@NotNull Enchantment other) {
        return (!(other instanceof VanishingCurseEnchantment) || !Config.conflictWithVanishingCurse) && super.m_5975_(other);
    }

    public static void copySoulBoundItems(Player oldPlayer, Player newPlayer, boolean wasDeath) {
        if (wasDeath && !newPlayer.m_9236_().m_46469_().m_46207_(GameRules.f_46133_) && !oldPlayer.m_5833_()) {
            for (int i = 0; i < oldPlayer.m_150109_().m_6643_(); ++i) {
                ItemStack oldStack = oldPlayer.m_150109_().m_8020_(i);
                ItemStack newStack = newPlayer.m_150109_().m_8020_(i);
                if (!SoulBoundEnchantment.hasSoulbound(oldStack) || ItemStack.m_41728_((ItemStack)oldStack, (ItemStack)newStack)) continue;
                if (SoulBoundEnchantment.shouldDamage(oldPlayer, oldStack)) {
                    SoulBoundEnchantment.damageRandomly(oldPlayer, oldStack);
                    if (SoulBoundEnchantment.isBroken(oldStack)) {
                        if (Config.allowBreakItem) continue;
                        oldStack.m_41721_(oldStack.m_41776_() - 1);
                    }
                }
                if (newStack.m_41619_()) {
                    newPlayer.m_150109_().m_6836_(i, oldStack);
                    continue;
                }
                newPlayer.m_150109_().m_150079_(oldStack);
            }
            if (travelersBackpack) {
                ItemStack backpack;
                oldPlayer.reviveCaps();
                if (CapabilityUtils.isWearingBackpack((Player)oldPlayer) && SoulBoundEnchantment.hasSoulbound(backpack = CapabilityUtils.getWearingBackpack((Player)oldPlayer))) {
                    Optional optional = CapabilityUtils.getCapability((Player)newPlayer).resolve();
                    boolean synchronised = false;
                    if (optional.isPresent()) {
                        boolean areEqual;
                        ITravelersBackpack iTravelersBackpack = (ITravelersBackpack)optional.get();
                        ItemStack wearable = iTravelersBackpack.getWearable();
                        ItemStack content = iTravelersBackpack.getContainer().getItemStack();
                        boolean areNull = wearable == null && content == null;
                        boolean areEmpty = wearable != null && content != null && wearable.m_41619_() && content.m_41619_();
                        boolean bl = areEqual = backpack.equals(wearable) && backpack.equals(content);
                        if (areNull || areEmpty || areEqual) {
                            iTravelersBackpack.setWearable(backpack);
                            iTravelersBackpack.setContents(backpack);
                            iTravelersBackpack.synchronise();
                            iTravelersBackpack.synchroniseToOthers(newPlayer);
                            synchronised = true;
                        }
                    }
                    if (!synchronised) {
                        newPlayer.m_150109_().m_150079_(backpack);
                    }
                }
                oldPlayer.invalidateCaps();
            }
        }
    }

    public static void addCuriosDropListener() {
        if (curios) {
            MinecraftForge.EVENT_BUS.addListener(event -> {
                LivingEntity entity = event.getEntity();
                if (!(entity instanceof ServerPlayer)) {
                    return;
                }
                ServerPlayer player = (ServerPlayer)entity;
                event.addOverride(stack -> {
                    if (SoulBoundEnchantment.hasSoulbound(stack)) {
                        if (SoulBoundEnchantment.shouldDamage((Player)player, stack)) {
                            SoulBoundEnchantment.damageRandomly((Player)player, stack);
                            if (SoulBoundEnchantment.isBroken(stack)) {
                                if (Config.allowBreakItem) {
                                    return false;
                                }
                                stack.m_41721_(stack.m_41776_() - 1);
                            }
                        }
                        return true;
                    }
                    return false;
                }, ICurio.DropRule.ALWAYS_KEEP);
            });
        }
    }

    private static boolean isBroken(ItemStack stack) {
        return stack.m_41773_() >= stack.m_41776_();
    }

    private static boolean shouldDamage(Player player, ItemStack stack) {
        return Config.maxDamagePercent != 0 && !player.m_7500_() && stack.m_41763_();
    }

    private static void damageRandomly(Player player, ItemStack stack) {
        ServerPlayer serverPlayer;
        RandomSource random = player.m_217043_();
        stack.m_220157_(random.m_188503_(stack.m_41776_() * Config.maxDamagePercent / 100), random, player instanceof ServerPlayer ? (serverPlayer = (ServerPlayer)player) : null);
    }

    public static boolean hasSoulbound(ItemStack stack) {
        return stack.getEnchantmentLevel((Enchantment)Soulbound.SOUL_BOUND_ENCHANTMENT.get()) > 0;
    }
}

