/*
 * Decompiled with CFR 0.152.
 */
package com.imoonday.soulbound;

import com.electronwill.nightconfig.core.EnumGetMethod;
import com.imoonday.soulbound.CompatibilityMode;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="soulbound", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.BooleanValue CONFLICT_WITH_VANISHING_CURSE = BUILDER.comment("Whether it conflicts with the Vanishing Curse").comment("\u662f\u5426\u4e0e\u6d88\u5931\u8bc5\u5492\u51b2\u7a81").define("conflictWithVanishingCurse", true);
    private static final ForgeConfigSpec.BooleanValue IS_TREASURE = BUILDER.comment("Whether it is treasure enchantment (i.e. will not appear in the Enchantment Table)").comment("\u662f\u5426\u662f\u5b9d\u7269\u9644\u9b54\uff08\u5373\u4e0d\u4f1a\u51fa\u73b0\u5728\u9644\u9b54\u53f0\u4e2d\uff09").define("isTreasure", true);
    private static final ForgeConfigSpec.BooleanValue ALLOW_ENCHANTED_BOOK_TRADE = BUILDER.comment("Whether to allow librarians to sell this enchantment").comment("\u662f\u5426\u5141\u8bb8\u56fe\u4e66\u7ba1\u7406\u5458\u51fa\u552e\u6b64\u9644\u9b54").define("allowEnchantedBookTrade", true);
    private static final ForgeConfigSpec.BooleanValue ALLOW_BREAK_ITEM = BUILDER.comment("Whether to allow the item to disappear after being damaged").comment("\u662f\u5426\u5141\u8bb8\u7269\u54c1\u5728\u635f\u574f\u540e\u6d88\u5931").define("allowBreakItem", false);
    private static final ForgeConfigSpec.BooleanValue DISABLE_SURVIVAL_OBTAINING = BUILDER.comment("Whether to disable obtaining in survival").comment("\u662f\u5426\u7981\u7528\u751f\u5b58\u6a21\u5f0f\u83b7\u53d6\u9014\u5f84").define("disableSurvivalObtaining", false);
    private static final ForgeConfigSpec.IntValue MAX_DAMAGE_PERCENT = BUILDER.comment("Max percentage of damage").comment("\u6700\u5927\u635f\u574f\u767e\u5206\u6bd4").defineInRange("maxDamagePercent", 20, 0, 100);
    private static final ForgeConfigSpec.IntValue MIN_POWER = BUILDER.comment("Min power of enchantment").comment("\u6700\u5c0f\u9644\u9b54\u6743\u91cd").defineInRange("minPower", 25, 0, 100);
    private static final ForgeConfigSpec.IntValue POWER_RANGE = BUILDER.comment("Power range of enchantment").comment("\u9644\u9b54\u6743\u91cd\u8303\u56f4").defineInRange("powerRange", 50, 1, 100);
    private static final ForgeConfigSpec.EnumValue<CompatibilityMode> COMPATIBILITY_MODE = BUILDER.comment("Compatibility Mode").comment("\u517c\u5bb9\u6a21\u5f0f").defineEnum("compatibilityMode", (Enum)CompatibilityMode.DEFAULT, EnumGetMethod.ORDINAL_OR_NAME_IGNORECASE);
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> WHITELIST = BUILDER.comment("Example:(Only vanilla items support omitting prefixes)").comment("\u4f8b:(\u4ec5\u539f\u7248\u7269\u54c1\u652f\u6301\u7701\u7565\u524d\u7f00)").comment("[\"minecraft:diamond_sword{Damage:0}\", \"minecraft:diamond_sword\", \"diamond_sword\", \"minecraft:diamond_sword*\", \"diamond_sword*\"]").comment(new String[]{"1.minecraft:diamond_sword{Damage:0}", "2.minecraft:diamond_sword", "3.diamond_sword", "4.minecraft:diamond_sword*", "5.diamond_sword*"}).comment("Whitelist").comment("\u767d\u540d\u5355").defineList("whitelist", new ArrayList(), o -> Config.isValidString(o.toString()));
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> BLACKLIST = BUILDER.comment("Blacklist").comment("\u9ed1\u540d\u5355").defineList("blacklist", new ArrayList(), o -> Config.isValidString(o.toString()));
    static final ForgeConfigSpec SPEC = BUILDER.build();
    public static boolean conflictWithVanishingCurse;
    public static boolean allowEnchantedBookTrade;
    public static boolean isTreasure;
    public static boolean disableSurvivalObtaining;
    public static boolean allowBreakItem;
    public static int maxDamagePercent;
    public static int minPower;
    public static int powerRange;
    public static CompatibilityMode compatibilityMode;
    public static List<? extends String> whitelist;
    public static List<? extends String> blacklist;

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        conflictWithVanishingCurse = (Boolean)CONFLICT_WITH_VANISHING_CURSE.get();
        isTreasure = (Boolean)IS_TREASURE.get();
        allowEnchantedBookTrade = (Boolean)ALLOW_ENCHANTED_BOOK_TRADE.get();
        allowBreakItem = (Boolean)ALLOW_BREAK_ITEM.get();
        disableSurvivalObtaining = (Boolean)DISABLE_SURVIVAL_OBTAINING.get();
        maxDamagePercent = (Integer)MAX_DAMAGE_PERCENT.get();
        minPower = (Integer)MIN_POWER.get();
        powerRange = (Integer)POWER_RANGE.get();
        compatibilityMode = (CompatibilityMode)((Object)COMPATIBILITY_MODE.get());
        whitelist = (List)WHITELIST.get();
        blacklist = (List)BLACKLIST.get();
    }

    public static boolean isValidString(String s) {
        if (s.endsWith("*")) {
            String id = s.split("\\*", 2)[0];
            ResourceLocation identifier = ResourceLocation.m_135820_((String)id);
            if (identifier == null) {
                identifier = ResourceLocation.m_135820_((String)("minecraft:" + id));
            }
            if (identifier == null) {
                return false;
            }
            Item item = (Item)ForgeRegistries.ITEMS.getValue(identifier);
            return item != null;
        }
        String[] split = s.split("\\{", 2);
        if (split.length > 0) {
            Item item;
            ResourceLocation identifier = ResourceLocation.m_135820_((String)split[0]);
            if (identifier == null) {
                identifier = ResourceLocation.m_135820_((String)("minecraft:" + split[0]));
            }
            if (identifier == null) {
                return false;
            }
            CompoundTag nbt = null;
            if (split.length > 1) {
                try {
                    nbt = TagParser.m_129359_((String)("{" + split[1]));
                }
                catch (CommandSyntaxException ignored) {
                    return false;
                }
            }
            if ((item = (Item)ForgeRegistries.ITEMS.getValue(identifier)) != null) {
                ItemStack itemStack = new ItemStack((ItemLike)item);
                if (nbt != null) {
                    itemStack.m_41739_(nbt);
                }
                return !itemStack.m_41619_();
            }
        }
        return false;
    }
}

