/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.conjurer_illager.registry;

import com.legacy.conjurer_illager.TheConjurerMod;
import com.legacy.conjurer_illager.entity.BouncingBallEntity;
import com.legacy.conjurer_illager.entity.ConjurerEntity;
import com.legacy.conjurer_illager.entity.ThrowingCardEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.registries.RegisterEvent;

public class IllagerEntityTypes {
    public static final EntityType<ConjurerEntity> CONJURER = IllagerEntityTypes.buildEntity("conjurer", EntityType.Builder.m_20704_(ConjurerEntity::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 1.95f));
    public static final EntityType<BouncingBallEntity> BOUNCING_BALL = IllagerEntityTypes.buildEntity("bouncing_ball", EntityType.Builder.m_20704_(BouncingBallEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(BouncingBallEntity::new).m_20719_().setShouldReceiveVelocityUpdates(true).m_20699_(0.4f, 0.4f));
    public static final EntityType<ThrowingCardEntity> THROWING_CARD = IllagerEntityTypes.buildEntity("throwing_card", EntityType.Builder.m_20704_(ThrowingCardEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(ThrowingCardEntity::new).m_20719_().setShouldReceiveVelocityUpdates(true).m_20699_(0.3f, 0.1f));
    private static RegisterEvent registerEvent;

    public static void init(RegisterEvent event) {
        registerEvent = event;
        IllagerEntityTypes.register("conjurer", CONJURER);
        IllagerEntityTypes.register("bouncing_ball", BOUNCING_BALL);
        IllagerEntityTypes.register("throwing_card", THROWING_CARD);
    }

    private static void register(String name, EntityType<?> type) {
        if (registerEvent == null) {
            return;
        }
        registerEvent.register(Registries.f_256939_, TheConjurerMod.locate(name), () -> type);
    }

    public static void onAttributesRegistered(EntityAttributeCreationEvent event) {
        event.put(CONJURER, ConjurerEntity.registerAttributes().m_22265_());
    }

    private static <T extends Entity> EntityType<T> buildEntity(String key, EntityType.Builder<T> builder) {
        return builder.m_20712_(TheConjurerMod.find(key));
    }

    public static void registerPlacements(SpawnPlacementRegisterEvent event) {
        event.register(CONJURER, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_217057_, SpawnPlacementRegisterEvent.Operation.REPLACE);
    }
}

