/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.conjurer_illager.item;

import com.legacy.conjurer_illager.TheConjurerMod;
import java.util.EnumMap;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.util.Lazy;

public enum IllagerArmorMaterial implements ArmorMaterial
{
    CONJURER_HAT("conjurer_hat", 5, IllagerArmorMaterial.armorValues(1, 2, 3, 1), 15, SoundEvents.f_11678_, 0.0f, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42454_}));

    private static final EnumMap<ArmorItem.Type, Integer> HEALTH_FUNCTION_FOR_TYPE;
    private final String name;
    private final int maxDamageFactor;
    private final EnumMap<ArmorItem.Type, Integer> damageReductionAmountArray;
    private final int enchantability;
    private final SoundEvent soundEvent;
    private final float toughness;
    private final float knockbackResist;
    private final Lazy<Ingredient> repairMaterial;

    private IllagerArmorMaterial(String nameIn, int maxDamageFactorIn, EnumMap<ArmorItem.Type, Integer> enumMap, int enchantabilityIn, SoundEvent equipSoundIn, float p_i48533_8_, float knockbackResistIn, Supplier<Ingredient> repairMaterialSupplier) {
        this.name = TheConjurerMod.find(nameIn);
        this.maxDamageFactor = maxDamageFactorIn;
        this.damageReductionAmountArray = enumMap;
        this.enchantability = enchantabilityIn;
        this.soundEvent = equipSoundIn;
        this.toughness = p_i48533_8_;
        this.knockbackResist = knockbackResistIn;
        this.repairMaterial = Lazy.of(repairMaterialSupplier);
    }

    public int m_266425_(ArmorItem.Type type) {
        return HEALTH_FUNCTION_FOR_TYPE.get(type) * this.maxDamageFactor;
    }

    public int m_7366_(ArmorItem.Type type) {
        return this.damageReductionAmountArray.get(type);
    }

    public int m_6646_() {
        return this.enchantability;
    }

    public SoundEvent m_7344_() {
        return this.soundEvent;
    }

    public Ingredient m_6230_() {
        return (Ingredient)this.repairMaterial.get();
    }

    public String m_6082_() {
        return this.name;
    }

    public float m_6651_() {
        return this.toughness;
    }

    public float m_6649_() {
        return this.knockbackResist;
    }

    public static EnumMap<ArmorItem.Type, Integer> armorValues(int boots, int legs, int chest, int helmet) {
        return (EnumMap)Util.m_137469_(new EnumMap(ArmorItem.Type.class), material -> {
            material.put(ArmorItem.Type.BOOTS, boots);
            material.put(ArmorItem.Type.LEGGINGS, legs);
            material.put(ArmorItem.Type.CHESTPLATE, chest);
            material.put(ArmorItem.Type.HELMET, helmet);
        });
    }

    static {
        HEALTH_FUNCTION_FOR_TYPE = IllagerArmorMaterial.armorValues(13, 15, 16, 11);
    }
}

