/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.player;

import com.google.common.collect.Multimap;
import io.redspace.ironsspellbooks.IronsSpellbooks;
import io.redspace.ironsspellbooks.api.entity.IMagicEntity;
import io.redspace.ironsspellbooks.api.events.SpellTeleportEvent;
import io.redspace.ironsspellbooks.api.item.CastingImplementData;
import io.redspace.ironsspellbooks.api.item.UpgradeData;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.magic.SpellSelectionManager;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ISpellContainer;
import io.redspace.ironsspellbooks.api.spells.SpellData;
import io.redspace.ironsspellbooks.api.util.CameraShakeManager;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.block.BloodCauldronBlock;
import io.redspace.ironsspellbooks.block.portal_frame.PortalFrameBlockEntity;
import io.redspace.ironsspellbooks.capabilities.magic.CooldownInstance;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.capabilities.magic.PocketDimensionManager;
import io.redspace.ironsspellbooks.capabilities.magic.RecastResult;
import io.redspace.ironsspellbooks.capabilities.magic.SummonManager;
import io.redspace.ironsspellbooks.config.ServerConfigs;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.damage.ISSDamageTypes;
import io.redspace.ironsspellbooks.data.IronsDataStorage;
import io.redspace.ironsspellbooks.datagen.DamageTypeTagGenerator;
import io.redspace.ironsspellbooks.effect.AbyssalShroudEffect;
import io.redspace.ironsspellbooks.effect.EvasionEffect;
import io.redspace.ironsspellbooks.effect.IMobEffectEndCallback;
import io.redspace.ironsspellbooks.effect.ISyncedMobEffect;
import io.redspace.ironsspellbooks.effect.ImmolateEffect;
import io.redspace.ironsspellbooks.effect.SummonTimer;
import io.redspace.ironsspellbooks.entity.mobs.IMagicSummon;
import io.redspace.ironsspellbooks.entity.mobs.ice_spider.ICritablePartEntity;
import io.redspace.ironsspellbooks.entity.spells.ice_tomb.IceTombEntity;
import io.redspace.ironsspellbooks.entity.spells.root.PreventDismount;
import io.redspace.ironsspellbooks.item.CastingItem;
import io.redspace.ironsspellbooks.item.Scroll;
import io.redspace.ironsspellbooks.item.curios.CurioBaseItem;
import io.redspace.ironsspellbooks.network.EquipmentChangedPacket;
import io.redspace.ironsspellbooks.network.SyncManaPacket;
import io.redspace.ironsspellbooks.player.ClientMagicData;
import io.redspace.ironsspellbooks.registries.BlockRegistry;
import io.redspace.ironsspellbooks.registries.ItemRegistry;
import io.redspace.ironsspellbooks.registries.MobEffectRegistry;
import io.redspace.ironsspellbooks.setup.PacketDistributor;
import io.redspace.ironsspellbooks.util.MinecraftInstanceHelper;
import io.redspace.ironsspellbooks.util.ModTags;
import io.redspace.ironsspellbooks.util.UpgradeUtils;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityDataPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.event.CurioAttributeModifierEvent;
import top.theillusivec4.curios.api.event.CurioChangeEvent;

@Mod.EventBusSubscriber
public class ServerPlayerEvents {
    @SubscribeEvent
    public static void onUseItem(PlayerInteractEvent.RightClickItem event) {
        Player player = event.getEntity();
        if (player.f_19853_.f_46443_) {
            MinecraftInstanceHelper.ifPlayerPresent(localPlayer -> {
                if (ClientMagicData.isCasting() && player.m_20148_().equals(localPlayer.m_20148_())) {
                    event.setCanceled(true);
                }
            });
        } else {
            MagicData magicData = MagicData.getPlayerMagicData((LivingEntity)player);
            if (magicData.isCasting() && event.getItemStack() != magicData.getPlayerCastingItem()) {
                event.setCanceled(true);
            }
        }
        if (event.isCanceled()) {
            return;
        }
        Level level = player.f_19853_;
        InteractionHand hand = event.getHand();
        ItemStack itemStack = player.m_21120_(hand);
        if (CastingImplementData.has(itemStack) && CastingImplementData.get(itemStack)) {
            String castingSlot;
            SpellSelectionManager spellSelectionManager = new SpellSelectionManager(player);
            SpellSelectionManager.SelectionOption selectionOption = spellSelectionManager.getSelection();
            if (selectionOption == null || selectionOption.spellData.equals(SpellData.EMPTY)) {
                return;
            }
            SpellData spellData = selectionOption.spellData;
            int spellLevel = spellData.getSpell().getLevelFor(spellData.getLevel(), (LivingEntity)player);
            if (level.m_5776_()) {
                if (ClientMagicData.isCasting()) {
                    event.setCancellationResult(InteractionResult.CONSUME);
                } else {
                    if (ClientMagicData.getPlayerMana() < spellData.getSpell().getManaCost(spellLevel) || ClientMagicData.getCooldowns().isOnCooldown(spellData.getSpell()) || !ClientMagicData.getSyncedSpellData((LivingEntity)player).isSpellLearned(spellData.getSpell())) {
                        return;
                    }
                    event.setCancellationResult(InteractionResult.CONSUME);
                }
            }
            String string = castingSlot = hand.ordinal() == 0 ? SpellSelectionManager.MAINHAND : SpellSelectionManager.OFFHAND;
            if (spellData.getSpell().attemptInitiateCast(itemStack, spellLevel, level, player, selectionOption.getCastSource(), true, castingSlot)) {
                event.setCancellationResult(InteractionResult.CONSUME);
            } else {
                event.setCancellationResult(InteractionResult.FAIL);
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerDropItem(ItemTossEvent event) {
        MagicData magicData;
        ItemStack itemStack = event.getEntity().m_32055_();
        if (itemStack.m_41720_() instanceof Scroll && (magicData = MagicData.getPlayerMagicData((LivingEntity)event.getPlayer())).isCasting() && magicData.getCastSource() == CastSource.SCROLL && magicData.getCastType() == CastType.CONTINUOUS) {
            itemStack.m_41774_(1);
        }
    }

    @SubscribeEvent
    public static void onLevelLoaded(LevelEvent.Load event) {
        ServerLevel serverLevel;
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel && (serverLevel = (ServerLevel)levelAccessor).m_46472_() == Level.f_46428_) {
            IronsDataStorage.init(serverLevel.m_8895_());
        }
    }

    @SubscribeEvent
    public static void onServerStoppedEvent(ServerStoppedEvent event) {
        IronsSpellbooks.MCS = null;
        IronsSpellbooks.OVERWORLD = null;
    }

    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent event) {
        IronsSpellbooks.MCS = event.getServer();
        IronsSpellbooks.OVERWORLD = IronsSpellbooks.MCS.m_129783_();
    }

    @SubscribeEvent
    public static void onLivingEquipmentChangeEvent(LivingEquipmentChangeEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            MagicData playerMagicData = MagicData.getPlayerMagicData((LivingEntity)serverPlayer);
            if (playerMagicData.isCasting() && (event.getFrom().m_41720_() instanceof CastingItem || event.getTo().m_41720_() instanceof CastingItem)) {
                Utils.serverSideCancelCast(serverPlayer);
                PacketDistributor.sendToPlayer(serverPlayer, new EquipmentChangedPacket());
                return;
            }
            boolean isFromSpellContainer = ISpellContainer.isSpellContainer(event.getFrom());
            if (isFromSpellContainer && ISpellContainer.get(event.getFrom()).getIndexForSpell(playerMagicData.getCastingSpell().getSpell()) >= 0) {
                if (playerMagicData.isCasting()) {
                    Utils.serverSideCancelCast(serverPlayer);
                }
                PacketDistributor.sendToPlayer(serverPlayer, new EquipmentChangedPacket());
            } else if (isFromSpellContainer || ISpellContainer.isSpellContainer(event.getTo())) {
                PacketDistributor.sendToPlayer(serverPlayer, new EquipmentChangedPacket());
            }
        }
    }

    @SubscribeEvent
    public static void onCurioChangeEvent(CurioChangeEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if (ISpellContainer.isSpellContainer(event.getFrom()) || ISpellContainer.isSpellContainer(event.getTo())) {
                PacketDistributor.sendToPlayer(serverPlayer, new EquipmentChangedPacket());
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLogOut(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Utils.serverSideCancelCast(serverPlayer);
        }
    }

    @SubscribeEvent
    public static void onPlayerOpenContainer(PlayerContainerEvent.Open event) {
        ServerPlayer serverPlayer;
        MagicData playerMagicData;
        if (event.getEntity().f_19853_.f_46443_) {
            return;
        }
        Player player = event.getEntity();
        if (player instanceof ServerPlayer && (playerMagicData = MagicData.getPlayerMagicData((LivingEntity)(serverPlayer = (ServerPlayer)player))).isCasting()) {
            Utils.serverSideCancelCast(serverPlayer);
        }
    }

    @SubscribeEvent
    public static void handleUpgradeModifiers(ItemAttributeModifierEvent event) {
        UpgradeData upgradeData = UpgradeData.getUpgradeData(event.getItemStack());
        if (upgradeData != UpgradeData.NONE && upgradeData.getUpgradedSlot().equals(event.getSlotType().m_20751_())) {
            UpgradeUtils.handleAttributeEvent((Multimap<Attribute, AttributeModifier>)event.getModifiers(), upgradeData, (arg_0, arg_1) -> ((ItemAttributeModifierEvent)event).addModifier(arg_0, arg_1), (arg_0, arg_1) -> ((ItemAttributeModifierEvent)event).removeModifier(arg_0, arg_1), Optional.empty());
        }
    }

    @SubscribeEvent
    public static void handleCurioUpgradeModifiers(CurioAttributeModifierEvent event) {
        UpgradeData upgradeData = UpgradeData.getUpgradeData(event.getItemStack());
        if (upgradeData != UpgradeData.NONE && upgradeData.getUpgradedSlot().equals(event.getSlotContext().identifier())) {
            UpgradeUtils.handleAttributeEvent((Multimap<Attribute, AttributeModifier>)event.getModifiers(), upgradeData, (arg_0, arg_1) -> ((CurioAttributeModifierEvent)event).addModifier(arg_0, arg_1), (arg_0, arg_1) -> ((CurioAttributeModifierEvent)event).removeModifier(arg_0, arg_1), Optional.of(event.getUuid()));
        }
    }

    @SubscribeEvent
    public static void onExperienceDroppedEvent(LivingExperienceDropEvent event) {
        Player player = event.getAttackingPlayer();
        if (player != null) {
            int ringCount = CuriosApi.getCuriosInventory((LivingEntity)player).map(inventory -> inventory.findCurios((Item)ItemRegistry.EMERALD_STONEPLATE_RING.get()).size()).orElse(0);
            for (int i = 0; i < ringCount; ++i) {
                event.setDroppedExperience((int)((double)event.getDroppedExperience() * 1.25));
            }
        }
    }

    @SubscribeEvent
    public static void onStartTracking(PlayerEvent.StartTracking event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            player = event.getTarget();
            if (player instanceof ServerPlayer) {
                ServerPlayer targetPlayer = (ServerPlayer)player;
                MagicData.getPlayerMagicData((LivingEntity)serverPlayer).getSyncedData().syncToPlayer(targetPlayer);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MagicData playerMagicData = MagicData.getPlayerMagicData((LivingEntity)serverPlayer);
            playerMagicData.getPlayerCooldowns().syncToPlayer(serverPlayer);
            playerMagicData.getPlayerRecasts().syncAllToPlayer();
            playerMagicData.getSyncedData().syncToPlayer(serverPlayer);
            PacketDistributor.sendToPlayer(serverPlayer, new SyncManaPacket(playerMagicData));
            CameraShakeManager.doSync(serverPlayer);
        }
    }

    @SubscribeEvent
    public static void onPlayerStartTrackingEntity(PlayerEvent.StartTracking event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayerRecipient = (ServerPlayer)player;
            Entity entity = event.getTarget();
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                for (MobEffectInstance inst : livingEntity.m_21220_()) {
                    if (!(inst.m_19544_() instanceof ISyncedMobEffect)) continue;
                    serverPlayerRecipient.f_8906_.m_9829_((Packet)new ClientboundUpdateMobEffectPacket(livingEntity.m_19879_(), inst));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDeathEvent(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        if (!entity.f_19853_.f_46443_) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                Utils.serverSideCancelCast(serverPlayer);
                MagicData.getPlayerMagicData((LivingEntity)serverPlayer).getPlayerRecasts().removeAll(RecastResult.DEATH);
            }
            entity.m_21220_().forEach(mobEffectInstance -> {
                MobEffect patt16884$temp = mobEffectInstance.m_19544_();
                if (patt16884$temp instanceof IMobEffectEndCallback) {
                    IMobEffectEndCallback callback = (IMobEffectEndCallback)patt16884$temp;
                    callback.onEffectRemoved(entity, mobEffectInstance.m_19564_());
                }
            });
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onSpellTeleport(SpellTeleportEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (((CurioBaseItem)((Object)ItemRegistry.TELEPORTATION_AMULET.get())).isEquippedBy(livingEntity)) {
                livingEntity.m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistry.EVASION.get(), 60, 0, false, false, true));
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerCloned(PlayerEvent.Clone event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer newServerPlayer = (ServerPlayer)player;
            event.getOriginal().m_21220_().forEach(effect -> {
                if (effect.m_19544_() instanceof SummonTimer) {
                    newServerPlayer.m_147207_(effect, (Entity)newServerPlayer);
                }
            });
            MagicData oldMagicData = MagicData.getPlayerMagicData((LivingEntity)event.getOriginal());
            MagicData newMagicData = MagicData.getPlayerMagicData((LivingEntity)newServerPlayer);
            newMagicData.setSyncedData(oldMagicData.getSyncedData().getPersistentData(newServerPlayer));
            oldMagicData.getPlayerCooldowns().getSpellCooldowns().forEach((spellId, cooldown) -> newMagicData.getPlayerCooldowns().getSpellCooldowns().put((String)spellId, (CooldownInstance)cooldown));
        }
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Utils.serverSideCancelCast(serverPlayer);
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.m_20095_();
            serverPlayer.m_146917_(0);
            List data = serverPlayer.m_20088_().m_135378_();
            if (data != null) {
                serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetEntityDataPacket(serverPlayer.m_19879_(), data));
            }
            Utils.serverSideCancelCast(serverPlayer);
            MagicData.getPlayerMagicData((LivingEntity)serverPlayer).setMana((int)(serverPlayer.m_21133_((Attribute)AttributeRegistry.MAX_MANA.get()) * (Double)ServerConfigs.MANA_SPAWN_PERCENT.get()));
        }
    }

    @SubscribeEvent
    public static void fixDragonCrits(CriticalHitEvent event) {
        if (event.getTarget().f_19853_.f_46443_) {
            return;
        }
        Entity entity = event.getTarget();
        if (entity instanceof ICritablePartEntity) {
            boolean defaultShouldCrit;
            ICritablePartEntity dragonPartEntity = (ICritablePartEntity)entity;
            Entity part = (Entity)dragonPartEntity;
            Player attacker = event.getEntity();
            boolean bl = defaultShouldCrit = (double)attacker.m_36403_(0.5f) > 0.9 && attacker.f_19789_ > 0.0f && !attacker.m_20096_() && !attacker.m_6147_() && !attacker.m_20069_() && !attacker.m_21023_(MobEffects.f_19610_) && !attacker.m_20159_() && !attacker.m_20142_();
            if (defaultShouldCrit) {
                if (event.getDamageModifier() == 1.0f) {
                    event.setDamageModifier(1.5f);
                }
                AABB boundingBox = part.m_20191_();
                Vec3 vec3 = boundingBox.m_82399_();
                MagicManager.spawnParticles(event.getEntity().f_19853_, (ParticleOptions)ParticleTypes.f_123797_, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 25, boundingBox.m_82362_() * 0.6, boundingBox.m_82376_() * 0.6, boundingBox.m_82385_() * 0.6, 0.0, false);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingIncomingDamage(LivingAttackEvent event) {
        Creeper creeper;
        Entity entity;
        LivingEntity livingEntity = event.getEntity();
        if (event.getSource().m_7639_() != null && (entity = livingEntity.m_20202_()) instanceof IceTombEntity) {
            IceTombEntity iceTomb = (IceTombEntity)entity;
            if (!DamageSources.isFriendlyFireBetween(event.getSource().m_7639_(), (Entity)livingEntity)) {
                event.setCanceled(true);
                iceTomb.m_6469_(event.getSource(), event.getAmount());
                return;
            }
        }
        if (livingEntity instanceof ServerPlayer || livingEntity instanceof IMagicEntity) {
            if (((CurioBaseItem)((Object)ItemRegistry.FIREWARD_RING.get())).isEquippedBy(livingEntity) && event.getSource().m_269533_(DamageTypeTags.f_268745_)) {
                event.getEntity().m_20095_();
                event.setCanceled(true);
                return;
            }
            MagicData playerMagicData = MagicData.getPlayerMagicData(livingEntity);
            if (livingEntity.m_21023_((MobEffect)MobEffectRegistry.EVASION.get())) {
                if (EvasionEffect.doEffect(livingEntity, event.getSource())) {
                    event.setCanceled(true);
                    return;
                }
            } else if (livingEntity.m_21023_((MobEffect)MobEffectRegistry.ABYSSAL_SHROUD.get()) && AbyssalShroudEffect.doEffect(livingEntity, event.getSource())) {
                event.setCanceled(true);
                return;
            }
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                if (playerMagicData.isCasting() && playerMagicData.getCastingSpell().getSpell().canBeInterrupted((Player)serverPlayer) && playerMagicData.getCastDurationRemaining() > 0 && !event.getSource().m_269533_(DamageTypeTagGenerator.LONG_CAST_IGNORE) && !playerMagicData.popMarkedPoison()) {
                    Utils.serverSideCancelCast(serverPlayer);
                }
            }
        }
        if (((Boolean)ServerConfigs.BETTER_CREEPER_THUNDERHIT.get()).booleanValue() && event.getSource().m_269533_(DamageTypeTags.f_268745_) && (entity = event.getEntity()) instanceof Creeper && (creeper = (Creeper)entity).m_7090_()) {
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public static void onBeforeDamageTaken(LivingDamageEvent event) {
        Player player;
        LivingEntity livingAttacker;
        Entity entity;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof IMagicEntity || livingEntity instanceof ServerPlayer) {
            MagicData playerMagicData = MagicData.getPlayerMagicData(livingEntity);
            if (livingEntity.m_21023_((MobEffect)MobEffectRegistry.HEARTSTOP.get())) {
                playerMagicData.getSyncedData().addHeartstopDamage(event.getAmount() * 0.5f);
                event.setAmount(0.0f);
            }
        }
        if (event.getSource().m_276093_(ISSDamageTypes.FIRE_MAGIC) && (entity = event.getSource().m_7639_()) instanceof LivingEntity && (livingAttacker = (LivingEntity)entity).m_6844_(EquipmentSlot.CHEST).m_150930_((Item)ItemRegistry.INFERNAL_SORCERER_CHESTPLATE.get()) && (!(livingAttacker instanceof Player) || !(player = (Player)livingAttacker).m_36335_().m_41519_((Item)ItemRegistry.INFERNAL_SORCERER_CHESTPLATE.get()))) {
            ImmolateEffect.addImmolateStack(livingEntity, (Entity)livingAttacker);
        }
    }

    @SubscribeEvent
    public static void onLivingChangeTarget(LivingChangeTargetEvent event) {
        LivingEntity newTarget = event.getNewTarget();
        LivingEntity entity = event.getEntity();
        if (newTarget != null) {
            IMagicSummon summon;
            if (newTarget.m_6095_().m_204039_(ModTags.VILLAGE_ALLIES) && entity.m_6095_().m_204039_(ModTags.VILLAGE_ALLIES)) {
                event.setCanceled(true);
                return;
            }
            if (newTarget instanceof IMagicSummon && (summon = (IMagicSummon)newTarget) instanceof Enemy && !entity.equals((Object)((Mob)newTarget).m_5448_())) {
                event.setCanceled(true);
                return;
            }
            if (newTarget.m_21023_((MobEffect)MobEffectRegistry.TRUE_INVISIBILITY.get())) {
                event.setCanceled(true);
                return;
            }
        }
    }

    @SubscribeEvent
    public static void preventDismount(EntityMountEvent event) {
        Entity mount = event.getEntityBeingMounted();
        Entity entity = event.getEntity();
        if (!entity.f_19853_.f_46443_ && event.isDismounting() && mount instanceof PreventDismount) {
            PreventDismount preventDismount = (PreventDismount)mount;
            if (!(mount.m_213877_() || entity.m_213877_() || preventDismount.canEntityDismount(entity))) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onProjectileImpact(ProjectileImpactEvent event) {
        EntityHitResult entityHitResult;
        Entity victim;
        HitResult hitResult = event.getRayTraceResult();
        if (hitResult instanceof EntityHitResult && ((victim = (entityHitResult = (EntityHitResult)hitResult).m_82443_()) instanceof IMagicEntity || victim instanceof Player)) {
            LivingEntity livingEntity = (LivingEntity)victim;
            if (livingEntity.m_21023_((MobEffect)MobEffectRegistry.EVASION.get())) {
                if (EvasionEffect.doEffect(livingEntity, victim.m_269291_().m_269104_((Entity)event.getProjectile(), event.getProjectile().m_19749_()))) {
                    event.setImpactResult(ProjectileImpactEvent.ImpactResult.SKIP_ENTITY);
                }
            } else if (livingEntity.m_21023_((MobEffect)MobEffectRegistry.ABYSSAL_SHROUD.get()) && AbyssalShroudEffect.doEffect(livingEntity, victim.m_269291_().m_269104_((Entity)event.getProjectile(), event.getProjectile().m_19749_()))) {
                event.setImpactResult(ProjectileImpactEvent.ImpactResult.SKIP_ENTITY);
            }
        }
    }

    @SubscribeEvent
    public static void useOnEntityEvent(PlayerInteractEvent.EntityInteractSpecific event) {
        Entity entity = event.getTarget();
        if (entity instanceof Creeper) {
            InteractionHand hand;
            Creeper creeper = (Creeper)entity;
            Player player = event.getEntity();
            ItemStack useItem = player.m_21120_(hand = event.getHand());
            if (useItem.m_150930_(Items.f_42590_) && creeper.m_7090_()) {
                creeper.m_6469_(creeper.m_269291_().m_269264_(), 5.0f);
                player.f_19853_.m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11771_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                player.m_6674_(hand);
                player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)useItem, (Player)player, (ItemStack)new ItemStack((ItemLike)ItemRegistry.LIGHTNING_BOTTLE.get())));
                event.setCancellationResult(InteractionResultHolder.m_19096_((Object)player.m_21120_(hand)).m_19089_());
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void handleResistanceAttributesOnSpawn(MobSpawnEvent.FinalizeSpawn event) {
        Mob mob = event.getEntity();
        if (mob.m_6336_() == MobType.f_21641_) {
            ServerPlayerEvents.setIfNonNull((LivingEntity)mob, AttributeRegistry.HOLY_MAGIC_RESIST, 0.5);
            ServerPlayerEvents.setIfNonNull((LivingEntity)mob, AttributeRegistry.BLOOD_MAGIC_RESIST, 1.5);
        } else if (mob.m_6336_() == MobType.f_21644_) {
            ServerPlayerEvents.setIfNonNull((LivingEntity)mob, AttributeRegistry.LIGHTNING_MAGIC_RESIST, 0.5);
        }
        if (mob.m_5825_()) {
            ServerPlayerEvents.setIfNonNull((LivingEntity)mob, AttributeRegistry.FIRE_MAGIC_RESIST, 1.5);
        }
        if (mob.m_6095_() == EntityType.f_20551_) {
            ServerPlayerEvents.setIfNonNull((LivingEntity)mob, AttributeRegistry.ICE_MAGIC_RESIST, 0.5);
        }
    }

    private static void setIfNonNull(LivingEntity mob, Supplier<Attribute> attribute, double value) {
        AttributeInstance instance = mob.m_21204_().m_22146_(attribute.get());
        if (instance != null) {
            instance.m_22100_(value);
        }
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent event) {
        BlockPos pos;
        BlockState blockState;
        LivingEntity entity = event.getEntity();
        Level level = entity.f_19853_;
        if (!level.f_46443_ && entity.f_19797_ % 40 == 0 && (blockState = entity.f_19853_.m_8055_(pos = entity.m_20183_())).m_60713_(Blocks.f_50256_)) {
            BloodCauldronBlock.attemptCookEntity(blockState, entity.f_19853_, pos, (Entity)entity, () -> {
                level.m_46597_(pos, ((Block)BlockRegistry.BLOOD_CAULDRON_BLOCK.get()).m_49966_());
                level.m_142346_(null, GameEvent.f_157792_, pos);
            });
        }
    }

    @SubscribeEvent
    public static void onAnvilRecipe(AnvilUpdateEvent event) {
        ItemStack result;
        if (event.getRight().m_150930_((Item)ItemRegistry.SHRIVING_STONE.get()) && !(result = Utils.handleShriving(event.getLeft())).m_41619_()) {
            event.setOutput(result);
            event.setCost(1);
            event.setMaterialCost(1);
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        if (((Boolean)ServerConfigs.PORTAL_FRAME_RESTRICT_BREAKING.get()).booleanValue() && event.getState().m_60713_((Block)BlockRegistry.PORTAL_FRAME.get())) {
            PortalFrameBlockEntity portalFrameBlockEntity;
            Player player = event.getPlayer();
            BlockEntity blockEntity = event.getLevel().m_7702_(event.getPos());
            if (blockEntity instanceof PortalFrameBlockEntity && (portalFrameBlockEntity = (PortalFrameBlockEntity)blockEntity).getOwnerUUID() != null && !player.m_20148_().equals(portalFrameBlockEntity.getOwnerUUID())) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237115_((String)"ui.irons_spellbooks.portal_break_failure").m_130940_(ChatFormatting.RED)));
                }
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void preventBlockPlacement(PlayerInteractEvent.RightClickBlock event) {
        BlockItem blockItem;
        Item item;
        Level level = event.getLevel();
        if (level.m_46472_().equals(PocketDimensionManager.POCKET_DIMENSION) && (item = event.getItemStack().m_41720_()) instanceof BlockItem && (blockItem = (BlockItem)item).m_40614_().m_204297_().m_203656_(ModTags.PREVENT_POCKET_DIMENSION_PLACEMENT)) {
            event.setCanceled(true);
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.m_5661_((Component)Component.m_237115_((String)"ui.irons_spellbooks.error_place_block_dimension").m_130940_(ChatFormatting.RED), true);
            }
        }
    }

    @SubscribeEvent
    public static void preventPocketDimensionTeleportation(EntityTeleportEvent event) {
        ServerLevel serverLevel;
        Level level = event.getEntity().f_19853_;
        if (level instanceof ServerLevel && (serverLevel = (ServerLevel)level).m_46472_().equals(PocketDimensionManager.POCKET_DIMENSION) && !(event instanceof EntityTeleportEvent.TeleportCommand)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void changeDigSpeed(PlayerEvent.BreakSpeed event) {
        int i;
        Player player = event.getEntity();
        if (player.m_21023_((MobEffect)MobEffectRegistry.HASTENED.get())) {
            i = 1 + player.m_21124_((MobEffect)MobEffectRegistry.HASTENED.get()).m_19564_();
            event.setNewSpeed(event.getNewSpeed() * Utils.intPow(1.2f, i));
        }
        if (player.m_21023_((MobEffect)MobEffectRegistry.SLOWED.get())) {
            i = 1 + player.m_21124_((MobEffect)MobEffectRegistry.SLOWED.get()).m_19564_();
            event.setNewSpeed(event.getNewSpeed() * Utils.intPow(0.8f, i));
        }
    }

    @SubscribeEvent
    public static void changeBreedOutcome(BabyEntitySpawnEvent event) {
        AgeableMob ageableMob;
        if (((Boolean)ServerConfigs.HOGLIN_OFFSPRING_PROTECTION.get()).booleanValue() && (ageableMob = event.getChild()) instanceof Hoglin) {
            Hoglin baby = (Hoglin)ageableMob;
            ageableMob = event.getParentA();
            if (ageableMob instanceof Hoglin) {
                Hoglin parent1 = (Hoglin)ageableMob;
                ageableMob = event.getParentB();
                if (ageableMob instanceof Hoglin) {
                    Hoglin parent2 = (Hoglin)ageableMob;
                    double i = (parent1.m_34557_() ? 0.5 : 0.0) + (parent2.m_34557_() ? 0.5 : 0.0);
                    if ((double)Utils.random.m_188501_() < i) {
                        baby.m_34564_(true);
                    }
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onChangeDimensions(EntityTravelToDimensionEvent event) {
        Entity entity = event.getEntity();
        Level level = entity.f_19853_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Entity owner = SummonManager.getOwner(entity);
        if (owner != null) {
            event.setCanceled(true);
            return;
        }
        Set<UUID> summons = SummonManager.getSummons(entity);
        if (!summons.isEmpty()) {
            for (UUID uuid : summons) {
                Entity summon = serverLevel.m_8791_(uuid);
                if (summon instanceof IMagicSummon) {
                    IMagicSummon magicSummon = (IMagicSummon)summon;
                    magicSummon.onUnSummon();
                    continue;
                }
                if (summon == null) continue;
                SummonManager.removeSummon(summon);
            }
        }
    }
}

