/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.entity.mobs;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob.AbstractSpellCastingMob;
import io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob.AbstractSpellCastingMobRenderer;
import io.redspace.ironsspellbooks.render.ArmorCapeLayer;
import javax.annotation.Nonnull;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SwordItem;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.BlockAndItemGeoLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.renderer.layer.ItemArmorGeoLayer;
import software.bernie.geckolib.util.ClientUtils;
import software.bernie.geckolib.util.RenderUtils;

public class HumanoidRenderer<T extends Mob>
extends GeoEntityRenderer<T> {
    private static final String LEFT_HAND = "bipedHandLeft";
    private static final String RIGHT_HAND = "bipedHandRight";
    private static final String LEFT_BOOT = "armorBipedLeftFoot";
    private static final String RIGHT_BOOT = "armorBipedRightFoot";
    private static final String LEFT_BOOT_2 = "armorBipedLeftFoot2";
    private static final String RIGHT_BOOT_2 = "armorBipedRightFoot2";
    private static final String LEFT_ARMOR_LEG = "armorBipedLeftLeg";
    private static final String RIGHT_ARMOR_LEG = "armorBipedRightLeg";
    private static final String LEFT_ARMOR_LEG_2 = "armorBipedLeftLeg2";
    private static final String RIGHT_ARMOR_LEG_2 = "armorBipedRightLeg2";
    private static final String CHESTPLATE = "armorBipedBody";
    private static final String RIGHT_SLEEVE = "armorBipedRightArm";
    private static final String LEFT_SLEEVE = "armorBipedLeftArm";
    private static final String HELMET = "armorBipedHead";
    private final RenderLayer hardCodedCapeLayer = new ArmorCapeLayer(null, poseStack -> {});

    public HumanoidRenderer(EntityRendererProvider.Context renderManager, GeoModel<T> model) {
        super(renderManager, model);
        this.addRenderLayer((GeoRenderLayer)new ItemArmorGeoLayer<T>((GeoRenderer)this){

            @javax.annotation.Nullable
            protected ItemStack getArmorItemForBone(GeoBone bone, T animatable) {
                return switch (bone.getName()) {
                    case HumanoidRenderer.LEFT_BOOT, HumanoidRenderer.RIGHT_BOOT, HumanoidRenderer.LEFT_BOOT_2, HumanoidRenderer.RIGHT_BOOT_2 -> this.bootsStack;
                    case HumanoidRenderer.LEFT_ARMOR_LEG, HumanoidRenderer.RIGHT_ARMOR_LEG, HumanoidRenderer.LEFT_ARMOR_LEG_2, HumanoidRenderer.RIGHT_ARMOR_LEG_2 -> this.leggingsStack;
                    case HumanoidRenderer.CHESTPLATE, HumanoidRenderer.RIGHT_SLEEVE, HumanoidRenderer.LEFT_SLEEVE -> this.chestplateStack;
                    case HumanoidRenderer.HELMET -> this.helmetStack;
                    default -> null;
                };
            }

            @Nonnull
            protected EquipmentSlot getEquipmentSlotForBone(GeoBone bone, ItemStack stack, T animatable) {
                return switch (bone.getName()) {
                    case HumanoidRenderer.LEFT_BOOT, HumanoidRenderer.RIGHT_BOOT, HumanoidRenderer.LEFT_BOOT_2, HumanoidRenderer.RIGHT_BOOT_2 -> EquipmentSlot.FEET;
                    case HumanoidRenderer.LEFT_ARMOR_LEG, HumanoidRenderer.RIGHT_ARMOR_LEG, HumanoidRenderer.LEFT_ARMOR_LEG_2, HumanoidRenderer.RIGHT_ARMOR_LEG_2 -> EquipmentSlot.LEGS;
                    case HumanoidRenderer.RIGHT_SLEEVE -> {
                        if (!animatable.m_21526_()) {
                            yield EquipmentSlot.MAINHAND;
                        }
                        yield EquipmentSlot.OFFHAND;
                    }
                    case HumanoidRenderer.LEFT_SLEEVE -> {
                        if (animatable.m_21526_()) {
                            yield EquipmentSlot.OFFHAND;
                        }
                        yield EquipmentSlot.MAINHAND;
                    }
                    case HumanoidRenderer.CHESTPLATE -> EquipmentSlot.CHEST;
                    case HumanoidRenderer.HELMET -> EquipmentSlot.HEAD;
                    default -> super.getEquipmentSlotForBone(bone, stack, animatable);
                };
            }

            @Nonnull
            protected ModelPart getModelPartForBone(GeoBone bone, EquipmentSlot slot, ItemStack stack, T animatable, HumanoidModel<?> baseModel) {
                return switch (bone.getName()) {
                    case HumanoidRenderer.LEFT_BOOT, HumanoidRenderer.LEFT_BOOT_2, HumanoidRenderer.LEFT_ARMOR_LEG, HumanoidRenderer.LEFT_ARMOR_LEG_2 -> baseModel.f_102814_;
                    case HumanoidRenderer.RIGHT_BOOT, HumanoidRenderer.RIGHT_BOOT_2, HumanoidRenderer.RIGHT_ARMOR_LEG, HumanoidRenderer.RIGHT_ARMOR_LEG_2 -> baseModel.f_102813_;
                    case HumanoidRenderer.RIGHT_SLEEVE -> baseModel.f_102811_;
                    case HumanoidRenderer.LEFT_SLEEVE -> baseModel.f_102812_;
                    case HumanoidRenderer.CHESTPLATE -> baseModel.f_102810_;
                    case HumanoidRenderer.HELMET -> baseModel.f_102808_;
                    default -> super.getModelPartForBone(bone, slot, stack, animatable, baseModel);
                };
            }
        });
        this.addRenderLayer((GeoRenderLayer)new BlockAndItemGeoLayer<T>((GeoRenderer)this){

            @javax.annotation.Nullable
            protected ItemStack getStackForBone(GeoBone bone, T animatable) {
                if (animatable instanceof AbstractSpellCastingMob) {
                    AbstractSpellCastingMob castingMob = (AbstractSpellCastingMob)animatable;
                    String boneName = bone.getName();
                    if (HumanoidRenderer.this.isBoneMainHand(castingMob, boneName)) {
                        if (castingMob.isDrinkingPotion()) {
                            return AbstractSpellCastingMobRenderer.makePotion(castingMob);
                        }
                        if (HumanoidRenderer.this.shouldWeaponBeSheathed(castingMob) && castingMob.m_6844_(EquipmentSlot.MAINHAND).m_41720_() instanceof SwordItem) {
                            return ItemStack.f_41583_;
                        }
                    }
                    if (boneName.equals("torso") && HumanoidRenderer.this.shouldWeaponBeSheathed(castingMob) && castingMob.m_6844_(EquipmentSlot.MAINHAND).m_41720_() instanceof SwordItem) {
                        return castingMob.m_6844_(EquipmentSlot.MAINHAND);
                    }
                }
                return switch (bone.getName()) {
                    case HumanoidRenderer.LEFT_HAND -> {
                        if (animatable.m_21526_()) {
                            yield animatable.m_21205_();
                        }
                        yield animatable.m_21206_();
                    }
                    case HumanoidRenderer.RIGHT_HAND -> {
                        if (animatable.m_21526_()) {
                            yield animatable.m_21206_();
                        }
                        yield animatable.m_21205_();
                    }
                    default -> null;
                };
            }

            protected ItemDisplayContext getTransformTypeForStack(GeoBone bone, ItemStack stack, T animatable) {
                return switch (bone.getName()) {
                    case HumanoidRenderer.RIGHT_HAND, "torso" -> ItemDisplayContext.THIRD_PERSON_RIGHT_HAND;
                    case HumanoidRenderer.LEFT_HAND -> ItemDisplayContext.THIRD_PERSON_LEFT_HAND;
                    default -> ItemDisplayContext.NONE;
                };
            }

            protected void renderStackForBone(PoseStack poseStack, GeoBone bone, ItemStack stack, T animatable, MultiBufferSource bufferSource, float partialTick, int packedLight, int packedOverlay) {
                boolean offhand;
                poseStack.m_85837_(0.0, 0.0, -0.0625);
                poseStack.m_85837_(0.0, -0.0625, 0.0);
                boolean bl = offhand = stack == animatable.m_21206_();
                if (!offhand) {
                    poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
                    if (stack.m_41720_() instanceof ShieldItem) {
                        poseStack.m_85837_(0.0, 0.125, -0.25);
                    }
                } else {
                    poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
                    if (stack.m_41720_() instanceof ShieldItem) {
                        poseStack.m_85837_(0.0, 0.125, 0.25);
                        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                    }
                }
                if (animatable instanceof AbstractSpellCastingMob) {
                    AbstractSpellCastingMob mob = (AbstractSpellCastingMob)animatable;
                    if (bone.getName().equals("torso") && HumanoidRenderer.this.shouldWeaponBeSheathed(mob)) {
                        float hipOffset = animatable.m_6844_(EquipmentSlot.CHEST).m_41619_() ? 0.25f : 0.325f;
                        poseStack.m_85837_(animatable.m_21526_() ? (double)hipOffset : (double)(-hipOffset), 0.0, -0.4);
                        poseStack.m_252781_(Axis.f_252529_.m_252977_(215.0f));
                        poseStack.m_85841_(0.85f, 0.85f, 0.85f);
                    }
                }
                HumanoidRenderer.this.adjustHandItemRendering(poseStack, stack, animatable, partialTick, offhand);
                super.renderStackForBone(poseStack, bone, stack, animatable, bufferSource, partialTick, packedLight, packedOverlay);
            }
        });
    }

    protected boolean isBoneMainHand(AbstractSpellCastingMob entity, String boneName) {
        return entity.m_21526_() && boneName.equals(LEFT_HAND) || !entity.m_21526_() && boneName.equals(RIGHT_HAND);
    }

    protected boolean shouldWeaponBeSheathed(AbstractSpellCastingMob entity) {
        return entity.shouldSheathSword() && !entity.m_5912_();
    }

    protected void adjustHandItemRendering(PoseStack poseStack, ItemStack stack, T animatable, float partialTick, boolean offhand) {
    }

    public void render(T entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        if (entity.m_20145_() && entity.m_20177_(ClientUtils.getClientPlayer())) {
            return;
        }
        super.m_7392_(entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
        poseStack.m_85836_();
        float f = Mth.m_14189_((float)partialTick, (float)((Mob)entity).f_20884_, (float)((Mob)entity).f_20883_);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - f));
        if (((Mob)entity).f_20919_ > 0) {
            float deathRotation = ((float)((Mob)entity).f_20919_ + partialTick - 1.0f) / 20.0f * 1.6f;
            poseStack.m_252781_(Axis.f_252403_.m_252977_(Math.min(Mth.m_14116_((float)deathRotation), 1.0f) * this.getDeathMaxRotation((Entity)entity)));
        }
        this.model.getBone("torso").ifPresent(bone -> RenderUtils.prepMatrixForBone((PoseStack)poseStack, (CoreGeoBone)bone));
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        poseStack.m_252880_(0.0f, -1.501f, 0.0f);
        this.hardCodedCapeLayer.m_6494_(poseStack, bufferSource, packedLight, entity, 0.0f, 0.0f, partialTick, 0.0f, 0.0f, 0.0f);
        poseStack.m_85849_();
    }

    @Nullable
    public RenderType getRenderType(T animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        return animatable.m_20145_() ? RenderType.m_110467_((ResourceLocation)texture) : RenderType.m_110443_((ResourceLocation)texture, (boolean)false);
    }
}

