/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.capabilities.magic;

import io.redspace.ironsspellbooks.IronsSpellbooks;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.ICastDataSerializable;
import io.redspace.ironsspellbooks.capabilities.magic.PlayerRecasts;
import io.redspace.ironsspellbooks.capabilities.magic.RecastInstance;
import io.redspace.ironsspellbooks.capabilities.magic.RecastResult;
import io.redspace.ironsspellbooks.capabilities.magic.SummonedEntitiesCastData;
import io.redspace.ironsspellbooks.data.IronsDataStorage;
import io.redspace.ironsspellbooks.entity.mobs.IMagicSummon;
import io.redspace.ironsspellbooks.item.curios.CurioBaseItem;
import io.redspace.ironsspellbooks.registries.ItemRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber
public class SummonManager
implements INBTSerializable<CompoundTag> {
    public static final SummonManager INSTANCE = new SummonManager();
    private final HashMap<UUID, List<CompoundTag>> offlineSummonersToSavedEntities = new HashMap();
    private final HashMap<UUID, UUID> summonToOwner = new HashMap();
    private final HashMap<UUID, Set<UUID>> ownerToSummons = new HashMap();
    private final PriorityQueue<ExpirationInstance> summonExpirations = new PriorityQueue<ExpirationInstance>(Comparator.comparingInt(ExpirationInstance::expirationServerTick));

    @Nullable
    public static Entity getOwner(@NotNull Entity summon) {
        Level level = summon.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (SummonManager.INSTANCE.summonToOwner.containsKey(summon.m_20148_())) {
                return serverLevel.m_8791_(SummonManager.INSTANCE.summonToOwner.get(summon.m_20148_()));
            }
        } else {
            IronsSpellbooks.LOGGER.warn("Summon {} attempting to lookup owner from client!", (Object)summon);
        }
        return null;
    }

    public static Set<UUID> getSummons(Entity owner) {
        return Set.copyOf(SummonManager.INSTANCE.ownerToSummons.getOrDefault(owner.m_20148_(), Set.of()));
    }

    public static void setOwner(@NotNull Entity summon, @NotNull Entity owner) {
        SummonManager.removeSummon(summon);
        SummonManager.INSTANCE.summonToOwner.put(summon.m_20148_(), owner.m_20148_());
        SummonManager.startTrackingSummon(owner, summon);
        IronsDataStorage.INSTANCE.m_77762_();
    }

    public static void initSummon(Entity owner, Entity summon, int duration, SummonedEntitiesCastData summonedEntitiesCastData) {
        SummonManager.setOwner(summon, owner);
        SummonManager.setDuration(summon, duration);
        summonedEntitiesCastData.add(summon);
    }

    public static void setDuration(Entity summon, int duration) {
        Level level = summon.f_19853_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        SummonManager.INSTANCE.summonExpirations.add(new ExpirationInstance(summon.m_20148_(), serverLevel.m_7654_().m_129921_(), serverLevel.m_7654_().m_129921_() + duration));
    }

    public static void removeSummon(Entity summon) {
        Level level;
        UUID owner = SummonManager.INSTANCE.summonToOwner.remove(summon.m_20148_());
        if (owner == null) {
            return;
        }
        IronsDataStorage.INSTANCE.m_77762_();
        Set<UUID> summons = SummonManager.INSTANCE.ownerToSummons.get(owner);
        if (summons == null) {
            return;
        }
        UUID summonUuid = summon.m_20148_();
        summons.remove(summonUuid);
        IronsDataStorage.INSTANCE.m_77762_();
        if (summons.isEmpty()) {
            SummonManager.INSTANCE.ownerToSummons.remove(owner);
        }
        if ((level = summon.f_19853_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            SummonManager.removeFromRecastData(serverLevel, owner, summonUuid);
        }
    }

    public void handlePlayerDisconnect(ServerPlayer serverPlayer) {
        Set<UUID> summons = this.ownerToSummons.get(serverPlayer.m_20148_());
        if (summons == null) {
            return;
        }
        ServerLevel serverLevel = serverPlayer.m_284548_();
        ArrayList<CompoundTag> savedSummons = new ArrayList<CompoundTag>();
        for (UUID uuid : summons) {
            Entity entity = serverLevel.m_8791_(uuid);
            if (entity == null) continue;
            CompoundTag saveData = new CompoundTag();
            entity.m_20223_(saveData);
            int durationRemaining = INSTANCE.getExpirationTick(entity.m_20148_()) - serverLevel.m_7654_().m_129921_();
            saveData.m_128405_("summon_duration_remaining", durationRemaining);
            entity.m_142467_(Entity.RemovalReason.UNLOADED_WITH_PLAYER);
            savedSummons.add(saveData);
        }
        IronsDataStorage.INSTANCE.m_77762_();
        SummonManager.INSTANCE.offlineSummonersToSavedEntities.put(serverPlayer.m_20148_(), savedSummons);
        INSTANCE.stopTrackingSummonerAndSummons((Entity)serverPlayer);
    }

    public static boolean recastFinishedHelper(ServerPlayer serverPlayer, RecastInstance recastInstance, RecastResult recastResult, ICastDataSerializable castDataSerializable) {
        if (recastResult == RecastResult.COUNTERSPELL) {
            MagicData.getPlayerMagicData((LivingEntity)serverPlayer).getPlayerRecasts().forceAddRecast(recastInstance);
        } else if (recastResult != RecastResult.TIMEOUT) {
            if (castDataSerializable instanceof SummonedEntitiesCastData) {
                SummonedEntitiesCastData summonedEntitiesCastData = (SummonedEntitiesCastData)castDataSerializable;
                ServerLevel serverLevel = serverPlayer.m_284548_();
                summonedEntitiesCastData.getSummons().forEach(uuid -> {
                    Entity toRemove = serverLevel.m_8791_(uuid);
                    if (toRemove instanceof IMagicSummon) {
                        IMagicSummon summon = (IMagicSummon)toRemove;
                        summon.onUnSummon();
                    } else if (toRemove != null) {
                        toRemove.m_146870_();
                    }
                });
            }
        } else if (((CurioBaseItem)((Object)ItemRegistry.GREATER_CONJURERS_TALISMAN.get())).isEquippedBy((LivingEntity)serverPlayer)) {
            return false;
        }
        return true;
    }

    private static void removeFromRecastData(ServerLevel level, UUID ownerUuid, UUID summonUuid) {
        Entity entity = level.m_8791_(ownerUuid);
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        MagicData playerMagicData = MagicData.getPlayerMagicData((LivingEntity)player);
        PlayerRecasts recasts = playerMagicData.getPlayerRecasts();
        for (RecastInstance recastInstance : recasts.getActiveRecasts()) {
            SummonedEntitiesCastData summonData;
            ICastDataSerializable iCastDataSerializable = recastInstance.getCastData();
            if (!(iCastDataSerializable instanceof SummonedEntitiesCastData) || !(summonData = (SummonedEntitiesCastData)iCastDataSerializable).getSummons().contains(summonUuid)) continue;
            summonData.handleRemove(summonUuid, playerMagicData, recastInstance);
            break;
        }
    }

    private Optional<ExpirationInstance> getExpirationInstance(UUID uuid) {
        for (ExpirationInstance inst : this.summonExpirations) {
            if (!inst.uuid.equals(uuid)) continue;
            return Optional.of(inst);
        }
        return Optional.empty();
    }

    private int getExpirationTick(UUID uuid) {
        return this.getExpirationInstance(uuid).map(ExpirationInstance::expirationServerTick).orElse(0);
    }

    private static void startTrackingSummon(Entity owner, Entity summon) {
        Set summons = SummonManager.INSTANCE.ownerToSummons.computeIfAbsent(owner.m_20148_(), uuid -> new HashSet());
        summons.add(summon.m_20148_());
        IronsDataStorage.INSTANCE.m_77762_();
    }

    private void stopTrackingSummonerAndSummons(Entity summoner) {
        Set<UUID> summons = this.ownerToSummons.remove(summoner.m_20148_());
        if (summons != null) {
            IronsDataStorage.INSTANCE.m_77762_();
            summons.forEach(summonUUID -> {
                if (this.summonToOwner.remove(summonUUID) != null) {
                    this.getExpirationInstance((UUID)summonUUID).ifPresent(this.summonExpirations::remove);
                }
            });
        }
    }

    public static void stopTrackingExpiration(Entity summon) {
        INSTANCE.getExpirationInstance(summon.m_20148_()).ifPresent(SummonManager.INSTANCE.summonExpirations::remove);
    }

    public CompoundTag serializeNBT() {
        CompoundTag manager = new CompoundTag();
        ListTag offlineSummonsInstances = new ListTag();
        for (Map.Entry<UUID, List<CompoundTag>> entry : this.offlineSummonersToSavedEntities.entrySet()) {
            CompoundTag tag = new CompoundTag();
            tag.m_128362_("summoner", entry.getKey());
            ListTag summons = new ListTag();
            summons.addAll((Collection)entry.getValue());
            tag.m_128365_("summons", (Tag)summons);
            offlineSummonsInstances.add((Object)tag);
        }
        manager.m_128365_("OfflineSummons", (Tag)offlineSummonsInstances);
        return manager;
    }

    public void deserializeNBT(CompoundTag compoundTag) {
        ListTag offline = compoundTag.m_128437_("OfflineSummons", 10);
        for (Tag tag : offline) {
            CompoundTag entry = (CompoundTag)tag;
            UUID uuid = entry.m_128342_("summoner");
            ListTag summons = entry.m_128437_("summons", 10);
            ArrayList summonsList = new ArrayList();
            summons.forEach(t -> summonsList.add((CompoundTag)t));
            this.offlineSummonersToSavedEntities.put(uuid, summonsList);
        }
    }

    @SubscribeEvent
    public static void levelTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        MinecraftServer server = event.getServer();
        int tick = server.m_129921_();
        if (!SummonManager.INSTANCE.summonExpirations.isEmpty() && tick % 20 == 0) {
            ExpirationInstance nextDespawn = SummonManager.INSTANCE.summonExpirations.peek();
            while (nextDespawn.expirationServerTick < tick) {
                ServerLevel serverLevel;
                SummonManager.INSTANCE.summonExpirations.remove();
                UUID uuid = nextDespawn.uuid;
                Entity toRemove = null;
                Iterator iterator = server.m_129785_().iterator();
                while (iterator.hasNext() && (toRemove = (serverLevel = (ServerLevel)iterator.next()).m_8791_(uuid)) == null) {
                }
                if (toRemove instanceof IMagicSummon) {
                    IMagicSummon summon = (IMagicSummon)toRemove;
                    summon.onUnSummon();
                } else if (toRemove != null) {
                    toRemove.m_146870_();
                }
                if (SummonManager.INSTANCE.summonExpirations.isEmpty()) break;
                nextDespawn = SummonManager.INSTANCE.summonExpirations.peek();
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            INSTANCE.handlePlayerDisconnect(serverPlayer);
        }
    }

    @SubscribeEvent
    public static void onServerStopping(ServerStoppingEvent event) {
        event.getServer().m_6846_().m_11314_().forEach(INSTANCE::handlePlayerDisconnect);
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        Level level = player.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            IronsDataStorage.INSTANCE.m_77762_();
            List<CompoundTag> savedSummons = SummonManager.INSTANCE.offlineSummonersToSavedEntities.remove(player.m_20148_());
            MinecraftServer server = serverLevel.m_7654_();
            if (savedSummons != null) {
                HashSet<UUID> summonsSet = new HashSet<UUID>();
                UUID ownerUUID = player.m_20148_();
                for (CompoundTag summon : savedSummons) {
                    Entity summonedEntity = EntityType.m_20642_((CompoundTag)summon, (Level)serverLevel).orElse(null);
                    if (summonedEntity != null) {
                        serverLevel.m_47205_(summonedEntity);
                        UUID summonUUID = summonedEntity.m_20148_();
                        summonsSet.add(summonUUID);
                        SummonManager.INSTANCE.summonToOwner.put(summonUUID, ownerUUID);
                        SummonManager.INSTANCE.summonExpirations.add(new ExpirationInstance(summonUUID, server.m_129921_(), server.m_129921_() + summon.m_128451_("summon_duration_remaining")));
                    }
                    SummonManager.INSTANCE.ownerToSummons.put(ownerUUID, summonsSet);
                }
            }
        }
    }

    record ExpirationInstance(UUID uuid, int summonedServerTick, int expirationServerTick) {
    }
}

