/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.item;

import com.google.common.collect.Lists;
import com.magistuarmory.client.render.model.ModModels;
import com.magistuarmory.item.ArmorDecoration;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ArmorDecorationItem
extends Item
implements ArmorDecoration {
    ResourceLocation location;
    ArmorItem.Type armorType;

    public ArmorDecorationItem(ResourceLocation location, Item.Properties properties, ArmorItem.Type armorType) {
        super(properties);
        this.location = location;
        this.armorType = armorType;
    }

    @Override
    public ResourceLocation getResourceLocation() {
        return this.location;
    }

    @Override
    public ArmorItem.Type getArmorType() {
        return this.armorType;
    }

    public static List<DecorationInfo> createDecorations(@Nullable ListTag listtag) {
        ArrayList list = Lists.newArrayList();
        if (listtag != null) {
            for (int i = 0; i < listtag.size(); ++i) {
                CompoundTag tag = listtag.m_128728_(i);
                String name = tag.m_128461_("name");
                boolean dyeable = tag.m_128471_("dyeable");
                int j = tag.m_128451_("color");
                list.add(new DecorationInfo(name, dyeable, j));
            }
        }
        return list;
    }

    @Override
    public CompoundTag getCompoundTag(ItemStack stack) {
        CompoundTag compoundnbt = new CompoundTag();
        compoundnbt.m_128359_("name", this.location.toString());
        compoundnbt.m_128379_("dyeable", false);
        compoundnbt.m_128405_("color", 1);
        return compoundnbt;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isApplicableForDecoration(ItemStack stack) {
        if (ArmorDecorationItem.getDecorationTags(stack).size() >= 8) return false;
        Item item = stack.m_41720_();
        if (!(item instanceof ArmorItem)) return false;
        ArmorItem armor = (ArmorItem)item;
        if (this.getArmorType() != armor.m_266204_()) return false;
        return true;
    }

    public static ListTag getDecorationTags(ItemStack stack) {
        CompoundTag compoundtag = stack.m_41737_("ArmorDecoration");
        if (compoundtag == null) {
            return new ListTag();
        }
        return compoundtag.m_128437_("Items", 10);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        tooltip.add((Component)Component.m_237115_((String)("magistuarmory.armor_decoration." + this.getArmorType().m_266355_() + ".description")).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.BLUE).m_131155_(Boolean.valueOf(true))));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ModelLayerLocation createModelLocation() {
        return ModModels.createDecorationLocation(this.location);
    }

    public record DecorationInfo(String name, boolean dyeable, int color) {
        public ResourceLocation location() {
            ResourceLocation loc = new ResourceLocation(this.name);
            return new ResourceLocation(!loc.m_135827_().equals("minecraft") ? loc.m_135827_() : "magistuarmory", loc.m_135815_());
        }
    }
}

