/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.utils;

import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.block.IOwnerProtected;
import net.mehvahdjukaar.moonlight.api.block.IRotatable;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.CompatObjects;
import net.mehvahdjukaar.supplementaries.integration.QuarkCompat;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.piston.PistonHeadBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class BlockUtil {
    public static <T extends Comparable<T>, A extends Property<T>> BlockState replaceProperty(BlockState from, BlockState to, A property) {
        if (from.m_61138_(property)) {
            return (BlockState)to.m_61124_(property, from.m_61143_(property));
        }
        return to;
    }

    public static <T extends BlockEntity> void addOptionalOwnership(LivingEntity placer, T tileEntity) {
        if (CommonConfigs.General.SERVER_PROTECTION.get().booleanValue() && placer instanceof Player) {
            ((IOwnerProtected)tileEntity).setOwner(placer.m_20148_());
        }
    }

    public static void addOptionalOwnership(LivingEntity placer, Level world, BlockPos pos) {
        BlockEntity blockEntity;
        if (CommonConfigs.General.SERVER_PROTECTION.get().booleanValue() && placer instanceof Player && (blockEntity = world.m_7702_(pos)) instanceof IOwnerProtected) {
            IOwnerProtected tile = (IOwnerProtected)blockEntity;
            tile.setOwner(placer.m_20148_());
        }
    }

    public static Optional<Direction> tryRotatingBlockAndConnected(Direction face, boolean ccw, BlockPos targetPos, Level level, Vec3 hit) {
        BlockState state = level.m_8055_(targetPos);
        Block block = state.m_60734_();
        if (block instanceof IRotatable) {
            IRotatable rotatable = (IRotatable)block;
            return rotatable.rotateOverAxis(state, (LevelAccessor)level, targetPos, ccw ? Rotation.COUNTERCLOCKWISE_90 : Rotation.CLOCKWISE_90, face, hit);
        }
        Optional<Direction> special = BlockUtil.tryRotatingSpecial(face, ccw, targetPos, level, state, hit);
        if (special.isPresent()) {
            return special;
        }
        Optional<Direction> ret = BlockUtil.tryRotatingBlock(face, ccw, targetPos, level, state, hit);
        if (ret.isEmpty()) {
            ret = BlockUtil.tryRotatingBlock(Direction.UP, ccw, targetPos, level, level.m_8055_(targetPos), hit);
        }
        return ret;
    }

    public static Optional<Direction> tryRotatingBlock(Direction face, boolean ccw, BlockPos targetPos, Level level, Vec3 hit) {
        return BlockUtil.tryRotatingBlock(face, ccw, targetPos, level, level.m_8055_(targetPos), hit);
    }

    public static Optional<Direction> tryRotatingBlock(Direction dir, boolean ccw, BlockPos targetPos, Level level, BlockState state, Vec3 hit) {
        BlockState rotated;
        Block block;
        if (!level.f_46443_ && CommonConfigs.Redstone.TURN_TABLE_SHUFFLE.get().booleanValue() && dir.m_122434_() != Direction.Axis.Y && state.m_61138_((Property)BarrelBlock.f_49042_) && !state.m_204336_(ModTags.TURN_TABLE_CANT_SHUFFLE) && (block = level.m_7702_(targetPos)) instanceof Container) {
            Container c = (Container)block;
            BlockUtil.shuffleContainerContent(c, level);
        }
        if ((block = state.m_60734_()) instanceof IRotatable) {
            IRotatable rotatable = (IRotatable)block;
            return rotatable.rotateOverAxis(state, (LevelAccessor)level, targetPos, ccw ? Rotation.COUNTERCLOCKWISE_90 : Rotation.CLOCKWISE_90, dir, hit);
        }
        Optional<BlockState> optional = BlockUtil.getRotatedState(dir, ccw, targetPos, level, state);
        if (optional.isPresent() && (rotated = optional.get()).m_60710_((LevelReader)level, targetPos) && (rotated = Block.m_49931_((BlockState)rotated, (LevelAccessor)level, (BlockPos)targetPos)) != state) {
            if (level instanceof ServerLevel) {
                level.m_7731_(targetPos, rotated, 11);
                level.m_213960_(rotated, targetPos, rotated.m_60734_(), targetPos, false);
            }
            return Optional.of(dir);
        }
        return Optional.empty();
    }

    public static Optional<BlockState> getRotatedState(Direction dir, boolean ccw, BlockPos targetPos, Level world, BlockState state) {
        Block verticalPlanks;
        SlabType type;
        Optional<BlockState> res;
        if (BlockUtil.isBlacklisted(state)) {
            return Optional.empty();
        }
        Rotation rot = ccw ? Rotation.COUNTERCLOCKWISE_90 : Rotation.CLOCKWISE_90;
        Block block = state.m_60734_();
        if (state.m_61138_((Property)ModBlockProperties.FLIPPED)) {
            return Optional.of((BlockState)state.m_61122_((Property)ModBlockProperties.FLIPPED));
        }
        if (dir.m_122434_() == Direction.Axis.Y) {
            int bites;
            Block dc;
            if (block == Blocks.f_50145_ && (dc = CompatObjects.DIRECTIONAL_CAKE.get()) != null && (bites = ((Integer)state.m_61143_((Property)CakeBlock.f_51180_)).intValue()) != 0) {
                return Optional.of(ForgeHelper.rotateBlock((BlockState)((BlockState)dc.m_49966_().m_61124_((Property)CakeBlock.f_51180_, (Comparable)Integer.valueOf(bites))), (Level)world, (BlockPos)targetPos, (Rotation)rot));
            }
            BlockState rotated = ForgeHelper.rotateBlock((BlockState)state, (Level)world, (BlockPos)targetPos, (Rotation)rot);
            if (rotated == state) {
                rotated = BlockUtil.rotateVerticalStandard(state, rotated, rot);
            }
            return Optional.of(rotated);
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61376_) && state.m_61138_((Property)BlockStateProperties.f_61374_) && (res = BlockUtil.getRotatedHorizontalFaceBlock(state, dir, ccw)).isPresent()) {
            return res;
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61372_)) {
            return BlockUtil.getRotatedDirectionalBlock(state, dir, ccw);
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61365_)) {
            Direction.Axis targetAxis = (Direction.Axis)state.m_61143_((Property)BlockStateProperties.f_61365_);
            Direction.Axis myAxis = dir.m_122434_();
            if (myAxis == Direction.Axis.X) {
                return Optional.of((BlockState)state.m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)(targetAxis == Direction.Axis.Y ? Direction.Axis.Z : Direction.Axis.Y)));
            }
            if (myAxis == Direction.Axis.Z) {
                return Optional.of((BlockState)state.m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)(targetAxis == Direction.Axis.Y ? Direction.Axis.X : Direction.Axis.Y)));
            }
        }
        if (block instanceof StairBlock) {
            return BlockUtil.getRotatedStairs(state, dir, ccw);
        }
        if (state.m_61138_((Property)SlabBlock.f_56353_)) {
            type = (SlabType)state.m_61143_((Property)SlabBlock.f_56353_);
            if (type == SlabType.DOUBLE) {
                return Optional.empty();
            }
            return Optional.of((BlockState)state.m_61124_((Property)SlabBlock.f_56353_, (Comparable)(type == SlabType.BOTTOM ? SlabType.TOP : SlabType.BOTTOM)));
        }
        if (state.m_61138_((Property)TrapDoorBlock.f_57515_)) {
            return Optional.of((BlockState)state.m_61122_((Property)TrapDoorBlock.f_57515_));
        }
        if (CompatHandler.QUARK && (type = (WoodType)WoodTypeRegistry.INSTANCE.getBlockTypeOf((ItemLike)block)) != null && type.planks == block && (verticalPlanks = type.getBlockOfThis("quark:vertical_planks")) != null) {
            return Optional.of(verticalPlanks.m_49966_());
        }
        return Optional.empty();
    }

    private static BlockState rotateVerticalStandard(BlockState state, BlockState rotated, Rotation rot) {
        if (state.m_61138_((Property)BlockStateProperties.f_61372_)) {
            rotated = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)));
        } else if (state.m_61138_((Property)BlockStateProperties.f_61374_)) {
            rotated = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)));
        } else if (state.m_61138_((Property)RotatedPillarBlock.f_55923_)) {
            rotated = RotatedPillarBlock.m_154376_((BlockState)state, (Rotation)rot);
        } else if (state.m_61138_((Property)BlockStateProperties.f_61364_)) {
            rotated = (BlockState)state.m_61122_((Property)BlockStateProperties.f_61364_);
        }
        return rotated;
    }

    private static boolean isBlacklisted(BlockState state) {
        if (state.m_60734_() instanceof BedBlock) {
            return true;
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61392_) && state.m_61143_((Property)BlockStateProperties.f_61392_) != ChestType.SINGLE) {
            return true;
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61432_) && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61432_)).booleanValue()) {
            return true;
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61449_)) {
            return true;
        }
        return state.m_204336_(ModTags.ROTATION_BLACKLIST);
    }

    private static Optional<Direction> tryRotatingSpecial(Direction face, boolean ccw, BlockPos pos, Level level, BlockState state, Vec3 hit) {
        Optional<Direction> opt;
        Rotation rot;
        Block b = state.m_60734_();
        Rotation rotation = rot = ccw ? Rotation.COUNTERCLOCKWISE_90 : Rotation.CLOCKWISE_90;
        if (state.m_61138_((Property)BlockStateProperties.f_61390_)) {
            int r = (Integer)state.m_61143_((Property)BlockStateProperties.f_61390_);
            if ((r += ccw ? -1 : 1) < 0) {
                r += 16;
            }
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61390_, (Comparable)Integer.valueOf(r %= 16)), 2);
            return Optional.of(Direction.UP);
        }
        if ((state.m_61138_((Property)BlockStateProperties.f_61449_) || state.m_61138_((Property)PistonBaseBlock.f_60153_) && state.m_61138_((Property)PistonBaseBlock.f_52588_)) && (opt = BlockUtil.rotatePistonHead(state, pos, level, face, ccw)).isPresent()) {
            return opt;
        }
        if (b instanceof BedBlock) {
            return BlockUtil.rotateBedBlock(face, pos, level, state, rot);
        }
        if (b instanceof ChestBlock) {
            return BlockUtil.rotateDoubleChest(face, pos, level, state, rot);
        }
        if (DoorBlock.m_52817_((BlockState)state)) {
            // empty if block
        }
        if (CompatHandler.QUARK && QuarkCompat.tryRotateStool(level, state, pos)) {
            return Optional.of(face);
        }
        return Optional.empty();
    }

    public static void shuffleContainerContent(Container c, Level level) {
        int size = c.m_6643_();
        boolean changed = false;
        for (int i = size - 1; i > 0; --i) {
            int j = level.f_46441_.m_188503_(i + 1);
            if (i == j) continue;
            ItemStack firstItem = c.m_8020_(i);
            ItemStack secondItem = c.m_8020_(j);
            if (!c.m_271862_(c, i, firstItem) || !c.m_271862_(c, j, secondItem) || !c.m_7013_(j, firstItem) || !c.m_7013_(i, secondItem)) continue;
            c.m_6836_(i, secondItem);
            c.m_6836_(j, firstItem);
            changed = true;
        }
        if (changed) {
            c.m_6596_();
        }
    }

    public static Optional<BlockState> getRotatedStairs(BlockState state, Direction axis, boolean ccw) {
        boolean positive;
        Direction facing = (Direction)state.m_61143_((Property)StairBlock.f_56841_);
        if (facing.m_122434_() == axis.m_122434_()) {
            return Optional.empty();
        }
        boolean flipped = axis.m_122421_() == Direction.AxisDirection.POSITIVE ^ ccw;
        Half half = (Half)state.m_61143_((Property)StairBlock.f_56842_);
        boolean top = half == Half.TOP;
        boolean bl = positive = facing.m_122421_() == Direction.AxisDirection.POSITIVE;
        if (top ^ positive ^ flipped) {
            half = top ? Half.BOTTOM : Half.TOP;
        } else {
            facing = facing.m_122424_();
        }
        return Optional.of((BlockState)((BlockState)state.m_61124_((Property)StairBlock.f_56842_, (Comparable)half)).m_61124_((Property)StairBlock.f_56841_, (Comparable)facing));
    }

    public static Optional<BlockState> getRotatedDirectionalBlock(BlockState state, Direction axis, boolean ccw) {
        Vec3 rotated;
        Vec3 targetNormal = MthUtils.V3itoV3((Vec3i)((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)).m_122436_());
        Vec3 myNormal = MthUtils.V3itoV3((Vec3i)axis.m_122436_());
        if (!ccw) {
            targetNormal = targetNormal.m_82490_(-1.0);
        }
        if (!(rotated = myNormal.m_82537_(targetNormal)).equals((Object)Vec3.f_82478_)) {
            Direction newDir = Direction.m_122366_((double)rotated.m_7096_(), (double)rotated.m_7098_(), (double)rotated.m_7094_());
            return Optional.of((BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)newDir));
        }
        return Optional.empty();
    }

    public static Optional<BlockState> getRotatedHorizontalFaceBlock(BlockState original, Direction axis, boolean ccw) {
        Direction facingDir = (Direction)original.m_61143_((Property)BlockStateProperties.f_61374_);
        if (facingDir.m_122434_() == axis.m_122434_()) {
            return Optional.empty();
        }
        AttachFace face = (AttachFace)original.m_61143_((Property)BlockStateProperties.f_61376_);
        return Optional.of(switch (face) {
            default -> throw new IncompatibleClassChangeError();
            case AttachFace.FLOOR -> (BlockState)((BlockState)original.m_61124_((Property)BlockStateProperties.f_61376_, (Comparable)AttachFace.WALL)).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)(ccw ? axis.m_122427_() : axis.m_122428_()));
            case AttachFace.CEILING -> (BlockState)((BlockState)original.m_61124_((Property)BlockStateProperties.f_61376_, (Comparable)AttachFace.WALL)).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)(!ccw ? axis.m_122427_() : axis.m_122428_()));
            case AttachFace.WALL -> (BlockState)original.m_61124_((Property)BlockStateProperties.f_61376_, (Comparable)(facingDir.m_122421_() == Direction.AxisDirection.POSITIVE ^ (ccw ^= axis.m_122421_() != Direction.AxisDirection.POSITIVE) ? AttachFace.CEILING : AttachFace.FLOOR));
        });
    }

    private static Optional<Direction> rotateDoubleChest(Direction face, BlockPos pos, Level level, BlockState state, Rotation rot) {
        if (state.m_61143_((Property)ChestBlock.f_51479_) != ChestType.SINGLE) {
            BlockState newChest = ForgeHelper.rotateBlock((BlockState)state, (Level)level, (BlockPos)pos, (Rotation)rot);
            BlockPos oldPos = pos.m_121945_(ChestBlock.m_51584_((BlockState)state));
            BlockPos targetPos = pos.m_121945_(ChestBlock.m_51584_((BlockState)newChest));
            if (level.m_8055_(targetPos).m_247087_()) {
                BlockState connectedNewState = ForgeHelper.rotateBlock((BlockState)level.m_8055_(oldPos), (Level)level, (BlockPos)oldPos, (Rotation)rot);
                level.m_7731_(targetPos, connectedNewState, 2);
                level.m_7731_(pos, newChest, 2);
                BlockEntity tile = level.m_7702_(oldPos);
                if (tile != null) {
                    CompoundTag tag = tile.m_187482_();
                    BlockEntity blockEntity = level.m_7702_(targetPos);
                    if (blockEntity instanceof ChestBlockEntity) {
                        ChestBlockEntity newChestTile = (ChestBlockEntity)blockEntity;
                        newChestTile.m_142466_(tag);
                    }
                    tile.m_7651_();
                }
                level.m_46597_(oldPos, Blocks.f_50016_.m_49966_());
                return Optional.of(face);
            }
        }
        return Optional.empty();
    }

    public static Optional<Direction> rotatePistonHead(BlockState state, BlockPos pos, Level level, Direction face, boolean ccw) {
        Optional<BlockState> rotatedHead;
        BlockPos newHeadPos;
        BlockState oldHead;
        BlockPos oldHeadPos;
        Optional<BlockState> newBase = BlockUtil.getRotatedDirectionalBlock(state, face, ccw);
        if (newBase.isEmpty()) {
            return Optional.empty();
        }
        BlockState newBaseState = newBase.get();
        if (state.m_61138_((Property)PistonHeadBlock.f_60236_)) {
            oldHeadPos = pos.m_121945_(((Direction)state.m_61143_((Property)PistonHeadBlock.f_52588_)).m_122424_());
            oldHead = level.m_8055_(oldHeadPos);
            if (!oldHead.m_61138_((Property)PistonBaseBlock.f_60153_)) {
                return Optional.empty();
            }
            newHeadPos = pos.m_121945_(((Direction)newBaseState.m_61143_((Property)PistonHeadBlock.f_52588_)).m_122424_());
        } else if (state.m_61138_((Property)PistonBaseBlock.f_60153_)) {
            oldHeadPos = pos.m_121945_((Direction)state.m_61143_((Property)PistonHeadBlock.f_52588_));
            oldHead = level.m_8055_(oldHeadPos);
            if (!oldHead.m_61138_((Property)PistonHeadBlock.f_60236_)) {
                return Optional.empty();
            }
            newHeadPos = pos.m_121945_((Direction)newBaseState.m_61143_((Property)PistonBaseBlock.f_52588_));
        } else {
            return Optional.empty();
        }
        if (level.m_8055_(newHeadPos).m_247087_() && (rotatedHead = BlockUtil.getRotatedDirectionalBlock(oldHead, face, ccw)).isPresent()) {
            level.m_7731_(newHeadPos, rotatedHead.get(), 2);
            level.m_7731_(pos, newBaseState, 2);
            level.m_7471_(oldHeadPos, false);
            return Optional.of(face);
        }
        return Optional.empty();
    }

    @NotNull
    public static Optional<Direction> rotateBedBlock(Direction face, BlockPos pos, Level level, BlockState state, Rotation rot) {
        BlockState newBed = ForgeHelper.rotateBlock((BlockState)state, (Level)level, (BlockPos)pos, (Rotation)rot);
        BlockPos oldPos = pos.m_121945_(BlockUtil.getConnectedBedDirection(state));
        BlockPos targetPos = pos.m_121945_(BlockUtil.getConnectedBedDirection(newBed));
        if (level.m_8055_(targetPos).m_247087_()) {
            level.m_7731_(targetPos, ForgeHelper.rotateBlock((BlockState)level.m_8055_(oldPos), (Level)level, (BlockPos)oldPos, (Rotation)rot), 2);
            level.m_7731_(pos, newBed, 2);
            level.m_7471_(oldPos, false);
            return Optional.of(face);
        }
        return Optional.empty();
    }

    public static Direction getConnectedBedDirection(BlockState bedState) {
        BedPart part = (BedPart)bedState.m_61143_((Property)BedBlock.f_49440_);
        Direction dir = (Direction)bedState.m_61143_((Property)BedBlock.f_54117_);
        return part == BedPart.FOOT ? dir : dir.m_122424_();
    }
}

