/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.crafttweaker.managers;

import blusunrize.immersiveengineering.api.crafting.ArcFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.IERecipeTypes;
import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.CrTIngredientUtil;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.actions.AbstractActionRemoveMultipleOutputs;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.action.recipe.ActionAddRecipe;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.ingredient.IIngredientWithAmount;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.common.util.Lazy;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="mods/immersiveengineering/ArcFurnace")
@ZenCodeType.Name(value="mods.immersiveengineering.ArcFurnace")
public class ArcFurnaceRecipeManager
implements IRecipeManager<ArcFurnaceRecipe> {
    public RecipeType<ArcFurnaceRecipe> getRecipeType() {
        return IERecipeTypes.ARC_FURNACE.get();
    }

    @ZenCodeType.Method
    public void addRecipe(String recipePath, IIngredientWithAmount mainIngredient, IIngredientWithAmount[] additives, int time, int energy, IItemStack[] outputs, @ZenCodeType.Optional(value="<item:minecraft:air>") IItemStack slag) {
        ResourceLocation resourceLocation = new ResourceLocation("crafttweaker", recipePath);
        List<Lazy<ItemStack>> outputList = CrTIngredientUtil.getNonNullList(outputs);
        IngredientWithSize main = CrTIngredientUtil.getIngredientWithSize(mainIngredient);
        IngredientWithSize[] additivesWithSize = CrTIngredientUtil.getIngredientsWithSize(additives);
        ArcFurnaceRecipe recipe = IEServerConfig.MACHINES.arcFurnaceConfig.apply(new ArcFurnaceRecipe(resourceLocation, outputList, IESerializableRecipe.of(slag.getInternal()), List.of(), time, energy, main, additivesWithSize));
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, (Recipe)recipe, null));
    }

    public void remove(IIngredient output) {
        this.remove(output, false);
    }

    @ZenCodeType.Method
    public void remove(IIngredient output, final boolean checkSlag) {
        CraftTweakerAPI.apply((IAction)new AbstractActionRemoveMultipleOutputs<ArcFurnaceRecipe>((IRecipeManager)this, output){

            @Override
            public List<ItemStack> getAllOutputs(ArcFurnaceRecipe recipe) {
                ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>((Collection)recipe.output.get());
                if (checkSlag) {
                    itemStacks.add((ItemStack)recipe.slag.get());
                }
                return itemStacks;
            }

            @Override
            public String describe() {
                return super.describe() + ", " + (checkSlag ? "including" : "excluding") + " slag outputs";
            }
        });
    }
}

