/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.mixin;

import java.util.function.Predicate;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.orcinus.galosphere.criterion.GCriterion;
import net.orcinus.galosphere.entities.GlowFlare;
import net.orcinus.galosphere.entities.SpectreFlare;
import net.orcinus.galosphere.entities.ThrowableLaunchedProjectile;
import net.orcinus.galosphere.init.GCriteriaTriggers;
import net.orcinus.galosphere.init.GItems;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CrossbowItem.class})
public class CrossbowItemMixin {
    @Unique
    private static final Predicate<ItemStack> PREDICATE = stack -> stack.m_150930_((Item)GItems.GLOW_FLARE.get()) || stack.m_150930_((Item)GItems.SPECTRE_FLARE.get());

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/world/item/CrossbowItem;setCharged(Lnet/minecraft/world/item/ItemStack;Z)V")}, method={"releaseUsing"})
    private void GE$releaseUsing(ItemStack itemStack, Level level, LivingEntity livingEntity, int i, CallbackInfo ci) {
        ItemStack projectileStack = ProjectileWeaponItem.m_43010_((LivingEntity)livingEntity, PREDICATE);
        if (!projectileStack.m_41619_() && livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!player.m_150110_().f_35937_) {
                projectileStack.m_41774_(1);
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"shootProjectile"}, cancellable=true)
    private static void GE$shootProjectile(Level world, LivingEntity entity, InteractionHand hand, ItemStack stack, ItemStack ammo, float p_40900_, boolean p_40901_, float p_40902_, float p_40903_, float p_40904_, CallbackInfo ci) {
        if (!world.f_46443_ && PREDICATE.test(ammo)) {
            ThrowableLaunchedProjectile projectile;
            ci.cancel();
            boolean isSpectreFlare = ammo.m_150930_((Item)GItems.SPECTRE_FLARE.get());
            ThrowableLaunchedProjectile throwableLaunchedProjectile = projectile = isSpectreFlare ? new SpectreFlare(world, ammo, (Entity)entity, entity.m_20185_(), entity.m_20188_() - (double)0.15f, entity.m_20189_(), true) : new GlowFlare(world, ammo, (Entity)entity, entity.m_20185_(), entity.m_20188_() - (double)0.15f, entity.m_20189_(), true);
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                GCriterion criteria = isSpectreFlare ? GCriteriaTriggers.USE_SPECTRE_FLARE : GCriteriaTriggers.LIGHT_SPREAD;
                criteria.trigger(serverPlayer);
            }
            if (entity instanceof CrossbowAttackMob) {
                CrossbowAttackMob crossbowattackmob = (CrossbowAttackMob)entity;
                crossbowattackmob.m_5811_(crossbowattackmob.m_5448_(), stack, (Projectile)projectile, p_40904_);
            } else {
                Vec3 vec3 = entity.m_20289_(1.0f);
                Quaternionf quaternionf = new Quaternionf().setAngleAxis((double)(p_40904_ * ((float)Math.PI / 180)), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
                Vec3 vec32 = entity.m_20252_(1.0f);
                Vector3f vector3f = vec32.m_252839_().rotate((Quaternionfc)quaternionf);
                projectile.m_6686_(vector3f.x(), vector3f.y(), vector3f.z(), p_40902_, p_40903_);
            }
            stack.m_41622_(3, entity, e -> e.m_21190_(hand));
            world.m_7967_((Entity)projectile);
            world.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11847_, SoundSource.PLAYERS, 1.0f, p_40900_);
        }
    }
}

