/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities.ai.tasks;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Unit;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.level.BlockGetter;
import net.orcinus.galosphere.entities.Berserker;
import net.orcinus.galosphere.entities.Preserved;
import net.orcinus.galosphere.init.GEntityTypes;
import net.orcinus.galosphere.init.GMemoryModuleTypes;
import net.orcinus.galosphere.init.GSoundEvents;

public class Summon
extends Behavior<Berserker> {
    private static final int MAX_DURATION = 70;

    public Summon() {
        super((Map)ImmutableMap.of((Object)((MemoryModuleType)GMemoryModuleTypes.RAMPAGE_TICKS.get()), (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.f_148205_, (Object)MemoryStatus.VALUE_PRESENT, (Object)((MemoryModuleType)GMemoryModuleTypes.IS_SMASHING.get()), (Object)MemoryStatus.VALUE_ABSENT, (Object)((MemoryModuleType)GMemoryModuleTypes.IS_IMPALING.get()), (Object)MemoryStatus.VALUE_ABSENT, (Object)((MemoryModuleType)GMemoryModuleTypes.IS_SUMMONING.get()), (Object)MemoryStatus.REGISTERED, (Object)((MemoryModuleType)GMemoryModuleTypes.SUMMONING_COOLDOWN.get()), (Object)MemoryStatus.VALUE_ABSENT, (Object)((MemoryModuleType)GMemoryModuleTypes.SUMMON_COUNT.get()), (Object)MemoryStatus.REGISTERED), 70);
    }

    protected boolean checkExtraStartConditions(ServerLevel serverLevel, Berserker livingEntity) {
        return livingEntity.m_21223_() / livingEntity.m_21233_() <= 0.66f && livingEntity.m_217003_(Pose.STANDING) && livingEntity.shouldAttack();
    }

    protected boolean canStillUse(ServerLevel serverLevel, Berserker livingEntity, long l) {
        return true;
    }

    protected void start(ServerLevel serverLevel, Berserker livingEntity, long l) {
        Brain<Berserker> brain = livingEntity.m_6274_();
        brain.m_21882_((MemoryModuleType)GMemoryModuleTypes.IS_SUMMONING.get(), (Object)Unit.INSTANCE, 70L);
        brain.m_21936_(MemoryModuleType.f_26370_);
        livingEntity.setPhase(Berserker.Phase.SUMMONING);
        livingEntity.m_5496_((SoundEvent)GSoundEvents.BERSERKER_SUMMONING.get(), 10.0f, 1.0f);
    }

    protected void tick(ServerLevel serverLevel, Berserker livingEntity, long l) {
        Brain<Berserker> brain = livingEntity.m_6274_();
        brain.m_21879_((MemoryModuleType)GMemoryModuleTypes.SUMMON_COUNT.get(), (Object)(brain.m_21952_((MemoryModuleType)GMemoryModuleTypes.SUMMON_COUNT.get()).orElse(0) + 1));
        List<LivingEntity> list = serverLevel.m_45976_(LivingEntity.class, livingEntity.m_20191_().m_82400_(4.0)).stream().filter(livingEntity::canTargetEntity).filter(e -> e.m_20148_() != livingEntity.m_20148_()).toList();
        float time = livingEntity.m_6274_().m_147341_((MemoryModuleType)GMemoryModuleTypes.IS_SUMMONING.get());
        if (time > 20.0f) {
            for (LivingEntity entity : list) {
                if (time % 4.0f != 0.0f) continue;
                entity.m_6469_(serverLevel.m_269111_().m_269333_((LivingEntity)livingEntity), 2.0f);
            }
        }
        int max = UniformInt.m_146622_((int)3, (int)5).m_214085_(serverLevel.m_213780_());
        if (serverLevel.m_46791_() == Difficulty.HARD) {
            max = UniformInt.m_146622_((int)4, (int)8).m_214085_(serverLevel.m_213780_());
        }
        if (brain.m_21874_((MemoryModuleType)GMemoryModuleTypes.SUMMON_COUNT.get()) && (Integer)brain.m_21952_((MemoryModuleType)GMemoryModuleTypes.SUMMON_COUNT.get()).get() > max) {
            return;
        }
        brain.m_21936_(MemoryModuleType.f_26370_);
        List<BlockPos> positions = IntStream.range(0, 5).mapToObj(i -> LandRandomPos.m_148488_((PathfinderMob)livingEntity, (int)(i * 2), (int)1)).filter(Objects::nonNull).map(BlockPos::m_274446_).filter(blockPos -> livingEntity.m_9236_().m_6857_().m_61937_(blockPos)).map(BlockPos::m_7495_).filter(blockPos -> serverLevel.m_8055_(blockPos).m_60838_((BlockGetter)serverLevel, blockPos)).toList();
        BlockPos randomPos = positions.get(serverLevel.m_213780_().m_188503_(positions.size()));
        Preserved preserved = (Preserved)((EntityType)GEntityTypes.PRESERVED.get()).m_262451_(serverLevel, null, null, livingEntity.m_20183_(), MobSpawnType.TRIGGERED, true, true);
        preserved.m_7678_(randomPos.m_123341_(), randomPos.m_123342_() + 1, randomPos.m_123343_(), 0.0f, 0.0f);
        preserved.m_21153_(preserved.m_21233_() * ((float)livingEntity.m_217043_().m_216339_(4, 7) / 10.0f));
        serverLevel.m_47205_((Entity)preserved);
    }

    protected void stop(ServerLevel serverLevel, Berserker livingEntity, long l) {
        livingEntity.setPhase(Berserker.Phase.IDLING);
        livingEntity.m_6274_().m_21882_((MemoryModuleType)GMemoryModuleTypes.SUMMONING_COOLDOWN.get(), (Object)Unit.INSTANCE, 600L);
        livingEntity.m_6274_().m_21879_((MemoryModuleType)GMemoryModuleTypes.SUMMON_COUNT.get(), (Object)0);
    }
}

