/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.feature.DripstoneUtils;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import net.orcinus.galosphere.api.SpectreBoundSpyglass;
import net.orcinus.galosphere.entities.SpectatorVision;
import net.orcinus.galosphere.entities.ThrowableLaunchedProjectile;
import net.orcinus.galosphere.init.GEntityTypes;
import net.orcinus.galosphere.init.GItems;
import net.orcinus.galosphere.init.GNetworkHandler;
import net.orcinus.galosphere.init.GSoundEvents;
import net.orcinus.galosphere.network.SendPerspectivePacket;
import org.jetbrains.annotations.Nullable;

public class SpectreFlare
extends ThrowableLaunchedProjectile {
    public SpectreFlare(EntityType<? extends SpectreFlare> type, Level world) {
        super(type, world);
    }

    public SpectreFlare(Level world, ItemStack stack, Entity entity, double x, double y, double z, boolean shotAtAngle) {
        super(world, stack, entity, x, y, z, shotAtAngle);
    }

    public SpectreFlare(Level level, @Nullable Entity entity, ItemStack itemStack) {
        super((EntityType<? extends FireworkRocketEntity>)((EntityType)GEntityTypes.SPECTRE_FLARE.get()), level);
        if (!itemStack.m_41619_() && itemStack.m_41782_()) {
            this.f_19804_.m_135381_(f_37019_, (Object)itemStack.m_41777_());
        }
        this.f_19804_.m_135381_(THROWN, (Object)true);
        this.m_5602_(entity);
    }

    @Override
    public void handleLaunchedProjectile() {
        Level world = this.m_9236_();
        if (!world.f_46443_ && this.f_37022_ > this.f_37023_) {
            this.spawnSpectatorVision(this.m_20182_());
            world.m_7605_((Entity)this, (byte)17);
            this.m_146852_(GameEvent.f_157812_, this.m_19749_());
            this.m_146870_();
        }
    }

    @Override
    protected Item getDefaultItem() {
        return (Item)GItems.SPECTRE_FLARE.get();
    }

    protected void m_8060_(BlockHitResult result) {
        Level world = this.m_9236_();
        if (!world.m_5776_()) {
            BlockPos hitPos = result.m_82425_();
            BlockPos placePos = hitPos.m_121945_(result.m_82434_());
            if (world.m_8055_(hitPos).m_60838_((BlockGetter)world, hitPos) && (world.m_6425_(placePos).m_205070_(FluidTags.f_13132_) || world.m_7433_(placePos, DripstoneUtils::m_159664_))) {
                this.spawnSpectatorVision(Vec3.m_82512_((Vec3i)placePos));
            }
            this.m_146870_();
        }
    }

    private void spawnSpectatorVision(Vec3 vec3) {
        ServerPlayer serverPlayer;
        Entity entity = this.m_19749_();
        if (entity instanceof ServerPlayer && !((SpectreBoundSpyglass)(serverPlayer = (ServerPlayer)entity)).isUsingSpectreBoundedSpyglass()) {
            SpectatorVision spectatorVision = SpectatorVision.create(this.m_9236_(), vec3, serverPlayer, 120);
            serverPlayer.m_6330_((SoundEvent)GSoundEvents.SPECTRE_MANIPULATE_BEGIN.get(), this.m_5720_(), 1.0f, 1.0f);
            this.m_9236_().m_7967_((Entity)spectatorVision);
            ((SpectreBoundSpyglass)serverPlayer).setUsingSpectreBoundedSpyglass(true);
            GNetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new SendPerspectivePacket(serverPlayer.m_20148_(), spectatorVision.m_19879_()));
        }
    }

    @Override
    public ItemStack m_7846_() {
        return new ItemStack((ItemLike)GItems.SPECTRE_FLARE.get());
    }
}

