/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities;

import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ambient.AmbientCreature;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.orcinus.galosphere.api.Spectatable;
import net.orcinus.galosphere.api.SpectreBoundSpyglass;
import net.orcinus.galosphere.init.GEntityTypes;
import net.orcinus.galosphere.init.GParticleTypes;
import net.orcinus.galosphere.init.GSoundEvents;
import org.jetbrains.annotations.Nullable;

public class SpectatorVision
extends AmbientCreature
implements Spectatable {
    private static final EntityDataAccessor<Optional<UUID>> MANIPULATOR = SynchedEntityData.m_135353_(SpectatorVision.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Integer> PHASE = SynchedEntityData.m_135353_(SpectatorVision.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SPECTATING_TICKS = SynchedEntityData.m_135353_(SpectatorVision.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public SpectatorVision(Level level) {
        super((EntityType)GEntityTypes.SPECTATOR_VISION.get(), level);
    }

    public SpectatorVision(EntityType<? extends AmbientCreature> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 1.0).m_22268_(Attributes.f_22280_, (double)0.1f).m_22268_(Attributes.f_22279_, (double)0.1f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MANIPULATOR, Optional.empty());
        this.f_19804_.m_135372_(PHASE, (Object)0);
        this.f_19804_.m_135372_(SPECTATING_TICKS, (Object)0);
    }

    public boolean m_6673_(DamageSource damageSource) {
        return true;
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.getManipulatorUUID() == null) {
            this.m_146870_();
        }
        if (!this.m_9236_().m_5776_() || this.matchesClientPlayerUUID()) {
            ((Optional)this.f_19804_.m_135370_(MANIPULATOR)).ifPresent(this::spectateTick);
        }
        if (!this.m_9236_().f_46443_) {
            int spectatableTime = this.getSpectatableTime();
            if (spectatableTime > 0) {
                this.setSpectatableTime(spectatableTime - 1);
            }
            if (this.getPhase() < 12 && this.f_19797_ % 5 == 0) {
                this.setPhase(this.getPhase() + 1);
            }
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_ && this.f_19796_.m_188503_(5) == 0) {
            int count = UniformInt.m_146622_((int)3, (int)6).m_214085_(this.f_19796_);
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            BlockPos blockPos = this.m_20183_();
            int range = 3;
            for (int i = 0; i < count; ++i) {
                mutableBlockPos.m_122154_((Vec3i)blockPos, Mth.m_216271_((RandomSource)this.f_19796_, (int)(-range), (int)range), Mth.m_216271_((RandomSource)this.f_19796_, (int)(-range), (int)range), Mth.m_216271_((RandomSource)this.f_19796_, (int)(-range), (int)range));
                if (this.m_9236_().m_8055_((BlockPos)mutableBlockPos).m_60838_((BlockGetter)this.m_9236_(), (BlockPos)mutableBlockPos)) continue;
                float velX = 0.06f * (float)(blockPos.m_123341_() - mutableBlockPos.m_123341_());
                float velY = 0.06f * (float)(blockPos.m_123342_() - mutableBlockPos.m_123342_());
                float velZ = 0.06f * (float)(blockPos.m_123343_() - mutableBlockPos.m_123343_());
                this.m_9236_().m_7106_((ParticleOptions)GParticleTypes.SPECTATE_ORB.get(), (double)((float)mutableBlockPos.m_123341_() + 0.5f), (double)mutableBlockPos.m_123342_(), (double)((float)mutableBlockPos.m_123343_() + 0.5f), (double)velX, (double)velY, (double)velZ);
            }
        }
    }

    public HumanoidArm m_5737_() {
        return null;
    }

    public void m_7378_(CompoundTag tag) {
        UUID uuid;
        super.m_7378_(tag);
        this.setSpectatableTime(tag.m_128451_("SpectatingTicks"));
        this.setPhase(tag.m_128451_("Phase"));
        if (tag.m_128403_("Manipulator")) {
            uuid = tag.m_128342_("Manipulator");
        } else {
            String s = tag.m_128461_("Manipulator");
            uuid = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s);
        }
        if (uuid != null) {
            this.setManipulatorUUID(uuid);
        }
    }

    public Iterable<ItemStack> m_6168_() {
        return Collections.emptyList();
    }

    public ItemStack m_6844_(EquipmentSlot equipmentSlot) {
        return ItemStack.f_41583_;
    }

    public void m_7023_(Vec3 vec3) {
        if (this.getManipulatorUUID() != null) {
            ((Optional)this.f_19804_.m_135370_(MANIPULATOR)).map(arg_0 -> ((Level)this.m_9236_()).m_46003_(arg_0)).ifPresent(uuid -> this.copyPlayerRotation((LivingEntity)this, (Player)uuid));
        } else {
            super.m_7023_(vec3);
        }
    }

    public void m_8061_(EquipmentSlot equipmentSlot, ItemStack itemStack) {
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        if (this.getManipulatorUUID() != null) {
            tag.m_128362_("Manipulator", this.getManipulatorUUID());
        }
        tag.m_128405_("SpectatingTicks", this.getSpectatableTime());
        tag.m_128405_("Phase", this.getPhase());
    }

    @Override
    @Nullable
    public UUID getManipulatorUUID() {
        return ((Optional)this.f_19804_.m_135370_(MANIPULATOR)).orElse(null);
    }

    @Override
    public void setManipulatorUUID(@Nullable UUID uuid) {
        this.f_19804_.m_135381_(MANIPULATOR, Optional.ofNullable(uuid));
    }

    @Override
    public void spectateTick(UUID uuid) {
        Player player = this.m_9236_().m_46003_(uuid);
        if (player != null) {
            player.f_20900_ = 0.0f;
            player.f_20902_ = 0.0f;
            player.m_6862_(false);
            ((SpectreBoundSpyglass)player).setUsingSpectreBoundedSpyglass(this.getSpectatableTime() > 0);
            if (player.m_20163_() || this.getSpectatableTime() == 0) {
                this.setManipulatorUUID(null);
                if (this.m_9236_().f_46443_) {
                    this.stopUsingSpyglass(player);
                } else {
                    ((SpectreBoundSpyglass)player).setUsingSpectreBoundedSpyglass(false);
                    player.m_6330_((SoundEvent)GSoundEvents.SPECTRE_MANIPULATE_END.get(), this.m_5720_(), 1.0f, 1.0f);
                    this.setManipulatorUUID(null);
                }
            }
        }
        if (!this.m_9236_().m_5776_() && player == null) {
            this.f_19804_.m_135381_(MANIPULATOR, Optional.empty());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void stopUsingSpyglass(Player player) {
        Minecraft client = Minecraft.m_91087_();
        if (client.f_91074_ == player) {
            client.m_91118_((Entity)player);
        }
    }

    public int getPhase() {
        return (Integer)this.f_19804_.m_135370_(PHASE);
    }

    public void setPhase(int phase) {
        this.f_19804_.m_135381_(PHASE, (Object)phase);
    }

    public static SpectatorVision create(Level world, Vec3 blockPos, ServerPlayer serverPlayer, int ticks) {
        SpectatorVision spectatorVision = new SpectatorVision(world);
        spectatorVision.m_6027_(blockPos.f_82479_, blockPos.f_82480_, blockPos.f_82481_);
        spectatorVision.setSpectatableTime(ticks);
        spectatorVision.setManipulatorUUID(serverPlayer.m_20148_());
        return spectatorVision;
    }

    public int getSpectatableTime() {
        return (Integer)this.f_19804_.m_135370_(SPECTATING_TICKS);
    }

    public void setSpectatableTime(int spectatableTime) {
        this.f_19804_.m_135381_(SPECTATING_TICKS, (Object)spectatableTime);
    }
}

