/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Unit;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.orcinus.galosphere.entities.ai.BerserkerAi;
import net.orcinus.galosphere.init.GEntityTypeTags;
import net.orcinus.galosphere.init.GMemoryModuleTypes;
import net.orcinus.galosphere.init.GMobEffects;
import net.orcinus.galosphere.init.GParticleTypes;
import net.orcinus.galosphere.init.GSensorTypes;
import net.orcinus.galosphere.init.GSoundEvents;
import org.jetbrains.annotations.Nullable;

public class Berserker
extends Monster {
    protected static final ImmutableList<? extends SensorType<? extends Sensor<? super Berserker>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.f_26811_, (Object)SensorType.f_26812_, (Object)SensorType.f_26814_, (Object)((SensorType)GSensorTypes.BLIGHTED_ENTITY_SENSOR.get()));
    protected static final ImmutableList<? extends MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.f_26375_, (Object)MemoryModuleType.f_148204_, (Object)MemoryModuleType.f_148205_, (Object)MemoryModuleType.f_26368_, (Object)MemoryModuleType.f_148206_, (Object)MemoryModuleType.f_26371_, (Object)MemoryModuleType.f_26370_, (Object)MemoryModuleType.f_26326_, (Object)MemoryModuleType.f_26377_, (Object)MemoryModuleType.f_26372_, (Object)MemoryModuleType.f_26373_, (Object)MemoryModuleType.f_26383_, (Object[])new MemoryModuleType[]{MemoryModuleType.f_26381_, MemoryModuleType.f_26382_, MemoryModuleType.f_148194_, (MemoryModuleType)GMemoryModuleTypes.IMPALING_COOLDOWN.get(), (MemoryModuleType)GMemoryModuleTypes.IMPALING_COUNT.get(), (MemoryModuleType)GMemoryModuleTypes.IS_SMASHING.get(), (MemoryModuleType)GMemoryModuleTypes.IS_IMPALING.get(), (MemoryModuleType)GMemoryModuleTypes.IS_SUMMONING.get(), (MemoryModuleType)GMemoryModuleTypes.SUMMONING_COOLDOWN.get(), (MemoryModuleType)GMemoryModuleTypes.SUMMON_COUNT.get(), (MemoryModuleType)GMemoryModuleTypes.SMASHING_COOLDOWN.get(), (MemoryModuleType)GMemoryModuleTypes.HURT_COUNT.get(), (MemoryModuleType)GMemoryModuleTypes.RAMPAGE_TICKS.get(), MemoryModuleType.f_217771_, MemoryModuleType.f_217769_, (MemoryModuleType)GMemoryModuleTypes.IS_SHAKING.get()});
    private static final EntityDataAccessor<String> PHASE = SynchedEntityData.m_135353_(Berserker.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Integer> STATIONARY_TICKS = SynchedEntityData.m_135353_(Berserker.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> SHEDDING = SynchedEntityData.m_135353_(Berserker.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final List<MobEffect> selectedEffects = (List)Util.m_137469_((Object)Lists.newArrayList(), list -> {
        list.add((MobEffect)GMobEffects.BLOCK_BANE.get());
        list.add(MobEffects.f_19599_);
    });
    public AnimationState roarAnimationState = new AnimationState();
    public AnimationState attackAnimationState = new AnimationState();
    public AnimationState punchAnimationState = new AnimationState();
    public AnimationState impalingAnimationState = new AnimationState();
    public AnimationState summoningAnimationState = new AnimationState();

    public Berserker(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.f_21365_ = new BerserkerLookControl((Mob)this);
    }

    public boolean m_6673_(DamageSource damageSource) {
        Entity entity = damageSource.m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!player.m_150110_().f_35937_ && this.getStationaryTicks() > 0) {
                return true;
            }
        }
        return super.m_6673_(damageSource);
    }

    public float m_274421_() {
        return 1.0f;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PHASE, (Object)Phase.IDLING.name());
        this.f_19804_.m_135372_(STATIONARY_TICKS, (Object)0);
        this.f_19804_.m_135372_(SHEDDING, (Object)false);
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        String phase = compoundTag.m_128461_("Phase");
        if (!phase.isEmpty()) {
            this.setPhase(Phase.valueOf(phase));
        }
        this.setStationaryTicks(compoundTag.m_128451_("StationaryTicks"));
        this.setShedding(compoundTag.m_128471_("Shedding"));
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128359_("Phase", this.getPhase().name());
        compoundTag.m_128405_("StationaryTicks", this.getStationaryTicks());
        compoundTag.m_128379_("Shedding", this.isShedding());
    }

    public boolean shouldAttack() {
        return this.getPhase() == Phase.IDLING && !this.isStationary();
    }

    public int getStage() {
        float health = this.m_21223_() / this.m_21233_();
        if (this.isStationary()) {
            return 3;
        }
        if (health > 0.66f) {
            return 0;
        }
        if (health <= 0.66f && health > 0.33f) {
            return 1;
        }
        return 2;
    }

    public void setShedding(boolean shedding) {
        this.f_19804_.m_135381_(SHEDDING, (Object)shedding);
    }

    public boolean isShedding() {
        return (Boolean)this.f_19804_.m_135370_(SHEDDING);
    }

    public void setStationaryTicks(int stationaryTicks) {
        this.f_19804_.m_135381_(STATIONARY_TICKS, (Object)stationaryTicks);
    }

    public int getStationaryTicks() {
        return (Integer)this.f_19804_.m_135370_(STATIONARY_TICKS);
    }

    public void setPhase(Phase phase) {
        if (phase == Phase.IDLING) {
            this.m_20124_(Pose.STANDING);
        } else if (phase == Phase.SMASH) {
            this.m_9236_().m_7605_((Entity)this, (byte)4);
        } else if (phase == Phase.UNDERMINE) {
            this.m_9236_().m_7605_((Entity)this, (byte)6);
        } else if (phase == Phase.SUMMONING) {
            this.m_9236_().m_7605_((Entity)this, (byte)7);
        }
        this.f_19804_.m_135381_(PHASE, (Object)phase.name());
    }

    public void m_7822_(byte b) {
        if (b == 4) {
            this.attackAnimationState.m_216977_(this.f_19797_);
        } else if (b == 5) {
            this.punchAnimationState.m_216977_(this.f_19797_);
        } else if (b == 6) {
            this.impalingAnimationState.m_216977_(this.f_19797_);
        } else if (b == 7) {
            this.summoningAnimationState.m_216977_(this.f_19797_);
        } else if (b == 32) {
            BlockPos blockPos = this.m_20097_();
            this.m_9236_().m_7106_((ParticleOptions)GParticleTypes.IMPACT.get(), (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 1.15, (double)blockPos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
        } else {
            super.m_7822_(b);
        }
    }

    public Phase getPhase() {
        String s = (String)this.f_19804_.m_135370_(PHASE);
        return Phase.valueOf(s);
    }

    public void m_8107_() {
        super.m_8107_();
        double range = 0.75;
        double threshold = range - 0.6;
        double increment = 0.2;
        if (!this.m_9236_().f_46443_) {
            int count = 250;
            boolean stationary = this.isStationary();
            boolean shedding = this.isShedding();
            if (this.m_21223_() < this.m_21233_() && this.f_19797_ % count == 0) {
                this.m_5634_(10.0f);
            }
            if (stationary) {
                this.m_6274_().m_147339_().keySet().stream().filter(memoryModuleType -> memoryModuleType.equals(MemoryModuleType.f_26370_) || memoryModuleType.equals(MemoryModuleType.f_26371_)).forEach(arg_0 -> this.m_6274_().m_21936_(arg_0));
                List<Player> list = this.m_9236_().m_45976_(Player.class, this.m_20191_().m_82400_(3.0)).stream().filter(p -> !p.m_7500_() && p.m_6084_()).toList();
                Optional player = list.stream().findAny();
                if (!shedding) {
                    player.ifPresent(this::setTarget);
                } else {
                    list.stream().filter(ServerPlayer.class::isInstance).map(ServerPlayer.class::cast).forEach(serverPlayer -> CriteriaTriggers.f_10580_.m_68256_(serverPlayer, (Entity)this));
                    if (this.getStationaryTicks() == 32) {
                        this.m_6274_().m_21879_((MemoryModuleType)GMemoryModuleTypes.IS_SHAKING.get(), (Object)Unit.INSTANCE);
                    }
                    this.setStationaryTicks(this.getStationaryTicks() - 1);
                    this.addParticles(range, increment, threshold);
                }
            } else if (shedding) {
                this.setShedding(false);
                this.m_21530_();
            }
        }
    }

    private void addParticles(double range, double increment, double threshold) {
        if (this.f_19797_ % 20 == 0) {
            for (double y = 0.0; y <= 1.95; y += 0.35) {
                for (double x = -range; x <= range; x += increment) {
                    for (double z = -range; z <= range; z += increment) {
                        if (x >= -threshold && x <= threshold || z >= -threshold && z <= threshold) continue;
                        ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)((SimpleParticleType)GParticleTypes.PINK_SALT_FALLING_DUST.get()), this.m_20185_() + x, this.m_20186_() + y, this.m_20189_() + z, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
            }
        }
    }

    public boolean isStationary() {
        return this.getStationaryTicks() > 0;
    }

    private void setTarget(Player player) {
        Brain<Berserker> brain = this.m_6274_();
        brain.m_21879_(MemoryModuleType.f_26372_, (Object)player);
        this.setShedding(true);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        if (mobSpawnType == MobSpawnType.STRUCTURE) {
            this.setStationaryTicks(100);
        }
        return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return this.isStationary() ? null : (SoundEvent)GSoundEvents.BERSERKER_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)GSoundEvents.BERSERKER_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)GSoundEvents.BERSERKER_DEATH.get();
    }

    protected SoundEvent getStepSound() {
        return (SoundEvent)GSoundEvents.BERSERKER_STEP.get();
    }

    protected void m_7355_(BlockPos blockPos, BlockState blockState) {
        this.m_5496_(this.getStepSound(), 1.0f, 1.0f);
    }

    public boolean canTargetEntity(@Nullable Entity entity) {
        Entity e2;
        Entity entity2;
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        Predicate<LivingEntity> predicate = e -> e.m_6095_().m_204039_(GEntityTypeTags.BERSERKER_INVALID_TARGETS);
        if (livingEntity.m_20147_() || livingEntity.m_21224_() || predicate.test(livingEntity)) {
            return false;
        }
        DamageSource lastSource = this.m_21225_();
        if (lastSource != null && (entity2 = (e2 = lastSource.m_7639_())) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity2;
            if (e2 == livingEntity && !predicate.test(living)) {
                return true;
            }
        }
        if (this.m_9236_() != entity.m_9236_() || !EntitySelector.f_20406_.test(entity) || this.m_7307_(entity) || !this.m_9236_().m_6857_().m_61935_(livingEntity.m_20191_())) {
            return false;
        }
        return livingEntity instanceof Player || livingEntity instanceof AbstractVillager || livingEntity instanceof IronGolem || livingEntity instanceof Turtle;
    }

    protected void m_267689_(float f) {
        float g = Math.min(f * 10.0f, 1.0f);
        this.f_267362_.m_267566_(g, 0.2f);
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        if (f_19806_.equals(entityDataAccessor) && this.m_20089_() == Pose.EMERGING) {
            this.roarAnimationState.m_216977_(this.f_19797_);
        }
        super.m_7350_(entityDataAccessor);
    }

    public boolean shouldUseMeleeAttack() {
        Optional memory = this.m_6274_().m_21952_(MemoryModuleType.f_26372_);
        return memory.filter(livingEntity -> this.m_217066_((LivingEntity)livingEntity) && this.getPhase() != Phase.SMASH && this.shouldAttack() && this.isInHardMode() && this.m_6274_().m_21952_((MemoryModuleType)GMemoryModuleTypes.RAMPAGE_TICKS.get()).isPresent() && (Integer)this.m_6274_().m_21952_((MemoryModuleType)GMemoryModuleTypes.RAMPAGE_TICKS.get()).get() > 0).isPresent();
    }

    public boolean isInHardMode() {
        return this.m_9236_().m_46791_() == Difficulty.HARD;
    }

    public boolean m_7327_(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (livingEntity instanceof AbstractGolem || livingEntity instanceof TamableAnimal) {
                double dist = Math.max(1.0f, this.m_20270_((Entity)livingEntity));
                livingEntity.m_6469_(this.m_9236_().m_269111_().m_269333_((LivingEntity)this), (float)((double)livingEntity.m_21233_() / (dist / 2.0)));
            }
            if (this.shouldUseMeleeAttack()) {
                Vec3 start = this.m_20182_().m_82520_(0.0, (double)1.6f, 0.0);
                Vec3 diff = entity.m_146892_().m_82546_(start);
                Vec3 normalized = diff.m_82541_();
                double knockbackX = 0.25 * (1.0 - livingEntity.m_21133_(Attributes.f_22278_));
                double knockbackY = 1.5 * (1.0 - livingEntity.m_21133_(Attributes.f_22278_));
                livingEntity.m_5997_(normalized.m_7096_() * knockbackY, normalized.m_7098_() * knockbackX, normalized.m_7094_() * knockbackY);
                this.m_9236_().m_7605_((Entity)this, (byte)5);
                this.m_5496_((SoundEvent)GSoundEvents.BERSERKER_PUNCH.get(), 1.0f, 1.0f);
            }
            boolean flag = true;
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                if (player.m_150110_().f_35937_) {
                    flag = false;
                }
            }
            if (flag) {
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 100));
            }
        }
        return super.m_7327_(entity);
    }

    public boolean m_213824_() {
        return true;
    }

    public boolean m_6469_(DamageSource damageSource, float f) {
        if (!this.m_9236_().f_46443_ && this.getPhase() != Phase.IDLING && this.isInHardMode()) {
            if (this.m_6274_().m_21952_((MemoryModuleType)GMemoryModuleTypes.HURT_COUNT.get()).isEmpty()) {
                this.m_6274_().m_21879_((MemoryModuleType)GMemoryModuleTypes.HURT_COUNT.get(), (Object)0);
            } else {
                int i = (Integer)this.m_6274_().m_21952_((MemoryModuleType)GMemoryModuleTypes.HURT_COUNT.get()).get() + 1;
                if (i > 2) {
                    this.m_6274_().m_21879_((MemoryModuleType)GMemoryModuleTypes.RAMPAGE_TICKS.get(), (Object)UniformInt.m_146622_((int)30, (int)150).m_214085_(this.m_217043_()));
                }
                this.m_6274_().m_21879_((MemoryModuleType)GMemoryModuleTypes.HURT_COUNT.get(), (Object)i);
            }
        }
        if (damageSource.m_7640_() instanceof AbstractArrow && this.getPhase() != Phase.IDLING) {
            return false;
        }
        return super.m_6469_(damageSource, f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Berserker.m_33035_().m_22268_(Attributes.f_22276_, 155.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22282_, 1.5);
    }

    protected Brain.Provider<Berserker> m_5490_() {
        return Brain.m_21923_(MEMORY_TYPES, SENSOR_TYPES);
    }

    protected Brain<?> m_8075_(Dynamic<?> dynamic) {
        return BerserkerAi.makeBrain(this, (Brain<Berserker>)this.m_5490_().m_22073_(dynamic));
    }

    public Brain<Berserker> m_6274_() {
        return super.m_6274_();
    }

    protected void m_8024_() {
        this.m_9236_().m_46473_().m_6180_("berserkerBrain");
        this.m_6274_().m_21865_((ServerLevel)this.m_9236_(), (LivingEntity)this);
        this.m_9236_().m_46473_().m_7238_();
        BerserkerAi.updateActivity(this);
        super.m_8024_();
        if ((this.f_19797_ + this.m_19879_()) % 1200 == 0) {
            this.selectedEffects.forEach(mobEffect -> {
                MobEffectInstance mobEffectInstance = new MobEffectInstance(mobEffect, 6000, 2);
                MobEffectUtil.m_216946_((ServerLevel)((ServerLevel)this.m_9236_()), (Entity)this, (Vec3)this.m_20182_(), (double)50.0, (MobEffectInstance)mobEffectInstance, (int)1200);
            });
        }
        if (this.m_6274_().m_21952_(MemoryModuleType.f_26382_).isEmpty() && this.getPhase() != Phase.IDLING) {
            this.setPhase(Phase.IDLING);
        }
    }

    public void m_7023_(Vec3 vec3) {
        if (this.isStationary() && this.m_20096_()) {
            this.m_20256_(this.m_20184_().m_82542_(0.0, 1.0, 0.0));
            vec3 = vec3.m_82542_(0.0, 1.0, 0.0);
        }
        super.m_7023_(vec3);
    }

    public class BerserkerLookControl
    extends LookControl {
        public BerserkerLookControl(Mob mob) {
            super(mob);
        }

        public void m_8128_() {
            if (!Berserker.this.isStationary()) {
                super.m_8128_();
            }
        }
    }

    public static enum Phase {
        IDLING,
        SMASH,
        UNDERMINE,
        SUMMONING;

    }
}

