/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.upgrade.chemical;

import java.util.List;
import java.util.function.Predicate;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.pigment.IPigmentHandler;
import mekanism.api.chemical.pigment.IPigmentTank;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.providers.IPigmentProvider;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.recipe.upgrade.chemical.ChemicalRecipeData;
import mekanism.common.tile.base.SubstanceType;
import mekanism.common.tile.base.TileEntityMekanism;
import net.minecraft.core.Direction;
import net.minecraft.nbt.ListTag;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class PigmentRecipeData
extends ChemicalRecipeData<Pigment, PigmentStack, IPigmentTank, IPigmentHandler> {
    public PigmentRecipeData(ListTag tanks) {
        super(tanks);
    }

    private PigmentRecipeData(List<IPigmentTank> tanks) {
        super(tanks);
    }

    protected PigmentRecipeData create(List<IPigmentTank> tanks) {
        return new PigmentRecipeData(tanks);
    }

    @Override
    protected SubstanceType getSubstanceType() {
        return SubstanceType.PIGMENT;
    }

    @Override
    protected ChemicalTankBuilder<Pigment, PigmentStack, IPigmentTank> getTankBuilder() {
        return ChemicalTankBuilder.PIGMENT;
    }

    @Override
    protected IPigmentHandler getOutputHandler(final List<IPigmentTank> tanks) {
        return new IPigmentHandler.IMekanismPigmentHandler(){

            @Override
            @NotNull
            public List<IPigmentTank> getChemicalTanks(@Nullable Direction side) {
                return tanks;
            }

            @Override
            public void onContentsChanged() {
            }
        };
    }

    @Override
    protected Capability<IPigmentHandler> getCapability() {
        return Capabilities.PIGMENT_HANDLER;
    }

    @Override
    protected Predicate<Pigment> cloneValidator(IPigmentHandler handler, int tank) {
        return type -> handler.isValid(tank, new PigmentStack((IPigmentProvider)type, 1L));
    }

    @Override
    protected IPigmentHandler getHandlerFromTile(TileEntityMekanism tile) {
        return (IPigmentHandler)tile.getPigmentManager().getInternal();
    }
}

