/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.config.value;

import mekanism.api.functions.ShortSupplier;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.config.value.CachedValue;
import net.minecraftforge.common.ForgeConfigSpec;

public class CachedShortValue
extends CachedValue<Short>
implements ShortSupplier {
    private boolean resolved;
    private short cachedValue;

    private CachedShortValue(IMekanismConfig config, ForgeConfigSpec.ConfigValue<Short> internal) {
        super(config, internal);
    }

    public static CachedShortValue wrap(IMekanismConfig config, ForgeConfigSpec.ConfigValue<Short> internal) {
        return new CachedShortValue(config, internal);
    }

    public short getOrDefault() {
        if (this.resolved || this.isLoaded()) {
            return this.get();
        }
        return (Short)this.internal.getDefault();
    }

    public short get() {
        if (!this.resolved) {
            this.cachedValue = (Short)this.internal.get();
            this.resolved = true;
        }
        return this.cachedValue;
    }

    @Override
    public short getAsShort() {
        return this.get();
    }

    public void set(short value) {
        this.internal.set((Object)value);
        this.cachedValue = value;
    }

    @Override
    protected boolean clearCachedValue(boolean checkChanged) {
        if (!this.resolved) {
            return false;
        }
        short oldCachedValue = this.cachedValue;
        this.resolved = false;
        return checkChanged && oldCachedValue != this.get();
    }
}

