/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.recipestages.recipes;

import com.blamejared.recipestages.ClientStuff;
import com.blamejared.recipestages.RecipeStages;
import com.blamejared.recipestages.RecipeStagesUtil;
import com.blamejared.recipestages.ServerStuff;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;

public interface IStagedRecipe
extends CraftingRecipe {
    public String getStage();

    public ResourceLocation m_6423_();

    public CraftingRecipe getRecipe();

    default public ItemStack assemble(CraftingContainer inv, RegistryAccess registryAccess) {
        if (this.isGoodForCrafting(inv)) {
            return this.forceAssemble(inv, registryAccess);
        }
        return ItemStack.f_41583_;
    }

    default public ItemStack forceAssemble(CraftingContainer inv, RegistryAccess registryAccess) {
        return this.getRecipe().m_5874_((Container)inv, registryAccess);
    }

    default public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        return this.getRecipe().m_7457_((Container)inv);
    }

    default public boolean matches(CraftingContainer inv, Level worldIn) {
        return this.getRecipe().m_5818_((Container)inv, worldIn);
    }

    default public NonNullList<Ingredient> m_7527_() {
        return this.getRecipe().m_7527_();
    }

    default public boolean m_142505_() {
        return this.getRecipe().m_142505_();
    }

    default public boolean m_8004_(int p_194133_1_, int p_194133_2_) {
        return this.getRecipe().m_8004_(p_194133_1_, p_194133_2_);
    }

    default public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.getRecipe().m_8043_(registryAccess);
    }

    default public boolean isGoodForCrafting(CraftingContainer inv) {
        AbstractContainerMenu abstractContainerMenu;
        if (inv instanceof TransientCraftingContainer) {
            TransientCraftingContainer transientInv = (TransientCraftingContainer)inv;
            abstractContainerMenu = transientInv.f_286998_;
        } else {
            abstractContainerMenu = null;
        }
        Optional<Object> menu = Optional.ofNullable(abstractContainerMenu);
        if (menu.isEmpty() && ForgeHooks.getCraftingPlayer() == null) {
            return false;
        }
        menu.ifPresentOrElse(men -> RecipeStages.CONTAINER_LOGGER.info("Tried to craft a recipe in container: '{}'", (Object)men.getClass().getName()), () -> RecipeStages.CONTAINER_LOGGER.info("Tried to craft a recipe in an unknown menu from inventory: '{}'", (Object)inv.getClass().getName()));
        return Boolean.TRUE.equals(RecipeStagesUtil.callForSide(() -> () -> ClientStuff.handleClient(menu, this.getStage()), () -> () -> ServerStuff.handleServer(menu, this.getStage())));
    }

    default public RecipeType<?> m_6671_() {
        return this.getRecipe().m_6671_();
    }

    default public CraftingBookCategory m_245232_() {
        return this.getRecipe().m_245232_();
    }
}

