/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.recipestages.handlers.actions;

import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.item.MCItemStackMutable;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.impl.helper.AccessibleElementsProvider;
import com.blamejared.recipestages.handlers.actions.base.ActionClearBase;
import java.util.ArrayList;
import java.util.Map;
import javax.script.ScriptException;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import org.apache.logging.log4j.Logger;

public class ActionClearStageByOutput
extends ActionClearBase {
    private final IIngredient output;

    public ActionClearStageByOutput(IRecipeManager<CraftingRecipe> manager, IIngredient output) {
        super(manager);
        this.output = output;
    }

    public void apply() {
        ArrayList<Map.Entry<ResourceLocation, CraftingRecipe>> toChange = new ArrayList<Map.Entry<ResourceLocation, CraftingRecipe>>();
        for (Map.Entry entry2 : this.getManager().getRecipes().entrySet()) {
            ItemStack stack = (ItemStack)AccessibleElementsProvider.get().registryAccess(registryAccess -> ((CraftingRecipe)entry2.getValue()).m_8043_(registryAccess));
            if (!this.output.matches((IItemStack)new MCItemStackMutable(stack))) continue;
            toChange.add(entry2);
        }
        toChange.forEach(entry -> this.getManager().getRecipeList().remove((ResourceLocation)entry.getKey()));
        this.clearRecipes(toChange);
    }

    public String describe() {
        return "Clearing the stage of  \"" + BuiltInRegistries.f_256990_.m_7981_((Object)this.getManager().getRecipeType()) + "\" recipes with output: " + this.output + "\"";
    }

    public boolean validate(Logger logger) {
        if (this.output == null) {
            logger.warn("output cannot be null!", (Throwable)new ScriptException("output IItemStack cannot be null!"));
            return false;
        }
        return true;
    }
}

