/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.recipestages.handlers;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.action.recipe.ActionAddRecipe;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.MirrorAxis;
import com.blamejared.crafttweaker.api.recipe.fun.RecipeFunction1D;
import com.blamejared.crafttweaker.api.recipe.fun.RecipeFunction2D;
import com.blamejared.crafttweaker.api.recipe.manager.CraftingTableRecipeManager;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.recipe.type.CTShapedRecipe;
import com.blamejared.crafttweaker.api.recipe.type.CTShapelessRecipe;
import com.blamejared.recipestages.handlers.actions.ActionClearStageByName;
import com.blamejared.recipestages.handlers.actions.ActionClearStageByOutput;
import com.blamejared.recipestages.handlers.actions.ActionSetContainerStages;
import com.blamejared.recipestages.handlers.actions.ActionSetJEILabel;
import com.blamejared.recipestages.handlers.actions.ActionSetPackageStages;
import com.blamejared.recipestages.handlers.actions.ActionSetPrintContainers;
import com.blamejared.recipestages.handlers.actions.ActionSetStageByMod;
import com.blamejared.recipestages.handlers.actions.ActionSetStageByName;
import com.blamejared.recipestages.handlers.actions.ActionSetStageByOutput;
import com.blamejared.recipestages.handlers.actions.base.ActionSetStage;
import com.blamejared.recipestages.recipes.RecipeStage;
import com.blamejared.recipestages.recipes.ShapedRecipeStage;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="mods.recipestages.Recipes")
@ZenRegister
public class Recipes {
    @ZenCodeType.Method
    public static void showJEILabel(boolean showLabel) {
        CraftTweakerAPI.apply((IAction)new ActionSetJEILabel(showLabel));
    }

    @ZenCodeType.Method
    public static void setPrintContainers(boolean printContainers) {
        CraftTweakerAPI.apply((IAction)new ActionSetPrintContainers(printContainers));
    }

    @ZenCodeType.Method
    public static void setPackageStages(String packageName, String ... stages) {
        CraftTweakerAPI.apply((IAction)new ActionSetPackageStages(packageName, stages));
    }

    @ZenCodeType.Method
    public static void setContainerStages(String containerName, String ... stages) {
        CraftTweakerAPI.apply((IAction)new ActionSetContainerStages(containerName, stages));
    }

    @ZenCodeType.Method
    public static void addShaped(String stage, String recipeName, IItemStack output, IIngredient[][] ingredients, @ZenCodeType.Optional RecipeFunction2D recipeFunction) {
        recipeName = CraftingTableRecipeManager.INSTANCE.fixRecipeName(recipeName);
        CTShapedRecipe innerRecipe = new CTShapedRecipe(recipeName, output, ingredients, MirrorAxis.NONE, recipeFunction);
        ShapedRecipeStage recipe = new ShapedRecipeStage(new ResourceLocation("recipestages", recipeName), stage, (CraftingRecipe)innerRecipe);
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)CraftingTableRecipeManager.INSTANCE, (Recipe)recipe, "shaped"));
    }

    @ZenCodeType.Method
    public static void addShapedMirrored(String stage, String recipeName, MirrorAxis mirrorAxis, IItemStack output, IIngredient[][] ingredients, @ZenCodeType.Optional RecipeFunction2D recipeFunction) {
        recipeName = CraftingTableRecipeManager.INSTANCE.fixRecipeName(recipeName);
        CTShapedRecipe innerRecipe = new CTShapedRecipe(recipeName, output, ingredients, mirrorAxis, recipeFunction);
        ShapedRecipeStage recipe = new ShapedRecipeStage(new ResourceLocation("recipestages", recipeName), stage, (CraftingRecipe)innerRecipe);
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)CraftingTableRecipeManager.INSTANCE, (Recipe)recipe, "mirroring shaped"));
    }

    @ZenCodeType.Method
    public static void addShapeless(String stage, String recipeName, IItemStack output, IIngredient[] ingredients, @ZenCodeType.Optional RecipeFunction1D recipeFunction) {
        recipeName = CraftingTableRecipeManager.INSTANCE.fixRecipeName(recipeName);
        CTShapelessRecipe innerRecipe = new CTShapelessRecipe(recipeName, output, ingredients, recipeFunction);
        RecipeStage recipe = new RecipeStage(new ResourceLocation("recipestages", recipeName), stage, (CraftingRecipe)innerRecipe, true);
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)CraftingTableRecipeManager.INSTANCE, (Recipe)recipe, "shapeless"));
    }

    @ZenCodeType.Method
    public static void setRecipeStage(String stage, IIngredient output) {
        CraftTweakerAPI.apply((IAction)new ActionSetStageByOutput((IRecipeManager<CraftingRecipe>)CraftingTableRecipeManager.INSTANCE, stage, output));
    }

    @ZenCodeType.Method
    public static void setRecipeStage(String stage, ResourceLocation name) {
        CraftTweakerAPI.apply((IAction)new ActionSetStageByName((IRecipeManager<CraftingRecipe>)CraftingTableRecipeManager.INSTANCE, stage, name));
    }

    @ZenCodeType.Method
    public static void setRecipeStageByInput(String stage, IItemStack input) {
        CraftTweakerAPI.apply((IAction)new ActionSetStage((IRecipeManager<CraftingRecipe>)CraftingTableRecipeManager.INSTANCE, stage, craftingRecipe -> craftingRecipe.m_7527_().stream().anyMatch(ingredient -> ingredient.test(input.getInternal()))));
    }

    @ZenCodeType.Method
    public static void clearRecipeStage(IIngredient output) {
        CraftTweakerAPI.apply((IAction)new ActionClearStageByOutput((IRecipeManager<CraftingRecipe>)CraftingTableRecipeManager.INSTANCE, output));
    }

    @ZenCodeType.Method
    public static void clearRecipeStage(ResourceLocation name) {
        CraftTweakerAPI.apply((IAction)new ActionClearStageByName((IRecipeManager<CraftingRecipe>)CraftingTableRecipeManager.INSTANCE, name));
    }

    @ZenCodeType.Method
    public static void setRecipeStageByMod(String stage, String modid) {
        CraftTweakerAPI.apply((IAction)new ActionSetStageByMod((IRecipeManager<CraftingRecipe>)CraftingTableRecipeManager.INSTANCE, stage, modid));
    }
}

