/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.computercraft.implementation.peripherals;

import com.simibubi.create.compat.computercraft.implementation.peripherals.SyncedPeripheral;
import com.simibubi.create.content.redstone.nixieTube.NixieTubeBlock;
import com.simibubi.create.content.redstone.nixieTube.NixieTubeBlockEntity;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.LuaValues;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NixieTubePeripheral
extends SyncedPeripheral<NixieTubeBlockEntity> {
    public NixieTubePeripheral(NixieTubeBlockEntity blockEntity) {
        super(blockEntity);
    }

    @Override
    protected void onFirstAttach() {
        super.onFirstAttach();
        Level world = ((NixieTubeBlockEntity)this.blockEntity).m_58904_();
        if (world == null) {
            return;
        }
        NixieTubeBlock.walkNixies((LevelAccessor)world, ((NixieTubeBlockEntity)this.blockEntity).m_58899_(), true, (currentPos, rowPosition) -> {
            BlockEntity patt1251$temp = world.m_7702_(currentPos);
            if (patt1251$temp instanceof NixieTubeBlockEntity) {
                NixieTubeBlockEntity ntbe = (NixieTubeBlockEntity)patt1251$temp;
                ntbe.displayEmptyText((int)rowPosition);
            }
        });
    }

    @Override
    protected void onLastDetach() {
        super.onLastDetach();
        Level world = ((NixieTubeBlockEntity)this.blockEntity).m_58904_();
        if (world == null) {
            return;
        }
        BlockState state = world.m_8055_(((NixieTubeBlockEntity)this.blockEntity).m_58899_());
        if (!(state.m_60734_() instanceof NixieTubeBlock)) {
            return;
        }
        NixieTubeBlock.walkNixies((LevelAccessor)world, ((NixieTubeBlockEntity)this.blockEntity).m_58899_(), false, (currentPos, rowPosition) -> {
            BlockEntity patt2224$temp = world.m_7702_(currentPos);
            if (patt2224$temp instanceof NixieTubeBlockEntity) {
                NixieTubeBlockEntity ntbe = (NixieTubeBlockEntity)patt2224$temp;
                NixieTubeBlock.updateDisplayedRedstoneValue(ntbe, true);
            }
        });
    }

    @LuaFunction(mainThread=true)
    public void setText(IArguments arguments) throws LuaException {
        Level world = ((NixieTubeBlockEntity)this.blockEntity).m_58904_();
        if (world == null) {
            return;
        }
        ((NixieTubeBlockEntity)this.blockEntity).computerSignal = null;
        String tagElement = Component.Serializer.m_130703_((Component)Component.m_237113_((String)arguments.getString(0)));
        @Nullable String colour = arguments.optString(1, null);
        BlockState state = null;
        DyeColor dye = null;
        if (colour != null) {
            state = ((NixieTubeBlockEntity)this.blockEntity).m_58904_().m_8055_(((NixieTubeBlockEntity)this.blockEntity).m_58899_());
            dye = (DyeColor)LuaValues.checkEnum((int)1, DyeColor.class, (String)(colour.equals("grey") ? "gray" : colour));
        }
        this.changeTextNixie(tagElement, state, dye);
    }

    @LuaFunction(mainThread=true)
    public void setTextColour(String colour) throws LuaException {
        Level world = ((NixieTubeBlockEntity)this.blockEntity).m_58904_();
        if (world == null) {
            return;
        }
        BlockState state = ((NixieTubeBlockEntity)this.blockEntity).m_58904_().m_8055_(((NixieTubeBlockEntity)this.blockEntity).m_58899_());
        DyeColor dye = (DyeColor)LuaValues.checkEnum((int)1, DyeColor.class, (String)(colour.equals("grey") ? "gray" : colour));
        this.changeTextNixie(null, state, dye);
    }

    @LuaFunction(mainThread=true)
    public void setTextColor(String color) throws LuaException {
        this.setTextColour(color);
    }

    private void changeTextNixie(@Nullable String tagElement, @Nullable BlockState state, @Nullable DyeColor dye) {
        Level world = ((NixieTubeBlockEntity)this.blockEntity).m_58904_();
        if (world == null) {
            return;
        }
        NixieTubeBlock.walkNixies((LevelAccessor)world, ((NixieTubeBlockEntity)this.blockEntity).m_58899_(), true, (currentPos, rowPosition) -> {
            if (tagElement != null) {
                ((NixieTubeBlock)((NixieTubeBlockEntity)this.blockEntity).m_58900_().m_60734_()).withBlockEntityDo((BlockGetter)world, (BlockPos)currentPos, be -> be.displayCustomText(tagElement, (int)rowPosition));
            }
            if (state != null && dye != null) {
                world.m_46597_(currentPos, NixieTubeBlock.withColor(state, dye));
            }
        });
    }

    @LuaFunction(mainThread=true)
    public void setSignal(IArguments arguments) throws LuaException {
        if (arguments.optTable(0).isPresent()) {
            this.setSignal(this.signal().first, arguments.getTable(0));
        }
        if (arguments.optTable(1).isPresent()) {
            this.setSignal(this.signal().second, arguments.getTable(1));
        }
    }

    private void setSignal(NixieTubeBlockEntity.ComputerSignal.TubeDisplay display, @NotNull Map<?, ?> attrs) throws LuaException {
        if (attrs.containsKey("r")) {
            display.r = this.constrainByte("r", 0, 255, attrs.get("r"));
        }
        if (attrs.containsKey("g")) {
            display.g = this.constrainByte("g", 0, 255, attrs.get("g"));
        }
        if (attrs.containsKey("b")) {
            display.b = this.constrainByte("r", 0, 255, attrs.get("b"));
        }
        if (attrs.containsKey("glowWidth")) {
            display.glowWidth = this.constrainByte("glowWidth", 1, 4, attrs.get("glowWidth"));
        }
        if (attrs.containsKey("glowHeight")) {
            display.glowHeight = this.constrainByte("glowHeight", 1, 4, attrs.get("glowHeight"));
        }
        if (attrs.containsKey("blinkPeriod")) {
            display.blinkPeriod = this.constrainByte("blinkPeriod", 0, 255, attrs.get("blinkPeriod"));
        }
        if (attrs.containsKey("blinkOffTime")) {
            display.blinkOffTime = this.constrainByte("blinkOffTime", 0, 255, attrs.get("blinkOffTime"));
        }
        if (display.r == 0 && display.g == 0 && display.b == 0) {
            display.blinkPeriod = 0;
            display.blinkOffTime = 0;
        } else if (display.blinkPeriod == 0) {
            display.blinkPeriod = 1;
            display.blinkOffTime = 0;
        }
        ((NixieTubeBlockEntity)this.blockEntity).notifyUpdate();
    }

    private byte constrainByte(String name, int min, int max, Object rawValue) throws LuaException {
        if (!(rawValue instanceof Number)) {
            throw LuaValues.badField((String)name, (String)"number", (String)LuaValues.getType((Object)rawValue));
        }
        int value = ((Number)rawValue).intValue();
        if (value < min || value > max) {
            throw new LuaException("field " + name + " must be in range " + min + "-" + max);
        }
        return (byte)value;
    }

    private NixieTubeBlockEntity.ComputerSignal signal() {
        if (((NixieTubeBlockEntity)this.blockEntity).computerSignal == null) {
            ((NixieTubeBlockEntity)this.blockEntity).computerSignal = new NixieTubeBlockEntity.ComputerSignal();
        }
        return ((NixieTubeBlockEntity)this.blockEntity).computerSignal;
    }

    @NotNull
    public String getType() {
        return "Create_NixieTube";
    }
}

