/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.molds;

import com.google.gson.JsonObject;
import com.jesz.createdieselgenerators.CDGRecipes;
import com.jesz.createdieselgenerators.content.molds.MoldItem;
import com.jesz.createdieselgenerators.content.molds.MoldType;
import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.content.processing.basin.BasinRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;

public class CastingRecipe
extends ProcessingRecipe<Container> {
    public MoldType moldType;

    public CastingRecipe(ProcessingRecipeBuilder.ProcessingRecipeParams params) {
        super((IRecipeTypeInfo)CDGRecipes.CASTING, params);
    }

    protected int getMaxInputCount() {
        return 0;
    }

    protected int getMaxFluidInputCount() {
        return 1;
    }

    protected int getMaxFluidOutputCount() {
        return 0;
    }

    protected int getMaxOutputCount() {
        return 1;
    }

    public boolean m_5818_(Container container, Level level) {
        return false;
    }

    public boolean matches(BasinBlockEntity basin, FluidStack fluidStack) {
        if (this.moldType == null) {
            return false;
        }
        if (this.getFluidIngredients().size() != 1) {
            return false;
        }
        IItemHandler availableItems = (IItemHandler)basin.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null);
        if (availableItems == null) {
            return false;
        }
        MoldType moldInBasin = null;
        for (int i = 0; i < availableItems.getSlots(); ++i) {
            ItemStack stack = availableItems.getStackInSlot(i);
            if (stack == null || !(stack.m_41720_() instanceof MoldItem) || MoldItem.getMold(stack) != this.moldType) continue;
            moldInBasin = MoldItem.getMold(stack);
        }
        if (moldInBasin == null) {
            return false;
        }
        if (((FluidIngredient)this.getFluidIngredients().get(0)).test(fluidStack)) {
            return BasinRecipe.match((BasinBlockEntity)basin, (Recipe)this);
        }
        return false;
    }

    public void readAdditional(JsonObject json) {
        super.readAdditional(json);
        this.moldType = MoldType.findById(new ResourceLocation(json.get("mold").getAsString()));
    }

    public void readAdditional(FriendlyByteBuf buffer) {
        super.readAdditional(buffer);
        this.moldType = MoldType.findById(new ResourceLocation(buffer.m_130277_()));
    }

    public void writeAdditional(JsonObject json) {
        super.writeAdditional(json);
        json.addProperty("mold", this.moldType.getId().toString());
    }

    public void writeAdditional(FriendlyByteBuf buffer) {
        super.writeAdditional(buffer);
        buffer.m_130070_(this.moldType.getId().toString());
    }

    public int execute(BasinBlockEntity basin, boolean simulate) {
        IItemHandler availableItems = (IItemHandler)basin.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse(null);
        if (availableItems == null) {
            return 0;
        }
        MoldType moldInBasin = null;
        for (int i = 0; i < availableItems.getSlots(); ++i) {
            ItemStack stack = availableItems.getStackInSlot(i);
            if (!(stack.m_41720_() instanceof MoldItem) || MoldItem.getMold(stack) != this.moldType) continue;
            moldInBasin = MoldItem.getMold(stack);
        }
        if (moldInBasin == null) {
            return 0;
        }
        ArrayList recipeOutputItems = new ArrayList();
        if (!simulate) {
            recipeOutputItems.addAll(this.rollResults());
        }
        if (!basin.acceptOutputs(recipeOutputItems, List.of(), false)) {
            return 0;
        }
        return ((FluidIngredient)this.getFluidIngredients().get(0)).getRequiredAmount();
    }
}

