/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.world;

import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.world.WorldBounds;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.LevelChunk;

public class ChunkBounds
extends WorldBounds {
    public static final int WIDTH = 16;
    public static final int HALF_WIDTH = 8;
    public static final int SQUARE = 256;

    protected ChunkBounds(IntBounds x, IntBounds y, IntBounds z) {
        super(x, y, z);
    }

    public static ChunkBounds from(ChunkPos pos, IntBounds y) {
        return new ChunkBounds(new IntBounds(pos.m_45604_(), pos.m_45608_()), y, new IntBounds(pos.m_45605_(), pos.m_45609_()));
    }

    public static ChunkBounds from(LevelHeightAccessor level, ChunkPos pos) {
        return ChunkBounds.from(pos, WorldBounds.getHeightBounds(level));
    }

    public static ChunkBounds from(LevelChunk chunk) {
        return ChunkBounds.from((LevelHeightAccessor)chunk.m_62953_(), chunk.m_7697_());
    }

    public static ChunkBounds from(LevelChunk chunk, IntBounds y) {
        return ChunkBounds.from(chunk.m_7697_(), y);
    }

    public int getCapacity() {
        return 256 * this.getHeight();
    }
}

