/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.intern.init.network;

import info.u_team.u_team_core.api.network.NetworkContext;
import info.u_team.u_team_core.menutype.UMenuType;
import info.u_team.u_team_core.util.CastUtil;
import info.u_team.u_team_core.util.RegistryUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;

public record OpenMenuScreenMessage(int containerId, MenuType<?> type, Component title, FriendlyByteBuf extraData) {
    private static final Registry<MenuType<?>> REGISTRY = RegistryUtil.getBuiltInRegistry(Registries.f_256798_);

    public static void encode(OpenMenuScreenMessage message, FriendlyByteBuf buffer) {
        buffer.m_130130_(message.containerId);
        buffer.m_236818_(REGISTRY, message.type);
        buffer.m_130083_(message.title);
        buffer.m_130130_(message.extraData.readableBytes());
        buffer.writeBytes((ByteBuf)message.extraData);
        message.extraData.release();
    }

    public static OpenMenuScreenMessage decode(FriendlyByteBuf buffer) {
        int containerId = buffer.m_130242_();
        MenuType type = (MenuType)buffer.m_236816_(REGISTRY);
        Component title = buffer.m_130238_();
        FriendlyByteBuf extraData = new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])buffer.m_130052_()));
        return new OpenMenuScreenMessage(containerId, type, title, extraData);
    }

    public static class Handler {
        public static void handle(OpenMenuScreenMessage message, NetworkContext context) {
            context.executeOnMainThread(() -> {
                Minecraft minecraft = Minecraft.m_91087_();
                Inventory playerInventory = minecraft.f_91074_.m_150109_();
                int containerId = message.containerId;
                MenuType<?> type = message.type;
                Component title = message.title;
                FriendlyByteBuf extraData = message.extraData;
                try {
                    Object menu;
                    if (message.type == null) {
                        MenuScreens.f_96195_.warn("Trying to open invalid screen with name: {}", (Object)title.getString());
                        return;
                    }
                    MenuScreens.ScreenConstructor constructor = (MenuScreens.ScreenConstructor)CastUtil.uncheckedCast(MenuScreens.m_96199_(type));
                    if (constructor == null) {
                        MenuScreens.f_96195_.warn("Failed to create screen for menu type: {}", (Object)REGISTRY.m_7981_(type));
                        return;
                    }
                    if (type instanceof UMenuType) {
                        UMenuType uType = (UMenuType)type;
                        menu = uType.createWithExtraData(containerId, playerInventory, extraData);
                    } else {
                        menu = type.m_39985_(containerId, playerInventory);
                    }
                    Screen screen = constructor.m_96214_(menu, playerInventory, title);
                    if (!(screen instanceof MenuAccess)) {
                        MenuScreens.f_96195_.warn("Trying to open invalid screen that does not implement MenuAccess with name: {}", (Object)title.getString());
                        return;
                    }
                    MenuAccess menuAccess = (MenuAccess)screen;
                    minecraft.f_91074_.f_36096_ = menuAccess.m_6262_();
                    minecraft.m_91152_(screen);
                }
                finally {
                    extraData.release();
                }
            });
        }
    }
}

