/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.api.dye;

import info.u_team.u_team_core.api.dye.DyeableItemsRegistry;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public interface DyeableItem {
    public static final String TAG_DISPLAY = "display";
    public static final String TAG_COLOR = "color";
    public static final int DEFAULT_COLOR = 10511680;

    default public <T extends Item> void addColoredItem(T item) {
        DyeableItemsRegistry.addItem(item);
    }

    default public boolean hasColor(ItemStack stack) {
        CompoundTag compound = stack.m_41737_(TAG_DISPLAY);
        return compound != null && compound.m_128425_(TAG_COLOR, 99);
    }

    default public int getColor(ItemStack stack) {
        CompoundTag compound = stack.m_41737_(TAG_DISPLAY);
        return compound != null && compound.m_128425_(TAG_COLOR, 99) ? compound.m_128451_(TAG_COLOR) : this.getDefaultColor();
    }

    default public void removeColor(ItemStack stack) {
        CompoundTag compound = stack.m_41737_(TAG_DISPLAY);
        if (compound != null && compound.m_128441_(TAG_COLOR)) {
            compound.m_128473_(TAG_COLOR);
        }
    }

    default public void setColor(ItemStack stack, int color) {
        stack.m_41698_(TAG_DISPLAY).m_128405_(TAG_COLOR, color);
    }

    default public int getDefaultColor() {
        return 10511680;
    }

    public static ItemStack colorStack(ItemStack stack, List<DyeColor> dyeList) {
        if (!(stack.m_41720_() instanceof DyeableItem)) {
            return ItemStack.f_41583_;
        }
        DyeableItem dyeableItem = (DyeableItem)stack.m_41720_();
        ItemStack dyedStack = stack.m_41777_();
        dyedStack.m_41764_(1);
        int[] rbgItemSum = new int[3];
        int mostIntenseChannelSum = 0;
        int colorItemSum = 0;
        if (dyeableItem.hasColor(dyedStack)) {
            int color = dyeableItem.getColor(dyedStack);
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            mostIntenseChannelSum = (int)((float)mostIntenseChannelSum + Math.max(red, Math.max(green, blue)) * 255.0f);
            rbgItemSum[0] = (int)((float)rbgItemSum[0] + red * 255.0f);
            rbgItemSum[1] = (int)((float)rbgItemSum[1] + green * 255.0f);
            rbgItemSum[2] = (int)((float)rbgItemSum[2] + blue * 255.0f);
            ++colorItemSum;
        }
        for (DyeColor dye : dyeList) {
            float[] colorComponents = dye.m_41068_();
            int red = (int)(colorComponents[0] * 255.0f);
            int green = (int)(colorComponents[1] * 255.0f);
            int blue = (int)(colorComponents[2] * 255.0f);
            mostIntenseChannelSum += Math.max(red, Math.max(green, blue));
            rbgItemSum[0] = rbgItemSum[0] + red;
            rbgItemSum[1] = rbgItemSum[1] + green;
            rbgItemSum[2] = rbgItemSum[2] + blue;
            ++colorItemSum;
        }
        int red = rbgItemSum[0] / colorItemSum;
        int green = rbgItemSum[1] / colorItemSum;
        int blue = rbgItemSum[2] / colorItemSum;
        float averageChannel = (float)mostIntenseChannelSum / (float)colorItemSum;
        float mostIntenseChannel = Math.max(red, Math.max(green, blue));
        red = (int)((float)red * averageChannel / mostIntenseChannel);
        green = (int)((float)green * averageChannel / mostIntenseChannel);
        blue = (int)((float)blue * averageChannel / mostIntenseChannel);
        int finalColor = (red << 8) + green;
        finalColor = (finalColor << 8) + blue;
        dyeableItem.setColor(dyedStack, finalColor);
        return dyedStack;
    }

    public static ItemStack colorStackDyeItem(ItemStack stack, List<DyeItem> dyeItemList) {
        return DyeableItem.colorStack(stack, dyeItemList.stream().map(dyeItem -> dyeItem.m_41089_()).collect(Collectors.toList()));
    }
}

