/*
 * Decompiled with CFR 0.152.
 */
package com.temporal.api.core.registry.factory.common;

import com.temporal.api.core.engine.event.registry.EnginedRegisterFactory;
import com.temporal.api.core.engine.io.context.InjectionContext;
import com.temporal.api.core.registry.factory.common.TypedFactory;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class PaintingFactory
implements TypedFactory<PaintingVariant> {
    public static final DeferredRegister<PaintingVariant> PAINTING_VARIANTS = EnginedRegisterFactory.create(Registries.f_256836_);

    public RegistryObject<PaintingVariant> create16x16(String name) {
        return this.create(name, 16, 16);
    }

    public RegistryObject<PaintingVariant> create16x32(String name) {
        return this.create(name, 16, 32);
    }

    public RegistryObject<PaintingVariant> create32x16(String name) {
        return this.create(name, 32, 16);
    }

    public RegistryObject<PaintingVariant> create32x32(String name) {
        return this.create(name, 32, 32);
    }

    public RegistryObject<PaintingVariant> create(String name, int width, int height) {
        return this.create(name, () -> new PaintingVariant(width, height));
    }

    @Override
    public RegistryObject<PaintingVariant> create(String name, Supplier<PaintingVariant> paintingVariantSupplier) {
        return PAINTING_VARIANTS.register(name, paintingVariantSupplier);
    }

    @Override
    public RegistryObject<? extends PaintingVariant> createTyped(String name, Supplier<? extends PaintingVariant> tSupplier) {
        return PAINTING_VARIANTS.register(name, tSupplier);
    }

    @Override
    public void register() {
        PAINTING_VARIANTS.register(InjectionContext.getInstance().getObject(IEventBus.class));
    }
}

