/*
 * Decompiled with CFR 0.152.
 */
package com.temporal.api.core.engine.io.context;

import com.temporal.api.core.engine.io.context.Context;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InjectionContext
implements Context {
    private static volatile InjectionContext instance;
    private final Map<Class<?>, Object> objects = new HashMap();

    private InjectionContext() {
    }

    @Override
    public <T> T getObject(Class<? extends T> key) {
        return key.cast(this.objects.get(key));
    }

    @Override
    public <T> List<? extends T> getObjects(Class<T> commonInterface) {
        return this.objects.values().stream().filter(commonInterface::isInstance).map(commonInterface::cast).toList();
    }

    @Override
    public List<?> getAllObjects() {
        return this.objects.values().stream().toList();
    }

    @Override
    public <T> void putObject(Class<? extends T> key) {
        try {
            Constructor<T> constructor = key.getDeclaredConstructor(new Class[0]);
            T value = constructor.newInstance(new Object[0]);
            this.putObject(key, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> void putObject(T value) {
        this.putObject(value.getClass(), value);
    }

    @Override
    public <T> void putObject(Class<? extends T> key, T value) {
        this.objects.put(key, value);
    }

    public static <T> T getFromInstance(Class<? extends T> key) {
        return InjectionContext.getInstance().getObject(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static InjectionContext getInstance() {
        if (instance != null) return instance;
        Class<InjectionContext> clazz = InjectionContext.class;
        synchronized (InjectionContext.class) {
            if (instance != null) return instance;
            instance = new InjectionContext();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }
}

