/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.registry;

import dev.hexnowloading.dungeonnowloading.item.DNLArmorMaterial;
import dev.hexnowloading.dungeonnowloading.item.GreatExperienceBottleItem;
import dev.hexnowloading.dungeonnowloading.item.LifeStealerItem;
import dev.hexnowloading.dungeonnowloading.item.ScepterOfSealedChaosItem;
import dev.hexnowloading.dungeonnowloading.item.SkullOfChaosItem;
import dev.hexnowloading.dungeonnowloading.item.SpawnerArmorItem;
import dev.hexnowloading.dungeonnowloading.item.SpawnerSword;
import dev.hexnowloading.dungeonnowloading.platform.Services;
import dev.hexnowloading.dungeonnowloading.registration.RegistrationProvider;
import dev.hexnowloading.dungeonnowloading.registration.RegistryObject;
import dev.hexnowloading.dungeonnowloading.registry.DNLBlocks;
import dev.hexnowloading.dungeonnowloading.registry.DNLEntityTypes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.block.Block;

public class DNLItems {
    public static final RegistrationProvider<Item> ITEMS = RegistrationProvider.get(Registries.f_256913_, "dungeonnowloading");
    private static final HashMap<ResourceKey<CreativeModeTab>, ArrayList<ResourceLocation>> ITEM_TABS = new HashMap();
    public static final RegistryObject<Item> SPAWNER_FRAGMENT = DNLItems.register("spawner_fragment", () -> new Item(new Item.Properties()), new ResourceKey[0]);
    public static final RegistryObject<Item> SPAWNER_FRAME = DNLItems.register("spawner_frame", () -> new Item(new Item.Properties().m_41497_(Rarity.UNCOMMON)), new ResourceKey[0]);
    public static final RegistryObject<Item> SPAWNER_BLADE = DNLItems.register("spawner_blade", () -> new Item(new Item.Properties().m_41497_(Rarity.UNCOMMON)), new ResourceKey[0]);
    public static final RegistryObject<Item> SOUL_CLOTH = DNLItems.register("soul_cloth", () -> new Item(new Item.Properties()), new ResourceKey[0]);
    public static final RegistryObject<Item> SOUL_SILK = DNLItems.register("soul_silk", () -> new Item(new Item.Properties().m_41497_(Rarity.UNCOMMON)), new ResourceKey[0]);
    public static final RegistryObject<Item> CHAOTIC_HEXAHEDRON = DNLItems.register("chaotic_hexahedron", () -> new Item(new Item.Properties().m_41497_(Rarity.RARE)), new ResourceKey[0]);
    public static final RegistryObject<Item> WIND_JADE = DNLItems.register("wind_jade", () -> new Item(new Item.Properties()), new ResourceKey[0]);
    public static final RegistryObject<Item> EYE_OF_THE_STORM = DNLItems.register("eye_of_the_storm", () -> new Item(new Item.Properties()), new ResourceKey[0]);
    public static final RegistryObject<Item> GREAT_EXPERIENCE_BOTTLE = DNLItems.register("great_experience_bottle", () -> new GreatExperienceBottleItem(new Item.Properties().m_41497_(Rarity.RARE), 100), new ResourceKey[0]);
    public static final RegistryObject<Item> SCEPTER_OF_SEALED_CHAOS = DNLItems.register("scepter_of_sealed_chaos", () -> new ScepterOfSealedChaosItem(new Item.Properties().m_41497_(Rarity.RARE).m_41503_(100)), new ResourceKey[0]);
    public static final RegistryObject<Item> LIFE_STEALER = DNLItems.register("life_stealer", () -> new LifeStealerItem((Tier)Tiers.DIAMOND, 3, -2.8f, new Item.Properties().m_41497_(Rarity.COMMON).m_41503_(1562)), new ResourceKey[0]);
    public static final RegistryObject<Item> SPAWNER_SWORD = DNLItems.register("spawner_sword", () -> new SpawnerSword((Tier)Tiers.DIAMOND, 3, -2.4f, new Item.Properties().m_41497_(Rarity.COMMON).m_41503_(1562)), new ResourceKey[0]);
    public static final RegistryObject<Item> SPAWNER_HELMET = DNLItems.register("spawner_helmet", () -> new SpawnerArmorItem(DNLArmorMaterial.SPAWNER, ArmorItem.Type.HELMET), new ResourceKey[0]);
    public static final RegistryObject<Item> SPAWNER_CHESTPLATE = DNLItems.register("spawner_chestplate", () -> new SpawnerArmorItem(DNLArmorMaterial.SPAWNER, ArmorItem.Type.CHESTPLATE), new ResourceKey[0]);
    public static final RegistryObject<Item> SPAWNER_LEGGINGS = DNLItems.register("spawner_leggings", () -> new SpawnerArmorItem(DNLArmorMaterial.SPAWNER, ArmorItem.Type.LEGGINGS), new ResourceKey[0]);
    public static final RegistryObject<Item> SPAWNER_BOOTS = DNLItems.register("spawner_boots", () -> new SpawnerArmorItem(DNLArmorMaterial.SPAWNER, ArmorItem.Type.BOOTS), new ResourceKey[0]);
    public static final RegistryObject<Item> SKULL_OF_CHAOS = DNLItems.register("skull_of_chaos", () -> new SkullOfChaosItem(new Item.Properties().m_41497_(Rarity.EPIC).m_41503_(10)), new ResourceKey[0]);
    public static final RegistryObject<Item> DUNGEON_WALL_TORCH = DNLItems.register("dungeon_wall_torch", () -> new BlockItem((Block)DNLBlocks.DUNGEON_WALL_TORCH.get(), new Item.Properties()), new ResourceKey[0]);
    public static final RegistryObject<Item> BOOK_PILE = DNLItems.register("book_pile", () -> new BlockItem((Block)DNLBlocks.BOOK_PILE.get(), new Item.Properties()), new ResourceKey[0]);
    public static final RegistryObject<Item> EXPLOSIVE_BARREL = DNLItems.register("explosive_barrel", () -> new BlockItem((Block)DNLBlocks.EXPLOSIVE_BARREL.get(), new Item.Properties()), new ResourceKey[0]);
    public static final RegistryObject<Item> COBBLESTONE_PEBBLE = DNLItems.register("cobblestone_pebble", () -> new BlockItem((Block)DNLBlocks.COBBLESTONE_PEBBLES.get(), new Item.Properties()), new ResourceKey[0]);
    public static final RegistryObject<Item> MOSSY_COBBLESTONE_PEBBLE = DNLItems.register("mossy_cobblestone_pebble", () -> new BlockItem((Block)DNLBlocks.MOSSY_COBBLESTONE_PEBBLES.get(), new Item.Properties()), new ResourceKey[0]);
    public static final RegistryObject<Item> IRON_INGOT_PILE = DNLItems.register("iron_ingot_pile", () -> new BlockItem((Block)DNLBlocks.IRON_INGOT_PILE.get(), new Item.Properties()), new ResourceKey[0]);
    public static final RegistryObject<Item> GOLD_INGOT_PILE = DNLItems.register("gold_ingot_pile", () -> new BlockItem((Block)DNLBlocks.GOLD_INGOT_PILE.get(), new Item.Properties()), new ResourceKey[0]);
    public static final RegistryObject<Item> WOODEN_WALL_RACK = DNLItems.register("wooden_wall_rack", () -> new BlockItem((Block)DNLBlocks.WOODEN_WALL_RACK.get(), new Item.Properties()), new ResourceKey[0]);
    public static final RegistryObject<Item> WOODEN_WALL_PLATFORM = DNLItems.register("wooden_wall_platform", () -> new BlockItem((Block)DNLBlocks.WOODEN_WALL_PLATFORM.get(), new Item.Properties()), new ResourceKey[0]);
    public static final RegistryObject<Item> SPIKES = DNLItems.register("spikes", () -> new BlockItem((Block)DNLBlocks.SPIKES.get(), new Item.Properties()), new ResourceKey[0]);
    public static final RegistryObject<Item> CHAOS_SPAWNER_EDGE = DNLItems.register("chaos_spawner_edge", () -> new BlockItem((Block)DNLBlocks.CHAOS_SPAWNER_EDGE.get(), new Item.Properties()), new ResourceKey[0]);
    public static final RegistryObject<Item> CHAOS_SPAWNER_DIAMOND_EDGE = DNLItems.register("chaos_spawner_diamond_edge", () -> new BlockItem((Block)DNLBlocks.CHAOS_SPAWNER_DIAMOND_EDGE.get(), new Item.Properties()), new ResourceKey[0]);
    public static final RegistryObject<Item> CHAOS_SPAWNER_DIAMOND_VERTEX = DNLItems.register("chaos_spawner_diamond_vertex", () -> new BlockItem((Block)DNLBlocks.CHAOS_SPAWNER_DIAMOND_VERTEX.get(), new Item.Properties()), new ResourceKey[0]);
    public static final RegistryObject<Item> CHAOS_SPAWNER_BROKEN_EDGE = DNLItems.register("chaos_spawner_broken_edge", () -> new BlockItem((Block)DNLBlocks.CHAOS_SPAWNER_BROKEN_EDGE.get(), new Item.Properties()), new ResourceKey[0]);
    public static final RegistryObject<Item> CHAOS_SPAWNER_BROKEN_DIAMOND_EDGE = DNLItems.register("chaos_spawner_broken_diamond_edge", () -> new BlockItem((Block)DNLBlocks.CHAOS_SPAWNER_BROKEN_DIAMOND_EDGE.get(), new Item.Properties()), new ResourceKey[0]);
    public static final RegistryObject<Item> CHAOS_SPAWNER_BROKEN_DIAMOND_VERTEX = DNLItems.register("chaos_spawner_broken_diamond_vertex", () -> new BlockItem((Block)DNLBlocks.CHAOS_SPAWNER_BROKEN_DIAMOND_VERTEX.get(), new Item.Properties()), new ResourceKey[0]);
    public static final RegistryObject<Item> CHAOS_SPAWNER_BARRIER_CENTER = DNLItems.register("chaos_spawner_barrier_center", () -> new BlockItem((Block)DNLBlocks.CHAOS_SPAWNER_BARRIER_CENTER.get(), new Item.Properties()), new ResourceKey[0]);
    public static final RegistryObject<Item> CHAOS_SPAWNER_BARRIER_EDGE = DNLItems.register("chaos_spawner_barrier_edge", () -> new BlockItem((Block)DNLBlocks.CHAOS_SPAWNER_BARRIER_EDGE.get(), new Item.Properties()), new ResourceKey[0]);
    public static final RegistryObject<Item> CHAOS_SPAWNER_BARRIER_VERTEX = DNLItems.register("chaos_spawner_barrier_vertex", () -> new BlockItem((Block)DNLBlocks.CHAOS_SPAWNER_BARRIER_VERTEX.get(), new Item.Properties()), new ResourceKey[0]);
    public static final RegistryObject<Item> DNL_LOGO = DNLItems.register("dnl_logo", () -> new Item(new Item.Properties().m_41497_(Rarity.EPIC)), new ResourceKey[0]);
    public static final RegistryObject<Item> LABYRINTH_TROPHY = DNLItems.register("labyrinth_trophy", () -> new BlockItem((Block)DNLBlocks.LABYRINTH_TROPHY.get(), new Item.Properties().m_41497_(Rarity.RARE)), new ResourceKey[0]);
    public static final RegistryObject<Item> CHAOS_SPAWNER_SPAWNEGG = DNLItems.register("spawn_egg_chaos_spawner", Services.ITEM.makeSpawnEgg(DNLEntityTypes.CHAOS_SPAWNER::get, 1584185, 10141142, new Item.Properties().m_41497_(Rarity.EPIC)), new ResourceKey[0]);
    public static final RegistryObject<Item> HOLLOW_SPAWNEGG = DNLItems.register("spawn_egg_hollow", Services.ITEM.makeSpawnEgg(DNLEntityTypes.HOLLOW::get, 5457242, 16111072, new Item.Properties().m_41497_(Rarity.COMMON)), new ResourceKey[0]);
    public static final RegistryObject<Item> SPAWNER_CARRIER_SPAWNEGG = DNLItems.register("spawn_egg_spawner_carrier", Services.ITEM.makeSpawnEgg(DNLEntityTypes.SPAWNER_CARRIER::get, 6974824, 6343155, new Item.Properties().m_41497_(Rarity.COMMON)), new ResourceKey[0]);
    public static final RegistryObject<Item> SEALED_CHAOS_SPAWNEGG = DNLItems.register("spawn_egg_sealed_chaos", Services.ITEM.makeSpawnEgg(DNLEntityTypes.SEALED_CHAOS::get, 6229376, 14007511, new Item.Properties().m_41497_(Rarity.COMMON)), new ResourceKey[0]);
    public static final RegistryObject<Item> WHIMPER_SPAWNEGG = DNLItems.register("spawn_egg_whimper", Services.ITEM.makeSpawnEgg(DNLEntityTypes.WHIMPER::get, 6354426, 12514810, new Item.Properties().m_41497_(Rarity.COMMON)), new ResourceKey[0]);

    @SafeVarargs
    private static RegistryObject<Item> register(String name, Supplier<? extends Item> supplier, ResourceKey<CreativeModeTab> ... tabs) {
        for (ResourceKey<CreativeModeTab> tab : tabs) {
            ArrayList list = ITEM_TABS.computeIfAbsent(tab, empty -> new ArrayList());
            list.add(new ResourceLocation("dungeonnowloading", name));
        }
        return ITEMS.register(name, supplier);
    }

    public static Map<ResourceKey<CreativeModeTab>, ArrayList<ResourceLocation>> getItemTabs() {
        return ITEM_TABS;
    }

    public static List<ItemStack> getItemsForTab(ResourceKey<CreativeModeTab> tab) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        DNLItems.getItemTabs().forEach((itemTab, itemLikes) -> {
            if (tab == itemTab) {
                itemLikes.forEach(itemLike -> items.add(Objects.requireNonNull((Item)BuiltInRegistries.f_257033_.m_7745_(itemLike)).m_7968_()));
            }
        });
        return items;
    }

    public static void init() {
    }
}

