/*
 * Decompiled with CFR 0.152.
 */
package dev.hexnowloading.dungeonnowloading.entity.boss;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.logging.LogUtils;
import dev.hexnowloading.dungeonnowloading.block.ChaosSpawnerBarrierCenterBlock;
import dev.hexnowloading.dungeonnowloading.block.ChaosSpawnerBarrierEdgeBlock;
import dev.hexnowloading.dungeonnowloading.block.ChaosSpawnerBarrierVertexBlock;
import dev.hexnowloading.dungeonnowloading.block.ChaosSpawnerEdgeBlock;
import dev.hexnowloading.dungeonnowloading.block.ChaosSpawnerVertexBlock;
import dev.hexnowloading.dungeonnowloading.config.BossConfig;
import dev.hexnowloading.dungeonnowloading.entity.ai.ChaosSpawnerLookAtPlayerGoal;
import dev.hexnowloading.dungeonnowloading.entity.ai.ChaosSpawnerPlayerTargetGoal;
import dev.hexnowloading.dungeonnowloading.entity.ai.ChaosSpawnerPushGoal;
import dev.hexnowloading.dungeonnowloading.entity.ai.ChaosSpawnerRandomLookAroundGoal;
import dev.hexnowloading.dungeonnowloading.entity.ai.ChaosSpawnerResetGoal;
import dev.hexnowloading.dungeonnowloading.entity.ai.ChaosSpawnerShootGhostBulletGoal;
import dev.hexnowloading.dungeonnowloading.entity.ai.ChaosSpawnerSummonMobGoal;
import dev.hexnowloading.dungeonnowloading.entity.ai.EntityBodyRotationControl;
import dev.hexnowloading.dungeonnowloading.entity.misc.SpecialItemEntity;
import dev.hexnowloading.dungeonnowloading.registry.DNLBlocks;
import dev.hexnowloading.dungeonnowloading.registry.DNLSounds;
import dev.hexnowloading.dungeonnowloading.util.EntityScale;
import dev.hexnowloading.dungeonnowloading.util.EntityStates;
import dev.hexnowloading.dungeonnowloading.util.PlayerSupporterEntity;
import dev.hexnowloading.dungeonnowloading.util.UniqueDeathAnimationEntity;
import dev.hexnowloading.dungeonnowloading.util.WeightedRandomBag;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class ChaosSpawnerEntity
extends Monster
implements Enemy,
UniqueDeathAnimationEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final EntityDataAccessor<Boolean> DATA_FLAGS_ID = SynchedEntityData.m_135353_(ChaosSpawnerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<State> DATA_STATE;
    private static final EntityDataAccessor<BlockPos> SPAWN_POINT;
    private static final EntityDataAccessor<Integer> PHASE;
    private static final EntityDataAccessor<Integer> AWAKENING_TICKS;
    private static final EntityDataAccessor<Integer> ATTACK_TICK;
    private static final EntityDataAccessor<Integer> ACTIVE_RANGE;
    private static final EntityDataAccessor<Integer> PLAYER_COUNT;
    private static final EntityDataAccessor<Integer> BARRIER_NORTH_TICK;
    private static final EntityDataAccessor<Integer> BARRIER_EAST_TICK;
    private static final EntityDataAccessor<Integer> BARRIER_SOUTH_TICK;
    private static final EntityDataAccessor<Integer> BARRIER_WEST_TICK;
    private static final EntityDataAccessor<Integer> BARRIER_UP_TICK;
    private static final EntityDataAccessor<Integer> BARRIER_DOWN_TICK;
    private static final EntityDataAccessor<Optional<UUID>> PLAYER_UUID;
    private static final byte TRIGGER_SLEEP_ANIMATION_BYTE = 70;
    private static final byte TRIGGER_WAKE_UP_ANIMATION_BYTE = 71;
    private static final byte TRIGGER_SMASH_ATTACK_ANIMATION_BYTE = 72;
    private static final byte TRIGGER_RANGE_ATTACK_ANIMATION_BYTE = 73;
    private static final byte TRIGGER_RANGE_BURST_ATTACK_ANIMATION_BYTE = 74;
    private static final byte TRIGGER_SUMMON_ANIMATION_BYTE = 75;
    private static final byte TRIGGER_DEATH_ANIMATION_BYTE = 76;
    private static final byte TRIGGER_ANIMATION_STOP_BYTE = 77;
    protected int attackTickCount;
    private int contactAttackTickCount;
    private int deathAnimationTickCount;
    private int barrierCheckTickCount;
    private Set<UUID> playerUUIDs;
    private UUID currentPlayerUUID;
    private List<Player> pushTargets;
    public final AnimationState awakeningAnimationState = new AnimationState();
    public final AnimationState sleepingAnimationState = new AnimationState();
    public final AnimationState smashAttackAnimationState = new AnimationState();
    public final AnimationState rangeAttackAnimationState = new AnimationState();
    public final AnimationState summonAnimationState = new AnimationState();
    public final AnimationState rangeBurstAttackAnimationState = new AnimationState();
    public final AnimationState deathAnimationState = new AnimationState();
    private final ServerBossEvent bossEvent;
    private DamageSource killedDamageSource;
    private static final ImmutableList<BlockPos> FRAME_POSITIONS;
    private ImmutableList<BlockPos> FRAME_POS_NORTH = ImmutableList.of((Object)new BlockPos(0, 2, -2), (Object)new BlockPos(-1, 2, -2), (Object)new BlockPos(-2, 2, -2), (Object)new BlockPos(-2, 1, -2), (Object)new BlockPos(-2, 0, -2), (Object)new BlockPos(-2, -1, -2), (Object)new BlockPos(-2, -2, -2), (Object)new BlockPos(-1, -2, -2), (Object)new BlockPos(0, -2, -2), (Object)new BlockPos(1, -2, -2), (Object)new BlockPos(2, -2, -2), (Object)new BlockPos(2, -1, -2), (Object[])new BlockPos[]{new BlockPos(2, 0, -2), new BlockPos(2, 1, -2), new BlockPos(2, 2, -2), new BlockPos(1, 2, -2)});
    private ImmutableList<BlockPos> FRAME_POS_EAST = ImmutableList.of((Object)new BlockPos(2, 2, 0), (Object)new BlockPos(2, 2, -1), (Object)new BlockPos(2, 2, -2), (Object)new BlockPos(2, 1, -2), (Object)new BlockPos(2, 0, -2), (Object)new BlockPos(2, -1, -2), (Object)new BlockPos(2, -2, -2), (Object)new BlockPos(2, -2, -1), (Object)new BlockPos(2, -2, 0), (Object)new BlockPos(2, -2, 1), (Object)new BlockPos(2, -2, 2), (Object)new BlockPos(2, -1, 2), (Object[])new BlockPos[]{new BlockPos(2, 0, 2), new BlockPos(2, 1, 2), new BlockPos(2, 2, 2), new BlockPos(2, 2, 1)});
    private ImmutableList<BlockPos> FRAME_POS_SOUTH = ImmutableList.of((Object)new BlockPos(0, 2, 2), (Object)new BlockPos(1, 2, 2), (Object)new BlockPos(2, 2, 2), (Object)new BlockPos(2, 1, 2), (Object)new BlockPos(2, 0, 2), (Object)new BlockPos(2, -1, 2), (Object)new BlockPos(2, -2, 2), (Object)new BlockPos(1, -2, 2), (Object)new BlockPos(0, -2, 2), (Object)new BlockPos(-1, -2, 2), (Object)new BlockPos(-2, -2, 2), (Object)new BlockPos(-2, -1, 2), (Object[])new BlockPos[]{new BlockPos(-2, 0, 2), new BlockPos(-2, 1, 2), new BlockPos(-2, 2, 2), new BlockPos(-1, 2, 2)});
    private ImmutableList<BlockPos> FRAME_POS_WEST = ImmutableList.of((Object)new BlockPos(-2, 2, 0), (Object)new BlockPos(-2, 2, 1), (Object)new BlockPos(-2, 2, 2), (Object)new BlockPos(-2, 1, 2), (Object)new BlockPos(-2, 0, 2), (Object)new BlockPos(-2, -1, 2), (Object)new BlockPos(-2, -2, 2), (Object)new BlockPos(-2, -2, 1), (Object)new BlockPos(-2, -2, 0), (Object)new BlockPos(-2, -2, -1), (Object)new BlockPos(-2, -2, -2), (Object)new BlockPos(-2, -1, -2), (Object[])new BlockPos[]{new BlockPos(-2, 0, -2), new BlockPos(-2, 1, -2), new BlockPos(-2, 2, -2), new BlockPos(-2, 2, -1)});
    private ImmutableList<BlockPos> FRAME_POS_UP = ImmutableList.of((Object)new BlockPos(0, 2, -2), (Object)new BlockPos(1, 2, -2), (Object)new BlockPos(2, 2, -2), (Object)new BlockPos(2, 2, -1), (Object)new BlockPos(2, 2, 0), (Object)new BlockPos(2, 2, 1), (Object)new BlockPos(2, 2, 2), (Object)new BlockPos(1, 2, 2), (Object)new BlockPos(0, 2, 2), (Object)new BlockPos(-1, 2, 2), (Object)new BlockPos(-2, 2, 2), (Object)new BlockPos(-2, 2, 1), (Object[])new BlockPos[]{new BlockPos(-2, 2, 0), new BlockPos(-2, 2, -1), new BlockPos(-2, 2, -2), new BlockPos(-1, 2, -2)});
    private ImmutableList<BlockPos> FRAME_POS_DOWN = ImmutableList.of((Object)new BlockPos(0, -2, -2), (Object)new BlockPos(1, -2, -2), (Object)new BlockPos(2, -2, -2), (Object)new BlockPos(2, -2, -1), (Object)new BlockPos(2, -2, 0), (Object)new BlockPos(2, -2, 1), (Object)new BlockPos(2, -2, 2), (Object)new BlockPos(1, -2, 2), (Object)new BlockPos(0, -2, 2), (Object)new BlockPos(-1, -2, 2), (Object)new BlockPos(-2, -2, 2), (Object)new BlockPos(-2, -2, 1), (Object[])new BlockPos[]{new BlockPos(-2, -2, 0), new BlockPos(-2, -2, -1), new BlockPos(-2, -2, -2), new BlockPos(-1, -2, -2)});

    public ChaosSpawnerEntity(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.m_21530_();
        this.bossEvent = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.PROGRESS).m_7003_(true);
        this.f_21364_ = 500;
        this.playerUUIDs = Sets.newHashSet();
        this.currentPlayerUUID = UUID.randomUUID();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 300.0).m_22268_(Attributes.f_22277_, 35.0).m_22266_(Attributes.f_22280_).m_22268_(Attributes.f_22279_, (double)0.23f).m_22268_(Attributes.f_22281_, 20.0).m_22268_(Attributes.f_22285_, 8.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new ChaosSpawnerResetGoal(this, this.getFollowDistance()));
        this.f_21345_.m_25352_(2, (Goal)new ChaosSpawnerSummonMobGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new ChaosSpawnerShootGhostBulletGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new ChaosSpawnerPushGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new ChaosSpawnerLookAtPlayerGoal(this, Player.class, 30.0f, 1.0f, false));
        this.f_21345_.m_25352_(8, (Goal)new ChaosSpawnerRandomLookAroundGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new ChaosSpawnerPlayerTargetGoal(this, this.getFollowDistance()));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 5, false, false, c -> c instanceof PlayerSupporterEntity));
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level level) {
        return super.m_6037_(level);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SPAWN_POINT, (Object)BlockPos.f_121853_);
        this.f_19804_.m_135372_(DATA_STATE, (Object)State.IDLE);
        this.f_19804_.m_135372_(PHASE, (Object)0);
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)false);
        this.f_19804_.m_135372_(AWAKENING_TICKS, (Object)0);
        this.f_19804_.m_135372_(ATTACK_TICK, (Object)0);
        this.f_19804_.m_135372_(PLAYER_COUNT, (Object)0);
        this.f_19804_.m_135372_(BARRIER_NORTH_TICK, (Object)-1);
        this.f_19804_.m_135372_(BARRIER_EAST_TICK, (Object)-1);
        this.f_19804_.m_135372_(BARRIER_SOUTH_TICK, (Object)-1);
        this.f_19804_.m_135372_(BARRIER_WEST_TICK, (Object)-1);
        this.f_19804_.m_135372_(BARRIER_UP_TICK, (Object)-1);
        this.f_19804_.m_135372_(BARRIER_DOWN_TICK, (Object)-1);
    }

    public void m_7380_(@NotNull CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("SpawnPointX", this.getSpawnPointPos().m_123341_());
        compoundTag.m_128405_("SpawnPointY", this.getSpawnPointPos().m_123342_());
        compoundTag.m_128405_("SpawnPointZ", this.getSpawnPointPos().m_123343_());
        compoundTag.m_128405_("Phase", ((Integer)this.f_19804_.m_135370_(PHASE)).intValue());
        compoundTag.m_128405_("AwakeningTicks", ((Integer)this.f_19804_.m_135370_(AWAKENING_TICKS)).intValue());
        compoundTag.m_128405_("AttackTicks", this.attackTickCount);
        compoundTag.m_128405_("PlayerCount", ((Integer)this.f_19804_.m_135370_(PLAYER_COUNT)).intValue());
        compoundTag.m_128405_("BarrierNorthTicks", ((Integer)this.f_19804_.m_135370_(BARRIER_NORTH_TICK)).intValue());
        compoundTag.m_128405_("BarrierEastTicks,", ((Integer)this.f_19804_.m_135370_(BARRIER_EAST_TICK)).intValue());
        compoundTag.m_128405_("BarrierSouthTicks,", ((Integer)this.f_19804_.m_135370_(BARRIER_SOUTH_TICK)).intValue());
        compoundTag.m_128405_("BarrierWestTicks,", ((Integer)this.f_19804_.m_135370_(BARRIER_WEST_TICK)).intValue());
        compoundTag.m_128405_("BarrierUpTicks,", ((Integer)this.f_19804_.m_135370_(BARRIER_UP_TICK)).intValue());
        compoundTag.m_128405_("BarrierDownTicks,", ((Integer)this.f_19804_.m_135370_(BARRIER_DOWN_TICK)).intValue());
        ListTag listTag = new ListTag();
        CompoundTag uuidCompoundTag = new CompoundTag();
        Iterator<UUID> var = this.playerUUIDs.iterator();
        int i = 0;
        while (var.hasNext()) {
            listTag.add((Object)uuidCompoundTag);
            uuidCompoundTag.m_128362_("PlayerUUID" + i, var.next());
            ++i;
        }
        compoundTag.m_128365_("PlayerUUIDs", (Tag)listTag);
        System.out.println(this.playerUUIDs);
    }

    public void m_7378_(@NotNull CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        int i = compoundTag.m_128451_("SpawnPointX");
        int j = compoundTag.m_128451_("SpawnPointY");
        int k = compoundTag.m_128451_("SpawnPointZ");
        this.f_19804_.m_135381_(SPAWN_POINT, (Object)new BlockPos(i, j, k));
        this.f_19804_.m_135381_(AWAKENING_TICKS, (Object)compoundTag.m_128451_("AwakeningTicks"));
        this.f_19804_.m_135381_(PLAYER_COUNT, (Object)compoundTag.m_128451_("PlayerCount"));
        this.f_19804_.m_135381_(BARRIER_NORTH_TICK, (Object)compoundTag.m_128451_("BarrierNorthTicks"));
        this.f_19804_.m_135381_(BARRIER_EAST_TICK, (Object)compoundTag.m_128451_("BarrierEastTicks"));
        this.f_19804_.m_135381_(BARRIER_SOUTH_TICK, (Object)compoundTag.m_128451_("BarrierSouthTicks"));
        this.f_19804_.m_135381_(BARRIER_WEST_TICK, (Object)compoundTag.m_128451_("BarrierWestTicks"));
        this.f_19804_.m_135381_(BARRIER_UP_TICK, (Object)compoundTag.m_128451_("BarrierUpTicks"));
        this.f_19804_.m_135381_(BARRIER_DOWN_TICK, (Object)compoundTag.m_128451_("BarrierDownTicks"));
        this.attackTickCount = compoundTag.m_128451_("AttackTicks");
        int phase = compoundTag.m_128451_("Phase");
        if (phase < 1) {
            this.f_19804_.m_135381_(DATA_STATE, (Object)State.SLEEPING);
            this.f_19804_.m_135381_(PHASE, (Object)0);
        } else {
            this.f_19804_.m_135381_(PHASE, (Object)phase);
        }
        if (this.m_8077_()) {
            this.bossEvent.m_6456_(this.m_5446_());
        }
        if (compoundTag.m_128425_("PlayerUUIDs", 9)) {
            ListTag listTag = compoundTag.m_128437_("PlayerUUIDs", 10);
            for (int a = 0; a < listTag.size(); ++a) {
                CompoundTag compoundTag1 = listTag.m_128728_(a);
                this.playerUUIDs.add(compoundTag1.m_128342_("PlayerUUID" + a));
            }
        }
    }

    public void m_141965_(@NotNull ClientboundAddEntityPacket clientboundAddEntityPacket) {
        super.m_141965_(clientboundAddEntityPacket);
        this.f_20883_ = 0.0f;
        this.f_20884_ = 0.0f;
    }

    @NotNull
    protected BodyRotationControl m_7560_() {
        return new EntityBodyRotationControl((Mob)this);
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        this.bossEvent.m_6456_(this.m_5446_());
    }

    public boolean m_20068_() {
        return true;
    }

    public Vec3 m_20184_() {
        return Vec3.f_82478_;
    }

    public void m_6457_(@NotNull ServerPlayer player) {
        super.m_6457_(player);
        this.bossEvent.m_6543_(player);
        if ((Integer)this.f_19804_.m_135370_(PHASE) == 0) {
            this.disableBossBar();
        }
    }

    public void m_6452_(@NotNull ServerPlayer player) {
        super.m_6452_(player);
        this.bossEvent.m_6539_(player);
    }

    public void startBossFight() {
        if (this.m_6084_() && (Integer)this.f_19804_.m_135370_(PHASE) < 1 && this.getState() != State.AWAKENING) {
            AABB bossArena = new AABB(this.m_20183_()).m_82400_(this.getFollowDistance());
            List players = this.m_9236_().m_45976_(ServerPlayer.class, bossArena);
            for (ServerPlayer p : players) {
                this.playerUUIDs.add(p.m_20148_());
            }
            int playerCount = players.size();
            EntityScale.scaleBossHealth((LivingEntity)this, playerCount);
            EntityScale.scaleBossAttack((LivingEntity)this, playerCount);
            this.f_19804_.m_135381_(PLAYER_COUNT, (Object)playerCount);
            this.f_19804_.m_135381_(AWAKENING_TICKS, (Object)160);
            this.f_19804_.m_135381_(DATA_STATE, (Object)State.AWAKENING);
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        if (this.m_6084_() && (Integer)this.f_19804_.m_135370_(PHASE) < 1 && this.getState() != State.AWAKENING) {
            player.m_5661_((Component)Component.m_237115_((String)"entity.dungeonnowloading.chaos_spawner.right_click"), true);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, interactionHand);
    }

    protected void m_8024_() {
        if (this.getAwakeningTick() > 0) {
            int k1 = this.getAwakeningTick() - 1;
            if (k1 == 99) {
                this.triggerWakeUpAnimation();
                this.m_5496_(DNLSounds.CHAOS_SPAWNER_CHAIN_BREAK.get(), 3.0f, 1.0f);
            }
            if (k1 == 60) {
                this.m_5496_(DNLSounds.CHAOS_SPAWNER_LAUGHTER.get(), 3.0f, 1.0f);
            }
            if (k1 <= 0) {
                this.setPhase(1);
                this.setDataState(State.IDLE);
            }
            this.setAwakeningTick(k1);
            if (k1 == 0) {
                for (int i = 0; i < 50; ++i) {
                    ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123744_, this.m_20208_(0.9), this.m_20187_(), this.m_20262_(0.9), 1, 0.0, 0.0, 0.0, 0.0);
                }
                this.fillBarriers();
                this.fillFrames();
                this.enableBossBar();
            }
        }
        if (this.getPhase() > 0 && !this.getState().equals((Object)State.DEATH)) {
            this.abilitySelectionTick();
            this.damageContactPlayer();
            this.checkBarrierTick();
            this.phaseUpdateTick();
        }
        if (this.getState().equals((Object)State.DEATH)) {
            ++this.deathAnimationTickCount;
            if (this.deathAnimationTickCount >= 160) {
                this.m_6667_(this.m_269291_().m_269264_());
            }
        }
        if (this.getPhase() == 0 && this.getState().equals((Object)State.IDLE)) {
            this.setDataState(State.SLEEPING);
        }
        super.m_8024_();
        this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
    }

    private void phaseUpdateTick() {
        if (this.getPhase() == 1 && (double)this.m_21223_() < (double)this.m_21233_() * 0.5) {
            this.setPhase(2);
        }
    }

    private void damageContactPlayer() {
        if (this.contactAttackTickCount > 0) {
            --this.contactAttackTickCount;
        } else {
            this.contactAttackTickCount = 20;
            AABB aabb = new AABB(this.m_20183_()).m_82400_(2.0);
            List targets = this.m_9236_().m_45976_(Player.class, aabb);
            for (Player player : targets) {
                this.m_7327_((Entity)player);
            }
        }
    }

    private void abilitySelectionTick() {
        if (this.m_5448_() != null) {
            if (this.attackTickCount > 0) {
                --this.attackTickCount;
            } else if (this.f_19804_.m_135370_(DATA_STATE) == State.IDLE) {
                WeightedRandomBag<State> attackPool = new WeightedRandomBag<State>();
                AABB aabb = new AABB(this.m_20183_()).m_82400_(10.0);
                this.pushTargets = this.m_9236_().m_45976_(Player.class, aabb);
                if (!this.pushTargets.isEmpty()) {
                    attackPool.addEntry(State.PUSH, 3.0);
                    attackPool.addEntry(State.SHOOT_GHOST_BULLET_SINGLE, 3.0);
                    attackPool.addEntry(State.SHOOT_GHOST_BULLET_BURST, 2.0);
                    attackPool.addEntry(State.SUMMON_MOB, 1.0);
                } else {
                    attackPool.addEntry(State.SHOOT_GHOST_BULLET_SINGLE, 3.0);
                    attackPool.addEntry(State.SHOOT_GHOST_BULLET_BURST, 2.0);
                    attackPool.addEntry(State.SUMMON_MOB, 1.0);
                }
                this.f_19804_.m_135381_(DATA_STATE, (Object)((State)((Object)attackPool.getRandom())));
            }
        }
    }

    private void checkBarrierTick() {
        if (this.barrierCheckTickCount > 0) {
            --this.barrierCheckTickCount;
        } else {
            this.barrierCheckTickCount = 20;
            BlockPos cageCenterPos = ((BlockPos)this.f_19804_.m_135370_(SPAWN_POINT)).m_6630_(1);
            this.checkBarrierIsBroken(cageCenterPos.m_7918_(0, 0, -2), BARRIER_NORTH_TICK);
            this.checkBarrierIsBroken(cageCenterPos.m_7918_(2, 0, 0), BARRIER_EAST_TICK);
            this.checkBarrierIsBroken(cageCenterPos.m_7918_(0, 0, 2), BARRIER_SOUTH_TICK);
            this.checkBarrierIsBroken(cageCenterPos.m_7918_(-2, 0, 0), BARRIER_WEST_TICK);
            this.checkBarrierIsBroken(cageCenterPos.m_7918_(0, 2, 0), BARRIER_UP_TICK);
            this.checkBarrierIsBroken(cageCenterPos.m_7918_(0, -2, 0), BARRIER_DOWN_TICK);
        }
        this.regenerateBarrierTick(this.FRAME_POS_NORTH, BARRIER_NORTH_TICK, ((BlockPos)this.f_19804_.m_135370_(SPAWN_POINT)).m_6630_(1).m_7918_(0, 0, -2), 0);
        this.regenerateBarrierTick(this.FRAME_POS_EAST, BARRIER_EAST_TICK, ((BlockPos)this.f_19804_.m_135370_(SPAWN_POINT)).m_6630_(1).m_7918_(2, 0, 0), 1);
        this.regenerateBarrierTick(this.FRAME_POS_SOUTH, BARRIER_SOUTH_TICK, ((BlockPos)this.f_19804_.m_135370_(SPAWN_POINT)).m_6630_(1).m_7918_(0, 0, 2), 2);
        this.regenerateBarrierTick(this.FRAME_POS_WEST, BARRIER_WEST_TICK, ((BlockPos)this.f_19804_.m_135370_(SPAWN_POINT)).m_6630_(1).m_7918_(-2, 0, 0), 3);
        this.regenerateBarrierTick(this.FRAME_POS_UP, BARRIER_UP_TICK, ((BlockPos)this.f_19804_.m_135370_(SPAWN_POINT)).m_6630_(1).m_7918_(0, 2, 0), 4);
        this.regenerateBarrierTick(this.FRAME_POS_DOWN, BARRIER_DOWN_TICK, ((BlockPos)this.f_19804_.m_135370_(SPAWN_POINT)).m_6630_(1).m_7918_(0, -2, 0), 5);
    }

    private void checkBarrierIsBroken(BlockPos blockPos, EntityDataAccessor<Integer> entityDataAccessor) {
        if (!this.m_9236_().m_8055_(blockPos).m_60713_((Block)DNLBlocks.CHAOS_SPAWNER_BARRIER_CENTER.get()) && (Integer)this.f_19804_.m_135370_(entityDataAccessor) < 0) {
            this.f_19804_.m_135381_(entityDataAccessor, (Object)100);
        }
    }

    private void regenerateBarrierTick(ImmutableList<BlockPos> framePositions, EntityDataAccessor<Integer> entityDataAccessor, BlockPos barrierCenterPos, int barrierDirection) {
        if ((Integer)this.f_19804_.m_135370_(entityDataAccessor) > 0) {
            int barrierRegenerateTickCount = (Integer)this.f_19804_.m_135370_(entityDataAccessor) - 1;
            this.f_19804_.m_135381_(entityDataAccessor, (Object)barrierRegenerateTickCount);
        } else if ((Integer)this.f_19804_.m_135370_(entityDataAccessor) != -1) {
            BlockPos cageCenterPos = ((BlockPos)this.f_19804_.m_135370_(SPAWN_POINT)).m_6630_(1);
            UnmodifiableIterator iterator = framePositions.iterator();
            int fixedFrame = 0;
            while (iterator.hasNext()) {
                BlockPos framePos = cageCenterPos.m_121955_((Vec3i)iterator.next());
                BlockState frameState = this.m_9236_().m_8055_(framePos);
                if (frameState.m_60713_((Block)DNLBlocks.CHAOS_SPAWNER_EDGE.get()) || frameState.m_60713_((Block)DNLBlocks.CHAOS_SPAWNER_DIAMOND_EDGE.get()) || frameState.m_60713_((Block)DNLBlocks.CHAOS_SPAWNER_DIAMOND_VERTEX.get())) {
                    ++fixedFrame;
                    continue;
                }
                if (frameState.m_60734_() instanceof ChaosSpawnerEdgeBlock) {
                    this.m_9236_().m_5594_(null, framePos, SoundEvents.f_11859_, this.m_5720_(), 3.0f, 1.0f);
                    ChaosSpawnerEdgeBlock.fixFrame(this.m_9236_(), framePos, frameState);
                } else if (frameState.m_60734_() instanceof ChaosSpawnerVertexBlock) {
                    this.m_9236_().m_5594_(null, framePos, SoundEvents.f_11859_, this.m_5720_(), 3.0f, 1.0f);
                    ChaosSpawnerVertexBlock.fixFrame(this.m_9236_(), framePos, frameState);
                }
                this.f_19804_.m_135381_(entityDataAccessor, (Object)20);
                break;
            }
            if (fixedFrame == 16) {
                this.f_19804_.m_135381_(entityDataAccessor, (Object)-1);
                this.placeFullBarrier(barrierCenterPos, barrierDirection);
            }
        }
    }

    private void placeFullBarrier(BlockPos barrierCenterPos, int barrierDirection) {
        this.m_9236_().m_5594_(null, barrierCenterPos, SoundEvents.f_11860_, this.m_5720_(), 1.0f, 2.0f);
        ChaosSpawnerBarrierCenterBlock.placeBarrier(this.m_9236_(), barrierCenterPos, barrierDirection);
        ChaosSpawnerBarrierEdgeBlock.placeBarrier(this.m_9236_(), barrierCenterPos, barrierDirection);
        ChaosSpawnerBarrierVertexBlock.placeBarrier(this.m_9236_(), barrierCenterPos, barrierDirection);
    }

    private void fillFrames() {
        UnmodifiableIterator iterator = FRAME_POSITIONS.iterator();
        BlockPos cageCenterPos = ((BlockPos)this.f_19804_.m_135370_(SPAWN_POINT)).m_6630_(1);
        while (iterator.hasNext()) {
            BlockPos framePos = cageCenterPos.m_121955_((Vec3i)((BlockPos)iterator.next()));
            BlockState frameState = this.m_9236_().m_8055_(framePos);
            if (frameState.m_60713_((Block)DNLBlocks.CHAOS_SPAWNER_BROKEN_DIAMOND_EDGE.get()) || frameState.m_60713_((Block)DNLBlocks.CHAOS_SPAWNER_BROKEN_EDGE.get())) {
                ChaosSpawnerEdgeBlock.fixFrame(this.m_9236_(), framePos, frameState);
                continue;
            }
            if (!frameState.m_60713_((Block)DNLBlocks.CHAOS_SPAWNER_BROKEN_DIAMOND_VERTEX.get())) continue;
            ChaosSpawnerVertexBlock.fixFrame(this.m_9236_(), framePos, frameState);
        }
    }

    private void fillBarriers() {
        BlockPos cageCenterPos = ((BlockPos)this.f_19804_.m_135370_(SPAWN_POINT)).m_6630_(1);
        Level level = this.m_9236_();
        if (!level.m_8055_(cageCenterPos.m_7918_(0, 0, -2)).m_60713_((Block)DNLBlocks.CHAOS_SPAWNER_BARRIER_CENTER.get())) {
            this.placeFullBarrier(cageCenterPos.m_7918_(0, 0, -2), 0);
        }
        if (!level.m_8055_(cageCenterPos.m_7918_(2, 0, 0)).m_60713_((Block)DNLBlocks.CHAOS_SPAWNER_BARRIER_CENTER.get())) {
            this.placeFullBarrier(cageCenterPos.m_7918_(2, 0, 0), 1);
        }
        if (!level.m_8055_(cageCenterPos.m_7918_(0, 0, 2)).m_60713_((Block)DNLBlocks.CHAOS_SPAWNER_BARRIER_CENTER.get())) {
            this.placeFullBarrier(cageCenterPos.m_7918_(0, 0, 2), 2);
        }
        if (!level.m_8055_(cageCenterPos.m_7918_(-2, 0, 0)).m_60713_((Block)DNLBlocks.CHAOS_SPAWNER_BARRIER_CENTER.get())) {
            this.placeFullBarrier(cageCenterPos.m_7918_(-2, 0, 0), 3);
        }
        if (!level.m_8055_(cageCenterPos.m_7918_(0, 2, 0)).m_60713_((Block)DNLBlocks.CHAOS_SPAWNER_BARRIER_CENTER.get())) {
            this.placeFullBarrier(cageCenterPos.m_7918_(0, 2, 0), 4);
        }
        if (!level.m_8055_(cageCenterPos.m_7918_(0, -2, 0)).m_60713_((Block)DNLBlocks.CHAOS_SPAWNER_BARRIER_CENTER.get())) {
            this.placeFullBarrier(cageCenterPos.m_7918_(0, -2, 0), 5);
        }
    }

    public void m_7822_(byte b) {
        this.resetAnimations();
        switch (b) {
            case 3: {
                SoundEvent soundEvent = this.m_5592_();
                if (soundEvent != null) {
                    this.m_5496_(soundEvent, this.m_6121_(), (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
                }
                this.deathAnimationState.m_216977_(this.f_19797_);
                this.m_21153_(0.0f);
                this.setDataState(State.DEATH);
            }
            case 71: {
                this.sleepingAnimationState.m_216973_();
                this.awakeningAnimationState.m_216977_(this.f_19797_);
                break;
            }
            case 72: {
                this.smashAttackAnimationState.m_216977_(this.f_19797_);
                break;
            }
            case 73: {
                this.rangeAttackAnimationState.m_216977_(this.f_19797_);
                break;
            }
            case 74: {
                this.rangeBurstAttackAnimationState.m_216977_(this.f_19797_);
                break;
            }
            case 75: {
                this.summonAnimationState.m_216977_(this.f_19797_);
                break;
            }
            case 76: {
                this.deathAnimationState.m_216977_(this.f_19797_);
                break;
            }
            case 70: {
                this.sleepingAnimationState.m_216977_(this.f_19797_);
            }
            case 77: {
                this.resetAnimations();
            }
            default: {
                super.m_7822_(b);
            }
        }
    }

    private void resetAnimations() {
        this.sleepingAnimationState.m_216973_();
        this.awakeningAnimationState.m_216973_();
        this.smashAttackAnimationState.m_216973_();
        this.summonAnimationState.m_216973_();
        this.rangeAttackAnimationState.m_216973_();
        this.rangeBurstAttackAnimationState.m_216973_();
        this.deathAnimationState.m_216973_();
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, SpawnGroupData spawnGroupData, CompoundTag compoundTag) {
        this.f_19804_.m_135381_(SPAWN_POINT, (Object)this.m_20183_());
        this.f_19804_.m_135381_(DATA_STATE, (Object)State.SLEEPING);
        this.triggerSleepAnimation();
        return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    public boolean m_6469_(DamageSource damageSource, float damage) {
        if (!(damageSource.m_269533_(DamageTypeTags.f_268738_) || damageSource.m_19390_() || this.f_19804_.m_135370_(DATA_STATE) != State.SLEEPING && this.f_19804_.m_135370_(DATA_STATE) != State.AWAKENING)) {
            return false;
        }
        return super.m_6469_(damageSource, damage);
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 1) {
            this.m_146926_(0.0f);
        }
        if (this.f_20919_ >= 160 && !this.m_9236_().m_5776_() && !this.m_213877_()) {
            Level level = this.m_9236_();
            Entity entity = this.killedDamageSource.m_7639_();
            LivingEntity livingEntity = this.m_21232_();
            if (this.f_20897_ >= 0 && livingEntity != null) {
                livingEntity.m_5993_((Entity)this, this.f_20897_, this.killedDamageSource);
            }
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (entity == null || entity.m_214076_(serverLevel, (LivingEntity)this)) {
                    this.m_6668_(this.killedDamageSource);
                    this.m_21268_(livingEntity);
                }
                this.m_9236_().m_7605_((Entity)this, (byte)3);
            }
            this.m_9236_().m_7605_((Entity)this, (byte)60);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public void m_6667_(DamageSource damageSource) {
        Level level;
        if (this.m_213877_() || this.f_20890_) {
            return;
        }
        this.killedDamageSource = damageSource;
        Entity entity = this.killedDamageSource.m_7639_();
        if (this.m_5803_()) {
            this.m_5796_();
        }
        if (!this.m_9236_().f_46443_ && this.m_8077_()) {
            LOGGER.info("Named entity {} died: {}", (Object)this, (Object)this.m_21231_().m_19293_().getString());
        }
        if ((level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (entity == null || entity.m_214076_(serverLevel, (LivingEntity)this)) {
                this.m_146850_(GameEvent.f_223707_);
            }
            this.m_9236_().m_7605_((Entity)this, (byte)3);
        }
        this.f_20890_ = true;
        this.m_21231_().m_19296_();
        this.m_20124_(Pose.DYING);
    }

    protected void m_7472_(DamageSource damageSource, int a, boolean b) {
        if (((Boolean)BossConfig.TOGGLE_MULTIPLAYER_LOOT.get()).booleanValue() && !this.playerUUIDs.isEmpty()) {
            Iterator<UUID> iterator = this.playerUUIDs.iterator();
            while (iterator.hasNext()) {
                UUID playerUUID;
                this.currentPlayerUUID = playerUUID = iterator.next();
                this.spawnLootTableItems(damageSource, true);
            }
        } else {
            super.m_7472_(damageSource, a, b);
        }
    }

    protected void m_7625_(DamageSource $$0, boolean $$1) {
        if (!((Boolean)BossConfig.TOGGLE_MULTIPLAYER_LOOT.get()).booleanValue()) {
            super.m_7625_($$0, $$1);
        }
    }

    public void spawnLootTableItems(DamageSource damageSource, boolean b) {
        ResourceLocation resourceLocation = this.m_5743_();
        LootTable lootTable = this.m_9236_().m_7654_().m_278653_().m_278676_(resourceLocation);
        LootParams.Builder lootparams$builder = new LootParams.Builder((ServerLevel)this.m_9236_()).m_287286_(LootContextParams.f_81455_, (Object)this).m_287286_(LootContextParams.f_81460_, (Object)this.m_20182_()).m_287286_(LootContextParams.f_81457_, (Object)damageSource).m_287289_(LootContextParams.f_81458_, (Object)damageSource.m_7639_()).m_287289_(LootContextParams.f_81459_, (Object)damageSource.m_7640_());
        if (b && this.f_20888_ != null) {
            lootparams$builder = lootparams$builder.m_287286_(LootContextParams.f_81456_, (Object)this.f_20888_).m_287239_(this.f_20888_.m_36336_());
        }
        LootParams lootParams = lootparams$builder.m_287235_(LootContextParamSets.f_81415_);
        lootTable.m_287276_(lootParams, this.m_287233_(), this::spawnSpecialItemAtLocation);
    }

    public SpecialItemEntity spawnSpecialItemAtLocation(ItemStack itemStack) {
        return this.spawnSpecialItemEntity(itemStack, 0.0f, this.currentPlayerUUID);
    }

    public SpecialItemEntity spawnSpecialItemEntity(ItemStack itemStack, float i, UUID uuid) {
        if (itemStack.m_41619_()) {
            return null;
        }
        if (this.m_9236_().f_46443_) {
            return null;
        }
        SpecialItemEntity specialItemEntity = new SpecialItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_() + (double)i, this.m_20189_(), itemStack);
        specialItemEntity.setPickerUUID(uuid);
        specialItemEntity.m_32060_();
        this.m_9236_().m_7967_((Entity)specialItemEntity);
        return specialItemEntity;
    }

    public void m_7334_(Entity entity) {
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6063_() {
        return false;
    }

    protected float m_6431_(Pose $$0, EntityDimensions $$1) {
        return 1.0f;
    }

    protected boolean m_20073_() {
        return false;
    }

    protected SoundEvent m_7975_(DamageSource $$0) {
        return DNLSounds.CHAOS_SPAWNER_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return DNLSounds.CHAOS_SPAWNER_DEATH.get();
    }

    private SoundEvent getChainBreakSound() {
        return DNLSounds.CHAOS_SPAWNER_CHAIN_BREAK.get();
    }

    public SoundEvent getScreechSound() {
        return DNLSounds.CHAOS_SPAWNER_LAUGHTER.get();
    }

    public boolean isAwakening() {
        return this.f_19804_.m_135370_(DATA_STATE) == State.AWAKENING;
    }

    public boolean m_5803_() {
        return this.f_19804_.m_135370_(DATA_STATE) == State.SLEEPING;
    }

    public boolean isAttacking(State attackState) {
        return this.f_19804_.m_135370_(DATA_STATE) == attackState;
    }

    public State getState() {
        return (State)((Object)this.f_19804_.m_135370_(DATA_STATE));
    }

    public int getAwakeningTick() {
        return (Integer)this.f_19804_.m_135370_(AWAKENING_TICKS);
    }

    public int getAttackTick() {
        return this.attackTickCount;
    }

    public int getPhase() {
        return (Integer)this.f_19804_.m_135370_(PHASE);
    }

    public BlockPos getSpawnPointPos() {
        return (BlockPos)this.f_19804_.m_135370_(SPAWN_POINT);
    }

    public Set<UUID> getParticipatingPlayerUUIDs() {
        return this.playerUUIDs;
    }

    public int getParticipatingPlayerCount() {
        return this.playerUUIDs.size();
    }

    public List<Player> getPushTargets() {
        return this.pushTargets;
    }

    public double getAttackDamage() {
        return this.m_21133_(Attributes.f_22281_);
    }

    public double getFollowDistance() {
        return this.m_21133_(Attributes.f_22277_);
    }

    public void triggerWakeUpAnimation() {
        this.m_9236_().m_7605_((Entity)this, (byte)71);
    }

    public void triggerRangeAttackAnimation() {
        this.m_9236_().m_7605_((Entity)this, (byte)73);
    }

    public void triggerRangeBurstAttackAnimation() {
        this.m_9236_().m_7605_((Entity)this, (byte)74);
    }

    public void triggerSmashAttackAnimation() {
        this.m_9236_().m_7605_((Entity)this, (byte)72);
    }

    public void triggerSummonAnimation() {
        this.m_9236_().m_7605_((Entity)this, (byte)75);
    }

    public void triggerDeathAnimation() {
        this.m_9236_().m_7605_((Entity)this, (byte)76);
    }

    public void triggerSleepAnimation() {
        this.m_9236_().m_7605_((Entity)this, (byte)70);
    }

    public void triggerAnimationStop() {
        this.m_9236_().m_7605_((Entity)this, (byte)77);
    }

    public void clearParticipatingPlayers() {
        this.playerUUIDs.clear();
    }

    public void setDataState(State state) {
        this.f_19804_.m_135381_(DATA_STATE, (Object)state);
    }

    public void setAwakeningTick(int tick) {
        this.f_19804_.m_135381_(AWAKENING_TICKS, (Object)tick);
    }

    public void setAttackTick(int tick) {
        this.attackTickCount = tick;
    }

    public void setPhase(int phase) {
        this.f_19804_.m_135381_(PHASE, (Object)phase);
    }

    public void setBarrierNorthTick(int tick) {
        this.f_19804_.m_135381_(BARRIER_NORTH_TICK, (Object)tick);
    }

    public void setBarrierEastTick(int tick) {
        this.f_19804_.m_135381_(BARRIER_EAST_TICK, (Object)tick);
    }

    public void setBarrierSouthTick(int tick) {
        this.f_19804_.m_135381_(BARRIER_SOUTH_TICK, (Object)tick);
    }

    public void setBarrierWestTick(int tick) {
        this.f_19804_.m_135381_(BARRIER_WEST_TICK, (Object)tick);
    }

    public void setBarrierUpTick(int tick) {
        this.f_19804_.m_135381_(BARRIER_UP_TICK, (Object)tick);
    }

    public void setBarrierDownTick(int tick) {
        this.f_19804_.m_135381_(BARRIER_DOWN_TICK, (Object)tick);
    }

    public void enableBossBar() {
        this.bossEvent.m_8321_(true);
    }

    public void disableBossBar() {
        this.bossEvent.m_8321_(false);
    }

    public void stopAttacking(int cooldown) {
        this.f_19804_.m_135381_(DATA_STATE, (Object)State.IDLE);
        this.setAttackTick(cooldown);
    }

    static {
        SPAWN_POINT = SynchedEntityData.m_135353_(ChaosSpawnerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
        PHASE = SynchedEntityData.m_135353_(ChaosSpawnerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        AWAKENING_TICKS = SynchedEntityData.m_135353_(ChaosSpawnerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        ATTACK_TICK = SynchedEntityData.m_135353_(ChaosSpawnerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        ACTIVE_RANGE = SynchedEntityData.m_135353_(ChaosSpawnerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        PLAYER_COUNT = SynchedEntityData.m_135353_(ChaosSpawnerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        BARRIER_NORTH_TICK = SynchedEntityData.m_135353_(ChaosSpawnerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        BARRIER_EAST_TICK = SynchedEntityData.m_135353_(ChaosSpawnerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        BARRIER_SOUTH_TICK = SynchedEntityData.m_135353_(ChaosSpawnerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        BARRIER_WEST_TICK = SynchedEntityData.m_135353_(ChaosSpawnerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        BARRIER_UP_TICK = SynchedEntityData.m_135353_(ChaosSpawnerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        BARRIER_DOWN_TICK = SynchedEntityData.m_135353_(ChaosSpawnerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        PLAYER_UUID = SynchedEntityData.m_135353_(ChaosSpawnerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
        DATA_STATE = SynchedEntityData.m_135353_(ChaosSpawnerEntity.class, EntityStates.CHAOS_SPAWNER_STATE);
        FRAME_POSITIONS = ImmutableList.of((Object)new BlockPos(2, 2, 2), (Object)new BlockPos(2, 2, 1), (Object)new BlockPos(2, 2, 0), (Object)new BlockPos(2, 2, -1), (Object)new BlockPos(2, 2, -2), (Object)new BlockPos(-2, 2, 2), (Object)new BlockPos(-2, 2, 1), (Object)new BlockPos(-2, 2, 0), (Object)new BlockPos(-2, 2, -1), (Object)new BlockPos(-2, 2, -2), (Object)new BlockPos(1, 2, 2), (Object)new BlockPos(0, 2, 2), (Object[])new BlockPos[]{new BlockPos(-1, 2, 2), new BlockPos(1, 2, -2), new BlockPos(0, 2, -2), new BlockPos(-1, 2, -2), new BlockPos(2, -2, 2), new BlockPos(2, -2, 1), new BlockPos(2, -2, 0), new BlockPos(2, -2, -1), new BlockPos(2, -2, -2), new BlockPos(-2, -2, 2), new BlockPos(-2, -2, 1), new BlockPos(-2, -2, 0), new BlockPos(-2, -2, -1), new BlockPos(-2, -2, -2), new BlockPos(1, -2, 2), new BlockPos(0, -2, 2), new BlockPos(-1, -2, 2), new BlockPos(1, -2, -2), new BlockPos(0, -2, -2), new BlockPos(-1, -2, -2), new BlockPos(2, 1, 2), new BlockPos(2, 0, 2), new BlockPos(2, -1, 2), new BlockPos(2, 1, -2), new BlockPos(2, 0, -2), new BlockPos(2, -1, -2), new BlockPos(-2, 1, -2), new BlockPos(-2, 0, -2), new BlockPos(-2, -1, -2), new BlockPos(-2, -1, 2), new BlockPos(-2, 0, 2), new BlockPos(-2, -1, 2)});
    }

    public static enum State {
        SLEEPING,
        AWAKENING,
        IDLE,
        SUMMON_MOB,
        SHOOT_GHOST_BULLET_SINGLE,
        SHOOT_GHOST_BULLET_BURST,
        PUSH,
        DEATH;

    }
}

