/*
 * Decompiled with CFR 0.152.
 */
package dev.scsupercraft.teamstages.ftbquests.tasks;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.AbstractBooleanTask;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.scsupercraft.teamstages.data.TeamStageHelper;
import dev.scsupercraft.teamstages.data.TeamStageSaveHandler;
import dev.scsupercraft.teamstages.ftbquests.Tasks;
import dev.scsupercraft.teamstages.util.GameStageEffect;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class StageTask
extends AbstractBooleanTask {
    protected String stage = "";
    protected GameStageEffect effect = GameStageEffect.PLAYER;

    public StageTask(long id, Quest quest) {
        super(id, quest);
    }

    public TaskType getType() {
        return Tasks.Stage;
    }

    public String getStage() {
        return this.stage;
    }

    public void setStage(String stage) {
        if (TeamStageHelper.isValidStageName(stage)) {
            this.stage = stage;
        }
    }

    public GameStageEffect getEffect() {
        return this.effect;
    }

    public void setEffect(GameStageEffect effect) {
        this.effect = effect;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        config.addString("stage", this.stage, this::setStage, "").setNameKey("teamstages.quests.tasks.stage.stage");
        config.addEnum("effect", (Object)this.effect, this::setEffect, NameMap.of((Object)((Object)GameStageEffect.PLAYER), (Object[])GameStageEffect.values()).create()).setNameKey("teamstages.quests.tasks.stage.effect");
    }

    @OnlyIn(value=Dist.CLIENT)
    public MutableComponent getAltTitle() {
        return Component.m_237110_((String)"teamstages.quests.tasks.stage.altTitle", (Object[])new Object[]{this.getStage()});
    }

    public void writeData(CompoundTag nbt) {
        super.writeData(nbt);
        nbt.m_128359_("stage", this.stage);
        nbt.m_128359_("effect", this.effect.toString());
    }

    public void readData(CompoundTag nbt) {
        super.readData(nbt);
        this.stage = nbt.m_128461_("stage");
        this.effect = GameStageEffect.valueOf(nbt.m_128461_("effect"));
    }

    public void writeNetData(FriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.m_130072_(this.stage, 512);
        buffer.m_130068_((Enum)this.effect);
    }

    public void readNetData(FriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.stage = buffer.m_130136_(512);
        this.effect = (GameStageEffect)buffer.m_130066_(GameStageEffect.class);
    }

    public int autoSubmitOnPlayerTick() {
        return 20;
    }

    public boolean canSubmit(TeamData teamData, ServerPlayer player) {
        return TeamStageSaveHandler.getGameDataForPlayer(player.m_20148_()).hasStage(this.stage, this.effect);
    }
}

