/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.world.module;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.content.world.block.MonsterBoxBlock;
import org.violetmoon.quark.content.world.block.be.MonsterBoxBlockEntity;
import org.violetmoon.quark.content.world.gen.MonsterBoxGenerator;
import org.violetmoon.quark.mixin.mixins.accessor.AccessorLivingEntity;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.config.type.DimensionConfig;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.load.ZCommonSetup;
import org.violetmoon.zeta.event.load.ZRegister;
import org.violetmoon.zeta.event.play.entity.living.ZLivingDrops;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.world.WorldGenHandler;
import org.violetmoon.zeta.world.generator.Generator;

@ZetaLoadModule(category="world")
public class MonsterBoxModule
extends ZetaModule {
    public static final String TAG_MONSTER_BOX_SPAWNED = "quark:monster_box_spawned";
    public static final ResourceLocation MONSTER_BOX_LOOT_TABLE = new ResourceLocation("quark", "misc/monster_box");
    public static final ResourceLocation MONSTER_BOX_SPAWNS_LOOT_TABLE = new ResourceLocation("quark", "misc/monster_box_spawns");
    public static BlockEntityType<MonsterBoxBlockEntity> blockEntityType;
    @Config(description="The chance for the monster box generator to try and place one in a chunk. 0 is 0%, 1 is 100%\nThis can be higher than 100% if you want multiple per chunk.")
    public static double chancePerChunk;
    @Config
    public static int minY;
    @Config
    public static int maxY;
    @Config
    public static int minMobCount;
    @Config
    public static int maxMobCount;
    @Config
    public static DimensionConfig dimensions;
    @Config
    public static boolean enableExtraLootTable;
    @Config
    public static double activationRange;
    @Config(description="How many blocks to search vertically from a position before trying to place a block. Higher means you'll get more boxes in open spaces.")
    public static int searchRange;
    public static Block monster_box;

    @LoadEvent
    public final void register(ZRegister event) {
        monster_box = new MonsterBoxBlock(this);
        blockEntityType = BlockEntityType.Builder.m_155273_(MonsterBoxBlockEntity::new, (Block[])new Block[]{monster_box}).m_58966_(null);
        Quark.ZETA.registry.register(blockEntityType, "monster_box", Registries.f_256922_);
    }

    @LoadEvent
    public final void setup(ZCommonSetup event) {
        WorldGenHandler.addGenerator((ZetaModule)this, (Generator)new MonsterBoxGenerator(dimensions), (GenerationStep.Decoration)GenerationStep.Decoration.UNDERGROUND_DECORATION, (int)6);
    }

    @PlayEvent
    public void onDrops(ZLivingDrops event) {
        Level level;
        LivingEntity entity = event.getEntity();
        if (enableExtraLootTable && (level = entity.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (entity.getPersistentData().m_128471_(TAG_MONSTER_BOX_SPAWNED) && entity.m_9236_().m_46469_().m_46207_(GameRules.f_46135_) && ((AccessorLivingEntity)entity).quark$lastHurtByPlayerTime() > 0) {
                LootTable loot = serverLevel.m_7654_().m_278653_().m_278676_(MONSTER_BOX_LOOT_TABLE);
                ObjectArrayList generatedLoot = loot.m_287195_(this.getLootParamsBuilder(entity, true, event.getSource()).m_287235_(LootContextParamSets.f_81415_));
                entity.captureDrops(new ArrayList());
                for (ItemStack stack : generatedLoot) {
                    entity.m_19983_(stack);
                }
                event.getDrops().addAll(entity.captureDrops(null));
            }
        }
    }

    private LootParams.Builder getLootParamsBuilder(LivingEntity entity, boolean bl, DamageSource damageSource) {
        LootParams.Builder builder = new LootParams.Builder((ServerLevel)entity.m_9236_()).m_287286_(LootContextParams.f_81455_, (Object)entity).m_287286_(LootContextParams.f_81460_, (Object)entity.m_20182_()).m_287286_(LootContextParams.f_81457_, (Object)damageSource).m_287289_(LootContextParams.f_81458_, (Object)damageSource.m_7639_()).m_287289_(LootContextParams.f_81459_, (Object)damageSource.m_7640_());
        if (bl && ((AccessorLivingEntity)entity).quark$lastHurtByPlayer() != null) {
            builder = builder.m_287286_(LootContextParams.f_81456_, (Object)((AccessorLivingEntity)entity).quark$lastHurtByPlayer()).m_287239_(((AccessorLivingEntity)entity).quark$lastHurtByPlayer().m_36336_());
        }
        return builder;
    }

    static {
        chancePerChunk = 0.2;
        minY = -50;
        maxY = 0;
        minMobCount = 5;
        maxMobCount = 8;
        dimensions = DimensionConfig.overworld((boolean)false);
        enableExtraLootTable = true;
        activationRange = 2.5;
        searchRange = 15;
        monster_box = null;
    }
}

