/*
 * Decompiled with CFR 0.152.
 */
package io.github.jamalam360.jamlib.client.config.gui.entry;

import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class SliderButton
extends AbstractSliderButton {
    private final double min;
    private final double max;
    private final Consumer<Double> onChange;
    private final Function<Double, Component> toString;

    protected SliderButton(int x, int y, int width, int height, Component message, double min, double max, double value, Consumer<Double> onChange, Function<Double, Component> toString) {
        super(x, y, width, height, message, (Mth.clamp((double)((float)value), (double)min, (double)max) - min) / (max - min));
        this.min = min;
        this.max = max;
        this.onChange = onChange;
        this.toString = toString;
    }

    public void updateValue(double value) {
        this.value = (Mth.clamp((double)((float)value), (double)this.min, (double)this.max) - this.min) / (this.max - this.min);
        this.updateMessage();
    }

    protected void updateMessage() {
        this.setMessage(this.toString.apply(Mth.lerp((double)Mth.clamp((double)this.value, (double)0.0, (double)1.0), (double)this.min, (double)this.max)));
    }

    protected void applyValue() {
        this.onChange.accept(Mth.lerp((double)Mth.clamp((double)this.value, (double)0.0, (double)1.0), (double)this.min, (double)this.max));
    }
}

