/*
 * Decompiled with CFR 0.152.
 */
package io.github.jamalam360.jamlib.client.config.gui;

import dev.architectury.platform.Platform;
import io.github.jamalam360.jamlib.JamLib;
import io.github.jamalam360.jamlib.client.config.gui.entry.ConfigEntry;
import io.github.jamalam360.jamlib.client.gui.WidgetList;
import io.github.jamalam360.jamlib.config.ConfigExtensions;
import io.github.jamalam360.jamlib.config.ConfigManager;
import io.github.jamalam360.jamlib.config.HiddenInGui;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.SpriteIconButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Util;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class ConfigScreen<T>
extends Screen {
    protected final ConfigManager<T> manager;
    private final Screen parent;
    private final List<ConfigEntry<T, ?>> entries;
    private WidgetList widgetList;
    private Button doneButton;

    public ConfigScreen(ConfigManager<T> manager, Screen parent) {
        super(ConfigScreen.createTitle(manager));
        this.manager = manager;
        this.parent = parent;
        this.entries = new ArrayList();
    }

    @ApiStatus.Internal
    public static String createTranslationKey(String modId, String configName, String path) {
        if (modId.equals(configName)) {
            return "config." + modId + "." + path;
        }
        return "config." + modId + "." + configName + "." + path;
    }

    protected static Component createTitle(ConfigManager<?> manager) {
        String translationKey = ConfigScreen.createTranslationKey(manager.getModId(), manager.getConfigName(), "title");
        if (I18n.exists((String)translationKey)) {
            return Component.translatable((String)translationKey);
        }
        return Component.literal((String)Platform.getMod((String)manager.getModId()).getName());
    }

    protected void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_CANCEL, button -> {
            this.manager.reloadFromDisk();
            Objects.requireNonNull(this.minecraft).setScreen(this.parent);
        }).pos(this.width / 2 - 154, this.height - 28).size(150, 20).build());
        this.doneButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, button -> {
            if (this.hasChanges()) {
                this.manager.save();
            }
            Objects.requireNonNull(this.minecraft).setScreen(this.parent);
        }).pos(this.width / 2 + 4, this.height - 28).size(150, 20).build());
        SpriteIconButton editManuallyButton = (SpriteIconButton)this.addRenderableWidget((GuiEventListener)SpriteIconButton.builder((Component)Component.translatable((String)"config.jamlib.edit_manually"), button -> {
            if (this.hasChanges()) {
                this.manager.save();
            }
            Util.getPlatform().openFile(Platform.getConfigFolder().resolve(this.manager.getConfigName() + ".json5").toFile());
            Objects.requireNonNull(this.minecraft).setScreen(this.parent);
        }, (boolean)true).sprite(JamLib.id("writable_book"), 16, 16).size(20, 20).build());
        editManuallyButton.setX(7);
        editManuallyButton.setY(7);
        this.widgetList = new WidgetList(this.minecraft, this.width, this.height - 64, 32);
        if (this.entries.isEmpty()) {
            for (Field field : this.manager.getConfigClass().getFields()) {
                if (field.isAnnotationPresent(HiddenInGui.class)) continue;
                this.entries.add(ConfigEntry.createFromField(this.manager.getModId(), this.manager.getConfigName(), field));
            }
        }
        for (ConfigEntry configEntry : this.entries) {
            this.widgetList.addWidgetGroup(configEntry.createWidgets(this.width));
        }
        this.addRenderableWidget((GuiEventListener)this.widgetList);
        T t = this.manager.get();
        if (t instanceof ConfigExtensions) {
            ConfigExtensions ext = (ConfigExtensions)t;
            List<ConfigExtensions.Link> list = ext.getLinks();
            for (int i = 0; i < list.size(); ++i) {
                ConfigExtensions.Link link = list.get(i);
                SpriteIconButton linkButton = (SpriteIconButton)this.addRenderableWidget((GuiEventListener)SpriteIconButton.builder((Component)link.getTooltip(), button -> {
                    try {
                        Util.getPlatform().openUri(link.getUrl().toURI());
                    }
                    catch (Exception e) {
                        JamLib.LOGGER.error("Failed to open link", (Throwable)e);
                    }
                }, (boolean)true).sprite(link.getTexture(), 16, 16).size(20, 20).build());
                linkButton.setX(this.width - 30 - 28 * i);
                linkButton.setY(5);
            }
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        super.render(graphics, mouseX, mouseY, delta);
        graphics.drawCenteredString(Minecraft.getInstance().font, this.title, this.width / 2, 12, -1);
    }

    private boolean canExit() {
        return this.entries.stream().allMatch(ConfigEntry::isValid);
    }

    private boolean hasChanges() {
        return this.entries.stream().anyMatch(ConfigEntry::hasChanged);
    }

    public void tick() {
        super.tick();
        boolean canExit = this.canExit();
        if (this.doneButton.active != canExit) {
            this.doneButton.active = canExit;
        }
        for (int i = 0; i < this.entries.size(); ++i) {
            ConfigEntry<T, ?> entry = this.entries.get(i);
            List<AbstractWidget> widgets = entry.getNewWidgets(this.width);
            if (widgets == null) continue;
            this.widgetList.updateWidgetGroup(i, widgets);
        }
    }
}

