/*
 * Decompiled with CFR 0.152.
 */
package com.finndog.moogs_structures.misc.structurepiececounter;

import com.finndog.moogs_structures.MoogsStructuresCommon;
import com.finndog.moogs_structures.misc.structurepiececounter.StructurePieceCountsAdditionsMerger;
import com.finndog.moogs_structures.misc.structurepiececounter.StructurePieceCountsObj;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import com.mojang.logging.annotations.MethodsReturnNonnullByDefault;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.Identifier;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.Nullable;

public class StructurePieceCountsManager
extends SimpleJsonResourceReloadListener<JsonElement> {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().setLenient().disableHtmlEscaping().excludeFieldsWithoutExposeAnnotation().create();
    private static final Codec<JsonElement> JSON_ELEMENT_CODEC = Codec.PASSTHROUGH.xmap(dyn -> (JsonElement)dyn.convert((DynamicOps)JsonOps.INSTANCE).getValue(), je -> new Dynamic((DynamicOps)JsonOps.INSTANCE, je));
    private static final FileToIdConverter FILES = new FileToIdConverter("rs_pieces_spawn_counts", ".json");
    public static final StructurePieceCountsManager STRUCTURE_PIECE_COUNTS_MANAGER = new StructurePieceCountsManager();
    private Map<Identifier, List<StructurePieceCountsObj>> structureToPieceCountsObjs = new HashMap<Identifier, List<StructurePieceCountsObj>>();
    private final Map<Identifier, Map<Identifier, RequiredPieceNeeds>> cachedRequirePiecesMap = new HashMap<Identifier, Map<Identifier, RequiredPieceNeeds>>();
    private final Map<Identifier, Map<Identifier, Integer>> cachedMaxCountPiecesMap = new HashMap<Identifier, Map<Identifier, Integer>>();

    public StructurePieceCountsManager() {
        super(JSON_ELEMENT_CODEC, FILES);
    }

    protected void apply(Map<Identifier, JsonElement> prepared, ResourceManager resourceManager, ProfilerFiller profiler) {
        HashMap<Identifier, List<StructurePieceCountsObj>> mapBuilder = new HashMap<Identifier, List<StructurePieceCountsObj>>();
        prepared.forEach((fileId, jsonElement) -> {
            try {
                mapBuilder.put((Identifier)fileId, this.getStructurePieceCountsObjs((Identifier)fileId, (JsonElement)jsonElement));
            }
            catch (Exception e) {
                MoogsStructuresCommon.LOGGER.error("Moog's Structure Lib Error: Couldn't parse rs_pieces_spawn_counts file {} - JSON: {}", fileId, jsonElement, (Object)e);
            }
        });
        this.structureToPieceCountsObjs = mapBuilder;
        this.cachedRequirePiecesMap.clear();
        this.cachedMaxCountPiecesMap.clear();
        StructurePieceCountsAdditionsMerger.performCountsAdditionsDetectionAndMerger(resourceManager);
    }

    @MethodsReturnNonnullByDefault
    private List<StructurePieceCountsObj> getStructurePieceCountsObjs(Identifier fileIdentifier, JsonElement jsonElement) throws Exception {
        List piecesSpawnCounts = (List)GSON.fromJson(jsonElement.getAsJsonObject().get("pieces_spawn_counts"), new TypeToken<List<StructurePieceCountsObj>>(this){}.getType());
        for (int i = piecesSpawnCounts.size() - 1; i >= 0; --i) {
            StructurePieceCountsObj entry = (StructurePieceCountsObj)piecesSpawnCounts.get(i);
            if (entry.alwaysSpawnThisMany == null || entry.neverSpawnMoreThanThisMany == null || entry.alwaysSpawnThisMany <= entry.neverSpawnMoreThanThisMany) continue;
            throw new Exception("Moog's Structure Lib Error: Found " + entry.nbtPieceName + " entry has alwaysSpawnThisMany greater than neverSpawnMoreThanThisMany which is invalid.");
        }
        return piecesSpawnCounts;
    }

    public void parseAndAddCountsJSONObj(Identifier structureRL, List<JsonElement> jsonElements) {
        jsonElements.forEach(jsonElement -> {
            try {
                this.structureToPieceCountsObjs.computeIfAbsent(structureRL, rl -> new ArrayList()).addAll(this.getStructurePieceCountsObjs(structureRL, (JsonElement)jsonElement));
            }
            catch (Exception e) {
                MoogsStructuresCommon.LOGGER.error("Moog's Structure Lib Error: Couldn't parse rs_pieces_spawn_counts file {} - JSON: {}", (Object)structureRL, jsonElement, (Object)e);
            }
        });
    }

    @Nullable
    public Map<Identifier, RequiredPieceNeeds> getRequirePieces(Identifier structureRL) {
        if (!this.structureToPieceCountsObjs.containsKey(structureRL)) {
            return null;
        }
        if (this.cachedRequirePiecesMap.containsKey(structureRL)) {
            return this.cachedRequirePiecesMap.get(structureRL);
        }
        HashMap<Identifier, RequiredPieceNeeds> requirePiecesMap = new HashMap<Identifier, RequiredPieceNeeds>();
        List<StructurePieceCountsObj> list = this.structureToPieceCountsObjs.get(structureRL);
        if (list != null) {
            for (StructurePieceCountsObj entry : list) {
                if (entry.alwaysSpawnThisMany == null) continue;
                requirePiecesMap.put(Identifier.tryParse((String)entry.nbtPieceName), new RequiredPieceNeeds(entry.alwaysSpawnThisMany, entry.minimumDistanceFromCenterPiece != null ? entry.minimumDistanceFromCenterPiece : 0));
            }
        }
        this.cachedRequirePiecesMap.put(structureRL, requirePiecesMap);
        return requirePiecesMap;
    }

    @MethodsReturnNonnullByDefault
    public Map<Identifier, Integer> getMaximumCountForPieces(Identifier structureRL) {
        if (this.cachedMaxCountPiecesMap.containsKey(structureRL)) {
            return this.cachedMaxCountPiecesMap.get(structureRL);
        }
        HashMap<Identifier, Integer> maxCountPiecesMap = new HashMap<Identifier, Integer>();
        List<StructurePieceCountsObj> list = this.structureToPieceCountsObjs.get(structureRL);
        if (list != null) {
            for (StructurePieceCountsObj entry : list) {
                if (entry.neverSpawnMoreThanThisMany == null) continue;
                maxCountPiecesMap.put(Identifier.tryParse((String)entry.nbtPieceName), entry.neverSpawnMoreThanThisMany);
            }
        }
        this.cachedMaxCountPiecesMap.put(structureRL, maxCountPiecesMap);
        return maxCountPiecesMap;
    }

    public record RequiredPieceNeeds(int maxLimit, int minDistanceFromCenter) {
        public int getRequiredAmount() {
            return this.maxLimit;
        }

        public int getMinDistanceFromCenter() {
            return this.minDistanceFromCenter;
        }
    }
}

