/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.util;

import com.google.common.math.LongMath;
import java.text.NumberFormat;
import java.util.function.Supplier;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import snownee.jade.JadeClient;
import snownee.jade.api.ui.NarratableComponent;
import snownee.jade.overlay.DisplayHelper;
import snownee.jade.util.CommonProxy;

public class FluidTextHelper {
    private static final boolean FABRIC = "fabric".equals(CommonProxy.getPlatformIdentifier());
    public static final long BUCKET = FABRIC ? 81000L : 1000L;
    private static final char[] SUPERSCRIPT = new char[]{'\u2070', '\u00b9', '\u00b2', '\u00b3', '\u2074', '\u2075', '\u2076', '\u2077', '\u2078', '\u2079'};
    private static final char FRACTION_BAR = '\u2044';
    private static final char[] SUBSCRIPT = new char[]{'\u2080', '\u2081', '\u2082', '\u2083', '\u2084', '\u2085', '\u2086', '\u2087', '\u2088', '\u2089'};

    public static String getUnicodeFraction(long numerator, long denominator, boolean simplify) {
        if (numerator < 0L || denominator < 0L) {
            throw new IllegalArgumentException("Numerator and denominator must be non negative.");
        }
        if (simplify && denominator != 0L) {
            long g = LongMath.gcd((long)numerator, (long)denominator);
            numerator /= g;
            denominator /= g;
        }
        StringBuilder numString = new StringBuilder();
        while (numerator > 0L) {
            numString.append(SUPERSCRIPT[(int)(numerator % 10L)]);
            numerator /= 10L;
        }
        StringBuilder denomString = new StringBuilder();
        while (denominator > 0L) {
            denomString.append(SUBSCRIPT[(int)(denominator % 10L)]);
            denominator /= 10L;
        }
        return numString.reverse().toString() + "\u2044" + String.valueOf(denomString.reverse());
    }

    private static String getFractionNarration(long numerator, long denominator, boolean simplify) {
        String key;
        if (numerator < 0L || denominator < 0L) {
            throw new IllegalArgumentException("Numerator and denominator must be non negative.");
        }
        if (simplify && denominator != 0L) {
            long g = LongMath.gcd((long)numerator, (long)denominator);
            numerator /= g;
            denominator /= g;
        }
        if (I18n.exists((String)(key = "narration.jade.%s/%s".formatted(numerator, denominator)))) {
            return I18n.get((String)key, (Object[])new Object[0]);
        }
        return JadeClient.formatString("narration.jade.N/N", numerator, denominator);
    }

    public static NarratableComponent getMillibuckets(long integer, boolean simplify) {
        long g;
        if (!FABRIC) {
            return FluidTextHelper.makeString(integer, 0L, 0L, "mB");
        }
        long mb = integer / 81L;
        long leftover = integer % BUCKET;
        if (leftover == 0L || integer >= BUCKET * 100L) {
            String s = DisplayHelper.INSTANCE.humanReadableNumber(mb, "B", true);
            if (s.endsWith("mB")) {
                return FluidTextHelper.makeString(s.substring(0, s.length() - 2), mb, 0L, 0L, "mB");
            }
            return FluidTextHelper.makeString(s.substring(0, s.length() - 1), mb / 1000L, 0L, 0L, "B");
        }
        if (integer % 81L == 0L) {
            return FluidTextHelper.makeString(mb, 0L, 0L, "mB");
        }
        if (simplify && (g = LongMath.gcd((long)leftover, (long)BUCKET)) >= 1000L) {
            return FluidTextHelper.makeString(mb / 1000L, leftover / g, BUCKET / g, "B");
        }
        return FluidTextHelper.makeString(mb, integer % 81L, 81L, "mB");
    }

    private static NarratableComponent makeString(long integer, long numerator, long denominator, String unit) {
        return FluidTextHelper.makeString(integer == 0L && denominator != 0L ? "" : NumberFormat.getNumberInstance().format(integer), integer, numerator, denominator, unit);
    }

    private static NarratableComponent makeString(String integerString, long integer, long numerator, long denominator, String unit) {
        Supplier<String> narration;
        String string;
        if (denominator == 0L) {
            string = integerString + unit;
            narration = () -> integerString;
        } else if (integerString.isEmpty()) {
            string = FluidTextHelper.getUnicodeFraction(numerator, denominator, true) + unit;
            narration = () -> FluidTextHelper.getFractionNarration(numerator, denominator, true);
        } else {
            string = integerString + " " + FluidTextHelper.getUnicodeFraction(numerator, denominator, true) + unit;
            narration = () -> JadeClient.formatString("narration.jade.integer_and_fraction", integerString, FluidTextHelper.getFractionNarration(numerator, denominator, true));
        }
        return new NarratableComponent((Component)Component.literal((String)string), () -> {
            double number = integer;
            if (denominator != 0L) {
                number += (double)numerator / (double)denominator;
            }
            return JadeClient.formatString("narration.jade.unit." + unit, narration.get(), number);
        });
    }

    private FluidTextHelper() {
    }
}

