/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.config;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.HumanoidArm;
import org.jspecify.annotations.Nullable;
import snownee.jade.Jade;
import snownee.jade.JadeClient;
import snownee.jade.api.JadeIds;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.theme.Theme;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.config.ClientPluginConfig;
import snownee.jade.impl.config.entry.ConfigEntry;
import snownee.jade.impl.theme.ThemeHelper;
import snownee.jade.util.ClientProxy;
import snownee.jade.util.CommonProxy;
import snownee.jade.util.JadeCodecs;
import snownee.jade.util.JsonConfig;
import snownee.jade.util.ModIdentification;

public class WailaConfig
implements IWailaConfig {
    public static final int MAX_NAME_LENGTH = 100;
    public static final MapCodec<WailaConfig> MAP_CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.string((int)0, (int)100).optionalFieldOf("name", (Object)"").forGetter(IWailaConfig::getName), (App)General.CODEC.fieldOf("general").orElseGet(() -> JadeCodecs.createFromEmptyMap(General.CODEC)).forGetter(WailaConfig::general), (App)Overlay.CODEC.fieldOf("overlay").orElseGet(() -> JadeCodecs.createFromEmptyMap(Overlay.CODEC)).forGetter(WailaConfig::overlay), (App)Formatting.CODEC.fieldOf("formatting").orElseGet(() -> JadeCodecs.createFromEmptyMap(Formatting.CODEC)).forGetter(WailaConfig::formatting), (App)Accessibility.CODEC.fieldOf("accessibility").orElseGet(() -> JadeCodecs.createFromEmptyMap(Accessibility.CODEC)).forGetter(WailaConfig::accessibility), (App)ClientPluginConfig.CODEC.fieldOf("plugin").orElseGet(() -> JadeCodecs.createFromEmptyMap(ClientPluginConfig.CODEC)).forGetter(WailaConfig::plugin)).apply((Applicative)i, WailaConfig::new));
    private String name;
    private final General general;
    private final Overlay overlay;
    private final Formatting formatting;
    private final Accessibility accessibility;
    private final ClientPluginConfig plugin;

    public WailaConfig(String name, General general, Overlay overlay, Formatting formatting, Accessibility accessibility, ClientPluginConfig plugin) {
        this.name = name;
        this.general = general;
        this.overlay = overlay;
        this.formatting = formatting;
        this.accessibility = accessibility;
        this.plugin = plugin;
    }

    @Override
    public General general() {
        return this.general;
    }

    @Override
    public Overlay overlay() {
        return this.overlay;
    }

    @Override
    public Formatting formatting() {
        return this.formatting;
    }

    @Override
    public Accessibility accessibility() {
        return this.accessibility;
    }

    @Override
    public ClientPluginConfig plugin() {
        return this.plugin;
    }

    @Override
    public void save() {
        Jade.saveConfig();
    }

    @Override
    public void invalidate() {
        Jade.invalidateConfig();
    }

    public void fixData() {
        if (!CommonProxy.isPhysicallyClient()) {
            return;
        }
        for (ConfigEntry<?> entry : WailaClientRegistration.instance().configEntries.values()) {
            this.plugin.ensureEntry(entry);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public static void init() {
        General.itemModNameTooltipDisabledByModsNames.clear();
        General.itemModNameTooltipDisabledByMods.stream().filter(CommonProxy::isModLoaded).map($ -> ModIdentification.getModFullName($).orElse((String)$)).forEach(General.itemModNameTooltipDisabledByModsNames::add);
        boolean hasAccessibilityMod = ClientProxy.hasAccessibilityMod();
        if (Jade.history().accessibilityModMemory != hasAccessibilityMod) {
            Jade.history().accessibilityModMemory = hasAccessibilityMod;
            for (JsonConfig<? extends WailaConfig> config : Jade.configs()) {
                config.get().accessibility().setEnableAccessibilityPlugin(hasAccessibilityMod);
                config.save();
            }
        }
    }

    public static class General
    implements IWailaConfig.General {
        public static final Codec<General> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.BOOL.fieldOf("displayTooltip").orElse((Object)true).forGetter(General::shouldDisplayTooltip), (App)Codec.BOOL.fieldOf("displayBlocks").orElse((Object)true).forGetter(General::getDisplayBlocks), (App)Codec.BOOL.fieldOf("displayEntities").orElse((Object)true).forGetter(General::getDisplayEntities), (App)Codec.BOOL.fieldOf("displayBosses").orElse((Object)true).forGetter(General::getDisplayBosses), (App)StringRepresentable.fromEnum(IWailaConfig.DisplayMode::values).fieldOf("displayMode").orElse((Object)IWailaConfig.DisplayMode.TOGGLE).forGetter(General::getDisplayMode), (App)StringRepresentable.fromEnum(IWailaConfig.FluidMode::values).fieldOf("fluidMode").orElse((Object)IWailaConfig.FluidMode.ANY).forGetter(General::getDisplayFluids), (App)StringRepresentable.fromEnum(IWailaConfig.PerspectiveMode::values).fieldOf("perspectiveMode").orElse((Object)IWailaConfig.PerspectiveMode.CAMERA).forGetter(General::getPerspectiveMode), (App)Codec.floatRange((float)0.0f, (float)20.0f).fieldOf("extendedReach").orElse((Object)Float.valueOf(0.0f)).forGetter(General::getExtendedReach), (App)Codec.BOOL.fieldOf("debug").orElse((Object)false).forGetter(General::isDebug), (App)Codec.BOOL.fieldOf("itemModNameTooltip").orElse((Object)true).forGetter(General::showItemModNameTooltip), (App)StringRepresentable.fromEnum(IWailaConfig.BossBarOverlapMode::values).fieldOf("bossBarOverlapMode").orElse((Object)IWailaConfig.BossBarOverlapMode.PUSH_DOWN).forGetter(General::getBossBarOverlapMode), (App)Codec.BOOL.fieldOf("builtinCamouflage").orElse((Object)true).forGetter(General::getBuiltinCamouflage), (App)ExtraOptions.CODEC.orElseGet(() -> (ExtraOptions)JadeCodecs.createFromEmptyMap(ExtraOptions.CODEC.codec())).forGetter($ -> $.extraOptions)).apply((Applicative)i, General::new));
        public static final List<String> itemModNameTooltipDisabledByMods = Lists.newArrayList();
        public static final List<String> itemModNameTooltipDisabledByModsNames = Lists.newArrayList();
        private boolean displayTooltip;
        private boolean displayBlocks;
        private boolean displayEntities;
        private boolean displayBosses;
        private IWailaConfig.DisplayMode displayMode;
        private IWailaConfig.FluidMode fluidMode;
        private float extendedReach;
        private boolean debug;
        private boolean itemModNameTooltip;
        private IWailaConfig.BossBarOverlapMode bossBarOverlapMode;
        private boolean builtinCamouflage;
        private IWailaConfig.PerspectiveMode perspectiveMode;
        private final ExtraOptions extraOptions;

        public General(boolean displayTooltip, boolean displayBlocks, boolean displayEntities, boolean displayBosses, IWailaConfig.DisplayMode displayMode, IWailaConfig.FluidMode fluidMode, IWailaConfig.PerspectiveMode perspectiveMode, float extendedReach, boolean debug, boolean itemModNameTooltip, IWailaConfig.BossBarOverlapMode bossBarOverlapMode, boolean builtinCamouflage, ExtraOptions extraOptions) {
            this.displayTooltip = displayTooltip;
            this.displayBlocks = displayBlocks;
            this.displayEntities = displayEntities;
            this.displayBosses = displayBosses;
            this.displayMode = displayMode;
            this.fluidMode = fluidMode;
            this.perspectiveMode = perspectiveMode;
            this.extendedReach = extendedReach;
            this.debug = debug;
            this.itemModNameTooltip = itemModNameTooltip;
            this.bossBarOverlapMode = bossBarOverlapMode;
            this.builtinCamouflage = builtinCamouflage;
            this.extraOptions = extraOptions;
        }

        @Override
        public void setDisplayTooltip(boolean displayTooltip) {
            this.displayTooltip = displayTooltip;
        }

        @Override
        public boolean getDisplayEntities() {
            return this.displayEntities;
        }

        @Override
        public void setDisplayEntities(boolean displayEntities) {
            this.displayEntities = displayEntities;
        }

        @Override
        public boolean getDisplayBlocks() {
            return this.displayBlocks;
        }

        @Override
        public void setDisplayBlocks(boolean displayBlocks) {
            this.displayBlocks = displayBlocks;
        }

        @Override
        public boolean shouldDisplayTooltip() {
            return this.displayTooltip;
        }

        @Override
        public IWailaConfig.DisplayMode getDisplayMode() {
            return this.displayMode;
        }

        @Override
        public void setDisplayMode(IWailaConfig.DisplayMode displayMode) {
            this.displayMode = displayMode;
        }

        @Override
        public boolean shouldDisplayFluids() {
            return this.fluidMode != IWailaConfig.FluidMode.NONE;
        }

        @Override
        public IWailaConfig.FluidMode getDisplayFluids() {
            return this.fluidMode;
        }

        @Override
        public void setDisplayFluids(boolean displayFluids) {
            this.fluidMode = displayFluids ? IWailaConfig.FluidMode.ANY : IWailaConfig.FluidMode.NONE;
        }

        @Override
        public void setDisplayFluids(IWailaConfig.FluidMode displayFluids) {
            this.fluidMode = displayFluids;
        }

        @Override
        public float getExtendedReach() {
            return this.extendedReach;
        }

        @Override
        public void setExtendedReach(float extendedReach) {
            this.extendedReach = Mth.clamp((float)extendedReach, (float)0.0f, (float)20.0f);
        }

        @Override
        public boolean isDebug() {
            return this.debug;
        }

        @Override
        public void setDebug(boolean debug) {
            this.debug = debug;
        }

        @Override
        public void setItemModNameTooltip(boolean itemModNameTooltip) {
            this.itemModNameTooltip = itemModNameTooltip;
        }

        @Override
        public boolean showItemModNameTooltip() {
            return this.itemModNameTooltip && itemModNameTooltipDisabledByModsNames.isEmpty();
        }

        @Override
        public IWailaConfig.BossBarOverlapMode getBossBarOverlapMode() {
            return this.bossBarOverlapMode;
        }

        @Override
        public void setBossBarOverlapMode(IWailaConfig.BossBarOverlapMode mode) {
            this.bossBarOverlapMode = mode;
        }

        @Override
        public void setHideFromTabList(boolean hideFromTabList) {
            this.extraOptions.setHideFromTabList(hideFromTabList);
        }

        @Override
        public void setHideFromGUIs(boolean hideFromGUIs) {
            this.extraOptions.setHideFromGUIs(hideFromGUIs);
        }

        @Override
        public boolean shouldHideFromTabList() {
            return this.extraOptions.hideFromTabList();
        }

        @Override
        public boolean shouldHideFromGUIs() {
            return this.extraOptions.hideFromGUIs();
        }

        @Override
        public boolean getDisplayBosses() {
            return this.displayBosses;
        }

        @Override
        public void setDisplayBosses(boolean displayBosses) {
            this.displayBosses = displayBosses;
        }

        @Override
        public boolean getBuiltinCamouflage() {
            return this.builtinCamouflage;
        }

        @Override
        public void setBuiltinCamouflage(boolean builtinCamouflage) {
            this.builtinCamouflage = builtinCamouflage;
        }

        @Override
        public IWailaConfig.PerspectiveMode getPerspectiveMode() {
            return this.perspectiveMode;
        }

        @Override
        public void setPerspectiveMode(IWailaConfig.PerspectiveMode perspectiveMode) {
            this.perspectiveMode = perspectiveMode;
        }

        public static final class ExtraOptions {
            public static final MapCodec<ExtraOptions> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.BOOL.fieldOf("hideFromTabList").orElse((Object)true).forGetter(ExtraOptions::hideFromTabList), (App)Codec.BOOL.fieldOf("hideFromGUIs").orElse((Object)true).forGetter(ExtraOptions::hideFromGUIs)).apply((Applicative)i, ExtraOptions::new));
            private boolean hideFromTabList;
            private boolean hideFromGUIs;

            public ExtraOptions(boolean hideFromTabList, boolean hideFromGUIs) {
                this.hideFromTabList = hideFromTabList;
                this.hideFromGUIs = hideFromGUIs;
            }

            public boolean hideFromTabList() {
                return this.hideFromTabList;
            }

            public boolean hideFromGUIs() {
                return this.hideFromGUIs;
            }

            public void setHideFromTabList(boolean hideFromTabList) {
                this.hideFromTabList = hideFromTabList;
            }

            public void setHideFromGUIs(boolean hideFromGUIs) {
                this.hideFromGUIs = hideFromGUIs;
            }
        }
    }

    public static class Overlay
    implements IWailaConfig.Overlay {
        public static final Codec<Overlay> CODEC = RecordCodecBuilder.create(i -> i.group((App)Identifier.CODEC.fieldOf("activeTheme").orElse((Object)JadeIds.DEFAULT_THEME).forGetter($ -> $.activeTheme), (App)Codec.FLOAT.fieldOf("overlayPosX").orElse((Object)Float.valueOf(0.5f)).forGetter(Overlay::getOverlayPosX), (App)Codec.FLOAT.fieldOf("overlayPosY").orElse((Object)Float.valueOf(1.0f)).forGetter(Overlay::getOverlayPosY), (App)Codec.floatRange((float)0.2f, (float)2.0f).fieldOf("overlayScale").orElse((Object)Float.valueOf(1.0f)).forGetter(Overlay::getOverlayScale), (App)Codec.FLOAT.fieldOf("overlayAnchorX").orElse((Object)Float.valueOf(0.5f)).forGetter(Overlay::getAnchorX), (App)Codec.FLOAT.fieldOf("overlayAnchorY").orElse((Object)Float.valueOf(0.0f)).forGetter(Overlay::getAnchorY), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("autoScaleThreshold").orElse((Object)Float.valueOf(0.4f)).forGetter(Overlay::getAutoScaleThreshold), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("alpha").orElse((Object)Float.valueOf(0.7f)).forGetter(Overlay::getAlpha), (App)StringRepresentable.fromEnum(IWailaConfig.IconMode::values).fieldOf("iconMode").orElse((Object)IWailaConfig.IconMode.TOP).forGetter(Overlay::getIconMode), (App)Codec.BOOL.fieldOf("animation").orElse((Object)true).forGetter(Overlay::getAnimation), (App)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE).fieldOf("disappearingDelay").orElse((Object)Float.valueOf(0.0f)).forGetter(Overlay::getDisappearingDelay)).apply((Applicative)i, Overlay::new));
        public Identifier activeTheme;
        private float overlayPosX;
        private float overlayPosY;
        private float overlayScale;
        private float overlayAnchorX;
        private float overlayAnchorY;
        private float autoScaleThreshold;
        private float alpha;
        private transient @Nullable Theme activeThemeInstance;
        private IWailaConfig.IconMode iconMode;
        private boolean animation;
        private float disappearingDelay;

        public Overlay(Identifier activeTheme, float overlayPosX, float overlayPosY, float overlayScale, float overlayAnchorX, float overlayAnchorY, float autoScaleThreshold, float alpha, IWailaConfig.IconMode iconMode, boolean animation, float disappearingDelay) {
            this.activeTheme = activeTheme;
            this.overlayPosX = overlayPosX;
            this.overlayPosY = overlayPosY;
            this.overlayScale = overlayScale;
            this.overlayAnchorX = overlayAnchorX;
            this.overlayAnchorY = overlayAnchorY;
            this.autoScaleThreshold = autoScaleThreshold;
            this.alpha = alpha;
            this.iconMode = iconMode;
            this.animation = animation;
            this.disappearingDelay = disappearingDelay;
        }

        @Override
        public float getOverlayPosX() {
            return Mth.clamp((float)this.overlayPosX, (float)0.0f, (float)1.0f);
        }

        @Override
        public void setOverlayPosX(float overlayPosX) {
            this.overlayPosX = Mth.clamp((float)overlayPosX, (float)0.0f, (float)1.0f);
        }

        @Override
        public float getOverlayPosY() {
            return Mth.clamp((float)this.overlayPosY, (float)0.0f, (float)1.0f);
        }

        @Override
        public void setOverlayPosY(float overlayPosY) {
            this.overlayPosY = Mth.clamp((float)overlayPosY, (float)0.0f, (float)1.0f);
        }

        @Override
        public float getOverlayScale() {
            return this.overlayScale;
        }

        @Override
        public void setOverlayScale(float overlayScale) {
            this.overlayScale = Mth.clamp((float)overlayScale, (float)0.2f, (float)2.0f);
        }

        @Override
        public float getAnchorX() {
            return Mth.clamp((float)this.overlayAnchorX, (float)0.0f, (float)1.0f);
        }

        @Override
        public void setAnchorX(float overlayAnchorX) {
            this.overlayAnchorX = Mth.clamp((float)overlayAnchorX, (float)0.0f, (float)1.0f);
        }

        @Override
        public float getAnchorY() {
            return Mth.clamp((float)this.overlayAnchorY, (float)0.0f, (float)1.0f);
        }

        @Override
        public void setAnchorY(float overlayAnchorY) {
            this.overlayAnchorY = Mth.clamp((float)overlayAnchorY, (float)0.0f, (float)1.0f);
        }

        @Override
        public float getAutoScaleThreshold() {
            return this.autoScaleThreshold;
        }

        @Override
        public float getAlpha() {
            return this.alpha;
        }

        @Override
        public void setAlpha(float alpha) {
            this.alpha = Mth.clamp((float)alpha, (float)0.0f, (float)1.0f);
        }

        @Override
        public Theme getTheme() {
            if (this.activeThemeInstance == null) {
                this.applyTheme(this.activeTheme);
            }
            return this.activeThemeInstance;
        }

        @Override
        public void applyTheme(Identifier id) {
            try {
                this.activeThemeInstance = IThemeHelper.get().getTheme(id);
            }
            catch (Exception e) {
                Jade.LOGGER.error("Failed to apply theme", (Throwable)e);
                this.activeThemeInstance = IThemeHelper.get().getTheme(JadeIds.DEFAULT_THEME);
            }
            this.activeTheme = this.activeThemeInstance.fullId();
            ((ThemeHelper)IThemeHelper.get()).setTheme(this.activeThemeInstance);
        }

        @Override
        public IWailaConfig.IconMode getIconMode() {
            return this.iconMode;
        }

        @Override
        public void setIconMode(IWailaConfig.IconMode iconMode) {
            this.iconMode = iconMode;
        }

        @Override
        public boolean shouldShowIcon() {
            return this.iconMode != IWailaConfig.IconMode.HIDE;
        }

        @Override
        public boolean getAnimation() {
            return this.animation;
        }

        @Override
        public void setAnimation(boolean animation) {
            this.animation = animation;
        }

        @Override
        public float getDisappearingDelay() {
            return this.disappearingDelay;
        }

        @Override
        public void setDisappearingDelay(float delay) {
            this.disappearingDelay = delay;
        }
    }

    public static class Formatting
    implements IWailaConfig.Formatting {
        public static final Codec<Formatting> CODEC = RecordCodecBuilder.create(i -> i.group((App)Style.Serializer.CODEC.fieldOf("itemModNameStyle").orElseGet(() -> Style.EMPTY.applyFormats(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC})).forGetter(Formatting::getItemModNameStyle)).apply((Applicative)i, Formatting::new));
        private Style itemModNameStyle;

        public Formatting(Style itemModNameStyle) {
            this.itemModNameStyle = itemModNameStyle;
        }

        @Override
        public Style getItemModNameStyle() {
            return this.itemModNameStyle;
        }

        @Override
        public void setItemModNameStyle(Style itemModNameStyle) {
            this.itemModNameStyle = itemModNameStyle;
        }

        @Override
        public Component registryName(String name) {
            return Component.literal((String)name).withStyle(IThemeHelper.get().isLightColorScheme() ? ChatFormatting.DARK_GRAY : ChatFormatting.GRAY);
        }
    }

    public static class Accessibility
    implements IWailaConfig.Accessibility {
        public static final Codec<Accessibility> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.BOOL.fieldOf("enableTextToSpeech").orElse((Object)false).forGetter(Accessibility::shouldEnableTextToSpeech), (App)StringRepresentable.fromEnum(IWailaConfig.TTSMode::values).fieldOf("ttsMode").orElse((Object)IWailaConfig.TTSMode.TOGGLE).forGetter(Accessibility::getTTSMode), (App)Codec.BOOL.fieldOf("enableAccessibilityPlugin").orElse((Object)false).forGetter(Accessibility::getEnableAccessibilityPlugin), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("textBackgroundOpacity").orElse((Object)Float.valueOf(0.0f)).forGetter(Accessibility::getTextBackgroundOpacity), (App)Codec.BOOL.fieldOf("flipMainHand").orElse((Object)false).forGetter(Accessibility::getFlipMainHand), (App)Codec.BOOL.fieldOf("narrateKeys").orElse((Object)false).forGetter(Accessibility::getNarrateKeys)).apply((Applicative)i, Accessibility::new));
        private boolean enableTextToSpeech;
        private IWailaConfig.TTSMode ttsMode;
        private boolean enableAccessibilityPlugin;
        private float textBackgroundOpacity;
        private boolean flipMainHand;
        private boolean narrateKeys;

        public Accessibility(boolean enableTextToSpeech, IWailaConfig.TTSMode ttsMode, boolean enableAccessibilityPlugin, float textBackgroundOpacity, boolean flipMainHand, boolean narrateKeys) {
            this.enableTextToSpeech = enableTextToSpeech;
            this.ttsMode = ttsMode;
            this.enableAccessibilityPlugin = enableAccessibilityPlugin;
            this.textBackgroundOpacity = textBackgroundOpacity;
            this.flipMainHand = flipMainHand;
            this.narrateKeys = narrateKeys;
        }

        @Override
        public boolean shouldEnableTextToSpeech() {
            return this.ttsMode == IWailaConfig.TTSMode.TOGGLE && this.enableTextToSpeech;
        }

        @Override
        public void toggleTTS() {
            this.enableTextToSpeech = !this.enableTextToSpeech;
        }

        @Override
        public IWailaConfig.TTSMode getTTSMode() {
            return this.ttsMode;
        }

        @Override
        public void setTTSMode(IWailaConfig.TTSMode ttsMode) {
            this.ttsMode = ttsMode;
        }

        @Override
        public boolean getEnableAccessibilityPlugin() {
            return this.enableAccessibilityPlugin;
        }

        @Override
        public void setEnableAccessibilityPlugin(boolean enableAccessibilityPlugin) {
            this.enableAccessibilityPlugin = enableAccessibilityPlugin;
        }

        @Override
        public boolean getFlipMainHand() {
            return this.flipMainHand;
        }

        @Override
        public void setFlipMainHand(boolean overlaySquare) {
            this.flipMainHand = overlaySquare;
        }

        @Override
        public float tryFlip(float f) {
            if (this.flipMainHand && Minecraft.getInstance().options.mainHand().get() == HumanoidArm.LEFT) {
                f = 1.0f - f;
            }
            return f;
        }

        @Override
        public void setTextBackgroundOpacity(float opacity) {
            this.textBackgroundOpacity = opacity;
        }

        @Override
        public float getTextBackgroundOpacity() {
            return this.textBackgroundOpacity;
        }

        @Override
        public void setNarrateKeys(boolean narrateKeys) {
            this.narrateKeys = narrateKeys;
        }

        @Override
        public boolean getNarrateKeys() {
            return this.narrateKeys;
        }
    }

    public static class History {
        public static final Codec<History> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.BOOL.fieldOf("previewOverlay").orElse((Object)true).forGetter($ -> $.previewOverlay), (App)Codec.BOOL.fieldOf("hintOverlayToggle").orElse((Object)true).forGetter($ -> $.hintOverlayToggle), (App)Codec.BOOL.fieldOf("hintNarratorToggle").orElse((Object)true).forGetter($ -> $.hintNarratorToggle), (App)Codec.BOOL.fieldOf("accessibilityModMemory").orElse((Object)false).forGetter($ -> $.accessibilityModMemory), (App)Codec.INT.fieldOf("themesHash").orElse((Object)0).forGetter($ -> $.themesHash), (App)JadeCodecs.intArrayCodec(0, (Codec<Integer>)Codec.INT).fieldOf("usersHash").orElse((Object)new int[0]).forGetter($ -> $.usersHash)).apply((Applicative)i, History::new));
        public boolean previewOverlay;
        public boolean hintOverlayToggle;
        public boolean hintNarratorToggle;
        public boolean accessibilityModMemory;
        public int themesHash;
        public int[] usersHash;

        public History(boolean previewOverlay, boolean hintOverlayToggle, boolean hintNarratorToggle, boolean accessibilityModMemory, int themesHash, int[] usersHash) {
            this.previewOverlay = previewOverlay;
            this.hintOverlayToggle = hintOverlayToggle;
            this.hintNarratorToggle = hintNarratorToggle;
            this.accessibilityModMemory = accessibilityModMemory;
            this.themesHash = themesHash;
            this.usersHash = usersHash;
        }

        public void checkNewUser(int hash) {
            if (this.usersHash.length > 0 && this.usersHash[0] == 0) {
                return;
            }
            for (int i : this.usersHash) {
                if (i != hash) continue;
                return;
            }
            int[] newUsersHash = new int[this.usersHash.length + 1];
            System.arraycopy(this.usersHash, 0, newUsersHash, 0, this.usersHash.length);
            newUsersHash[this.usersHash.length] = hash;
            this.usersHash = newUsersHash;
            this.previewOverlay = true;
            this.hintOverlayToggle = true;
            this.hintNarratorToggle = true;
        }
    }

    public static class Root
    extends WailaConfig {
        public static final Codec<Root> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.BOOL.fieldOf("enableProfiles").orElse((Object)false).forGetter($ -> $.enableProfiles), (App)Codec.intRange((int)0, (int)3).fieldOf("profileIndex").orElse((Object)0).forGetter($ -> $.profileIndex), (App)MAP_CODEC.forGetter($ -> $), (App)History.CODEC.fieldOf("history").orElseGet(() -> JadeCodecs.createFromEmptyMap(History.CODEC)).forGetter($ -> $.history)).apply((Applicative)i, Root::new));
        private boolean enableProfiles;
        public int profileIndex;
        public History history;

        public Root(boolean enableProfiles, int profileIndex, WailaConfig config, History history) {
            super(config.name, config.general, config.overlay, config.formatting, config.accessibility, config.plugin);
            this.enableProfiles = enableProfiles;
            this.profileIndex = profileIndex;
            this.history = history;
        }

        public void setEnableProfiles(boolean enableProfiles) {
            this.enableProfiles = enableProfiles;
            JadeClient.refreshKeyState();
            if (!enableProfiles) {
                this.profileIndex = 0;
            }
        }

        public boolean isEnableProfiles() {
            return this.enableProfiles;
        }
    }
}

